//	Zinc Application Framework - TIME.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "maintest.hpp"
#include "format.hpp"

// This table contains the list of all attributes that can be set on this 
// object.  AttributeTable.count gets updated by GenericTestWin::Event().
// This list is used to create the attribute chack boxes in the attribute 
// list.
ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafTime
	{ ZAF_ITEXT("Auto clear *"),      0, TST_TOGGLE_AUTO_CLEAR },
	{ ZAF_ITEXT("Invalid *"),         0, TST_TOGGLE_INVALID },
	{ ZAF_ITEXT("Lower case"),        0, TST_TOGGLE_LOWERCASE },
	{ ZAF_ITEXT("Password"),          0, TST_TOGGLE_PASSWORD },
	{ ZAF_ITEXT("Unanswered *"),      0, TST_TOGGLE_UNANSWERED },
	{ ZAF_ITEXT("Upper case"),        0, TST_TOGGLE_UPPERCASE },
	{ ZAF_ITEXT("Variable name"),     0, TST_TOGGLE_VARIABLENAME },
	{ ZAF_ITEXT("View only"),         0, TST_TOGGLE_VIEW_ONLY },

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),         0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

// ---- Derived test object -------------------------------------------------

class TestObj : public ZafTime
{
public:
  	TestObj();
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj() : ZafTime(50, 1, 15, ZAF_NULLP(ZafTimeData))
{
	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafTime::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 11)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	ZafTimeData *sharedData = new ZafTimeData;

	// Set the title text.
	SetText(ZAF_ITEXT("Time"));

	ZafStringData *inputFormatData = new ZafStringData(zafLocale->timeStringInputFormat, 256);
	ZafStringData *outputFormatData = new ZafStringData(zafLocale->time12StringOutputFormat, 64);

	// Create horizontal justify combo box.
	ZafComboBox *hzJustifyCombo = new ZafComboBox(27, 1, 20, 3);
	hzJustifyCombo->SetViewOnly(true);
	hzJustifyCombo->SetStringID(ZAF_ITEXT("HZ_JUSTIFY_COMBO"));
	hzJustifyCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	ZafButton *attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz left"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_LEFT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz center"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_CENTER);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz right"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_RIGHT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT);
	hzJustifyCombo->Add(attr);

	Add(hzJustifyCombo);

	// Add the test object.
	testObject = new TestObj;
	DynamicPtrCast(testObject, ZafTime)->SetTimeData(sharedData);
	DynamicPtrCast(testObject, ZafTime)->SetInputFormatData(inputFormatData);
	DynamicPtrCast(testObject, ZafTime)->SetOutputFormatData(outputFormatData);
	Add(testObject);

	// Add other objects needed to test the object.
	ZafTime *time = new ZafTime(50, 2, 15, sharedData);
	time->SetAcceptDrop(true);
	time->SetCopyDraggable(true);
	time->SetMoveDraggable(true);
	Add(time);

	time = new ZafTime(50, 5, 15, new ZafTimeData);
	time->SetAcceptDrop(true);
	time->SetCopyDraggable(true);
	time->SetMoveDraggable(true);
	Add(time);

	ZafPrompt *prompt = new ZafPrompt(0, 8, 16, new ZafStringData("Input Format:"));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	FormatString *formatString = new FormatString(17, 8, 25, inputFormatData);
	Add(formatString);

	prompt = new ZafPrompt(0, 9, 16, ZafStringData("Output Format:"));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	formatString = new FormatString(17, 9, 25, outputFormatData);
	Add(formatString);
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafTime *time = DynamicPtrCast(testObject, ZafTime);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.
	case TST_TOGGLE_AUTO_CLEAR:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_CLEAR);
			time->SetAutoClear(attr->Selected());
			attr->SetSelected(time->AutoClear());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_INVALID:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_INVALID);
			time->SetInvalid(attr->Selected());
			attr->SetSelected(time->Invalid());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_LOWERCASE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_LOWERCASE);
			time->SetLowerCase(attr->Selected());
			attr->SetSelected(time->LowerCase());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_PASSWORD:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_PASSWORD);
			time->SetPassword(attr->Selected());
			attr->SetSelected(time->Password());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_UNANSWERED:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_UNANSWERED);
			time->SetUnanswered(attr->Selected());
			attr->SetSelected(time->Unanswered());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_UPPERCASE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_UPPERCASE);
			time->SetUpperCase(attr->Selected());
			attr->SetSelected(time->UpperCase());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_VARIABLENAME:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_VARIABLENAME);
			time->SetVariableName(attr->Selected());
			attr->SetSelected(time->VariableName());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_VIEW_ONLY:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_VIEW_ONLY);
			time->SetViewOnly(attr->Selected());
			attr->SetSelected(time->ViewOnly());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_SET_HZ_JUSTIFY_LEFT:
	case TST_SET_HZ_JUSTIFY_CENTER:
	case TST_SET_HZ_JUSTIFY_RIGHT:
		{
		 	if (ccode == TST_SET_HZ_JUSTIFY_LEFT)
				time->SetHzJustify(ZAF_HZ_LEFT);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_CENTER)
				time->SetHzJustify(ZAF_HZ_CENTER);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_RIGHT)
				time->SetHzJustify(ZAF_HZ_RIGHT);

			ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
			switch (time->HzJustify())
			{
			case ZAF_HZ_LEFT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
				break;

			case ZAF_HZ_CENTER:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
				break;

			case ZAF_HZ_RIGHT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
				break;
			}
		}
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafTime *time = DynamicPtrCast(testObject, ZafTime);
 
	// Preset attributes according to test object's settings.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_CLEAR)->SetSelected(time->AutoClear());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_INVALID)->SetSelected(time->Invalid());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_LOWERCASE)->SetSelected(time->LowerCase());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_PASSWORD)->SetSelected(time->Password());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_UNANSWERED)->SetSelected(time->Unanswered());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_UPPERCASE)->SetSelected(time->UpperCase());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_VARIABLENAME)->SetSelected(time->VariableName());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_VIEW_ONLY)->SetSelected(time->ViewOnly());

	ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
	switch (time->HzJustify())
	{
	case ZAF_HZ_LEFT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
		break;

	case ZAF_HZ_CENTER:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
		break;

	case ZAF_HZ_RIGHT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
		break;
	}

	GenericTestWin::SynchronizeAttributes();

	// Set settings fields disabled.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_LOWERCASE)->SetDisabled(true);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_PASSWORD)->SetDisabled(true);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_UPPERCASE)->SetDisabled(true);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_VARIABLENAME)->SetDisabled(true);
}
