//	Zinc Application Framework - TEXT.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "maintest.hpp"

// This table contains the list of all attributes that can be set on this 
// object.  AttributeTable.count gets updated by GenericTestWin::Event().
// This list is used to create the attribute chack boxes in the attribute 
// list.
ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafText
	{ ZAF_ITEXT("Auto clear *"),      0, TST_TOGGLE_AUTO_CLEAR },
	{ ZAF_ITEXT("Invalid *"),         0, TST_TOGGLE_INVALID },
	{ ZAF_ITEXT("Unanswered *"),      0, TST_TOGGLE_UNANSWERED },
	{ ZAF_ITEXT("Vertical scroll"),   0, TST_TOGGLE_VERTICAL_SCROLL },
	{ ZAF_ITEXT("Horizontal scroll"), 0, TST_TOGGLE_HORIZONTAL_SCROLL },
	{ ZAF_ITEXT("Word wrap *"),         0, TST_TOGGLE_WORD_WRAP },
	{ ZAF_ITEXT("View only"),       0, TST_TOGGLE_VIEW_ONLY },

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
//	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
//	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),       0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

// ---- Derived test object -------------------------------------------------

class TestObj : public ZafText
{
public:
  	TestObj();
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj() : ZafText(50, 1, 15, 3, ZAF_NULLP(ZafStringData))
{
	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafText::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 12)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	ZafStringData *sharedData = new ZafStringData("Test text", 1024);

	// Set the title text.
	SetText(ZAF_ITEXT("Text"));

	// Create horizontal justify combo box.
	ZafComboBox *hzJustifyCombo = new ZafComboBox(27, 1, 20, 3);
	hzJustifyCombo->SetViewOnly(true);
	hzJustifyCombo->SetStringID(ZAF_ITEXT("HZ_JUSTIFY_COMBO"));
	hzJustifyCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	ZafButton *attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz left"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_LEFT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz center"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_CENTER);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz right"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_RIGHT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT);
	hzJustifyCombo->Add(attr);

	Add(hzJustifyCombo);

	// Add the test object.
	testObject = new TestObj;
	DynamicPtrCast(testObject, ZafText)->SetStringData(sharedData);
	Add(testObject);

	// Add other objects needed to test the object.
	ZafText *text = new ZafText(50, 4, 15, 3, sharedData);
	text->SetAcceptDrop(true);
	text->SetCopyDraggable(true);
	text->SetMoveDraggable(true);
	Add(text);

	text = new ZafText(50, 7, 15, 3, new ZafStringData("Drag & drop", 64));
	text->SetAcceptDrop(true);
	text->SetCopyDraggable(true);
	text->SetMoveDraggable(true);
	Add(text);
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafText *text = DynamicPtrCast(testObject, ZafText);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.
	case TST_TOGGLE_AUTO_CLEAR:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_CLEAR);
			text->SetAutoClear(attr->Selected());
			attr->SetSelected(text->AutoClear());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_INVALID:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_INVALID);
			text->SetInvalid(attr->Selected());
			attr->SetSelected(text->Invalid());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_UNANSWERED:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_UNANSWERED);
			text->SetUnanswered(attr->Selected());
			attr->SetSelected(text->Unanswered());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_VIEW_ONLY:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_VIEW_ONLY);
			text->SetViewOnly(attr->Selected());
			attr->SetSelected(text->ViewOnly());
		}
		break;

	case TST_SET_HZ_JUSTIFY_LEFT:
	case TST_SET_HZ_JUSTIFY_CENTER:
	case TST_SET_HZ_JUSTIFY_RIGHT:
		{
		 	if (ccode == TST_SET_HZ_JUSTIFY_LEFT)
				text->SetHzJustify(ZAF_HZ_LEFT);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_CENTER)
				text->SetHzJustify(ZAF_HZ_CENTER);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_RIGHT)
				text->SetHzJustify(ZAF_HZ_RIGHT);

			ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
			switch (text->HzJustify())
			{
			case ZAF_HZ_LEFT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
				break;

			case ZAF_HZ_CENTER:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
				break;

			case ZAF_HZ_RIGHT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
				break;
			}
		}
		break;

	case TST_TOGGLE_WORD_WRAP:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_WORD_WRAP);
			text->SetWordWrap(attr->Selected());
			attr->SetSelected(text->WordWrap());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_VERTICAL_SCROLL:
		{
			ZafScrollBar *hScroll = text->HorizontalScrollBar();
			ZafScrollBar *vScroll = text->VerticalScrollBar();
			ZafScrollBar *cScroll = text->CornerScrollBar();

			if (hScroll)
				text->Subtract(hScroll);
			if (cScroll)
				text->Subtract(cScroll);

			if (!vScroll)
			{
				if (hScroll)
				{
					if (!cScroll)
						cScroll = new ZafScrollBar(0, 0, 0, 0, 0, 0, 0, 0, 0, ZAF_CORNER_SCROLL);
					text->Add(cScroll);
					text->Add(hScroll);
				}
				vScroll = new ZafScrollBar(0, 0, 0, 0);
				text->Add(vScroll);
			}
			else
			{
				text->Subtract(vScroll);
				delete vScroll;
				if (hScroll)
					text->Add(hScroll);
				if (cScroll)
					delete cScroll;
			}
			attrList->GetObject((ZafNumberID)TST_TOGGLE_VERTICAL_SCROLL)->SetSelected(text->VerticalScrollBar() ? true : false);

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_HORIZONTAL_SCROLL:
		{
			ZafScrollBar *hScroll = text->HorizontalScrollBar();
			ZafScrollBar *vScroll = text->VerticalScrollBar();
			ZafScrollBar *cScroll = text->CornerScrollBar();

			if (vScroll)
				text->Subtract(vScroll);
			if (cScroll)
				text->Subtract(cScroll);

			if (!hScroll)
			{
				if (vScroll)
				{
					if (!cScroll)
						cScroll = new ZafScrollBar(0, 0, 0, 0, 0, 0, 0, 0, 0, ZAF_CORNER_SCROLL);
					text->Add(cScroll);
					text->Add(vScroll);
				}
				hScroll = new ZafScrollBar(0, 0, 0, 0, 0, 0, 0, 0, 0, ZAF_HORIZONTAL_SCROLL);
				text->Add(hScroll);
			}
			else
			{
				text->Subtract(hScroll);
				delete hScroll;
				if (vScroll)
					text->Add(vScroll);
				if (cScroll)
					delete cScroll;
			}
			attrList->GetObject((ZafNumberID)TST_TOGGLE_HORIZONTAL_SCROLL)->SetSelected(text->HorizontalScrollBar() ? true : false);

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafText *text = DynamicPtrCast(testObject, ZafText);
 
	// Preset attributes according to test object's settings.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_CLEAR)->SetSelected(text->AutoClear());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_INVALID)->SetSelected(text->Invalid());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_UNANSWERED)->SetSelected(text->Unanswered());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_WORD_WRAP)->SetSelected(text->WordWrap());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_VERTICAL_SCROLL)->SetSelected(text->VerticalScrollBar() ? true : false);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_HORIZONTAL_SCROLL)->SetSelected(text->HorizontalScrollBar() ? true : false);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_VIEW_ONLY)->SetSelected(text->ViewOnly());

	ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
	switch (text->HzJustify())
	{
	case ZAF_HZ_LEFT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
		break;

	case ZAF_HZ_CENTER:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
		break;

	case ZAF_HZ_RIGHT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
		break;
	}

	GenericTestWin::SynchronizeAttributes();
}
