//	Zinc Application Framework - TESTEVT.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_appall.hpp>

const ZafEventType TST_TOGGLE_FIRST            = 11000;

// ZafWindowObject
const ZafEventType TST_TOGGLE_BORDERED         = 11000;
const ZafEventType TST_TOGGLE_VISIBLE          = 11001;
const ZafEventType TST_TOGGLE_ACCEPT_DROP      = 11002;
const ZafEventType TST_TOGGLE_AUTOMATIC_UPDATE = 11003;
const ZafEventType TST_TOGGLE_CHANGED          = 11004;
const ZafEventType TST_TOGGLE_COPY_DRAGGABLE   = 11005;
const ZafEventType TST_TOGGLE_LINK_DRAGGABLE   = 11006;
const ZafEventType TST_TOGGLE_MOVE_DRAGGABLE   = 11007;
const ZafEventType TST_TOGGLE_FOCUS            = 11008;
const ZafEventType TST_TOGGLE_DESTROYABLE      = 11009;
const ZafEventType TST_TOGGLE_MOVEABLE         = 11010;
const ZafEventType TST_TOGGLE_NONCURRENT       = 11011;
const ZafEventType TST_TOGGLE_DISABLED         = 11012;
const ZafEventType TST_TOGGLE_OSDRAW           = 11013;
const ZafEventType TST_TOGGLE_PARENTDRAW_BORDER= 11014;
const ZafEventType TST_TOGGLE_PARENTPALETTE    = 11015;
const ZafEventType TST_TOGGLE_PARENTDRAW_FOCUS = 11016;
const ZafEventType TST_TOGGLE_SELECTED         = 11017;
const ZafEventType TST_TOGGLE_SIZEABLE         = 11018;
const ZafEventType TST_TOGGLE_VIEW_ONLY        = 11019;
const ZafEventType TST_TOGGLE_EDIT_MODE        = 11020;

// ZafPrompt
const ZafEventType TST_TOGGLE_AUTO_SIZE        = 11030;
const ZafEventType TST_TOGGLE_TRANSPARENT_BACK = 11031;

// ZafString
const ZafEventType TST_TOGGLE_AUTO_CLEAR       = 11040;
const ZafEventType TST_TOGGLE_INVALID          = 11043;
const ZafEventType TST_TOGGLE_LOWERCASE        = 11044;
const ZafEventType TST_TOGGLE_PASSWORD         = 11045;
const ZafEventType TST_TOGGLE_UNANSWERED       = 11046;
const ZafEventType TST_TOGGLE_UPPERCASE        = 11047;
const ZafEventType TST_TOGGLE_VARIABLENAME     = 11048;

// ZafButton
// TST_TOGGLE_AUTO_SIZE defined with ZafPrompt messages.
const ZafEventType TST_TOGGLE_ALLOW_TOGGLE     = 11050;
const ZafEventType TST_TOGGLE_AUTO_REPEAT      = 11051;
const ZafEventType TST_TOGGLE_DEFAULT_BUTTON   = 11052;
const ZafEventType TST_TOGGLE_DOUBLE_CLICK     = 11053;
const ZafEventType TST_TOGGLE_DOWN_CLICK       = 11054;
const ZafEventType TST_TOGGLE_SEND_MESSAGE     = 11055;
const ZafEventType TST_TOGGLE_BITMAP           = 11056;
const ZafEventType TST_TOGGLE_ALLOW_DEFAULT    = 11057;

// ZafText
// TST_TOGGLE_AUTO_CLEAR, TST_TOGGLE_INVALID,   
// TST_TOGGLE_UNANSWERED defined with ZafString.
const ZafEventType TST_TOGGLE_VERTICAL_SCROLL  = 11060;
const ZafEventType TST_TOGGLE_HORIZONTAL_SCROLL= 11061;
const ZafEventType TST_TOGGLE_WORD_WRAP        = 11062;

// ZafVtList
const ZafEventType TST_TOGGLE_AUTO_SORT        = 11072;

// ZafGroup
const ZafEventType TST_TOGGLE_AUTO_SELECT      = 11090;
const ZafEventType TST_TOGGLE_SELECTION_TYPE   = 11091;

// ZafTreeItem
const ZafEventType TST_TOGGLE_EXPANDABLE       = 11100;
const ZafEventType TST_TOGGLE_EXPANDED         = 11101;
const ZafEventType TST_TOGGLE_NORMAL_BITMAP    = 11102;
const ZafEventType TST_TOGGLE_SELECTED_BITMAP  = 11103;

// ZafToolBar
const ZafEventType TST_TOGGLE_WRAP_CHILDREN    = 11110;

const ZafEventType TST_TOGGLE_LAST             = 11999;


const ZafEventType TST_SET_FIRST               = 12000;

// ZafWindowObject
const ZafEventType TST_SET_HZ_JUSTIFY_LEFT     = 12000;
const ZafEventType TST_SET_HZ_JUSTIFY_CENTER   = 12001;
const ZafEventType TST_SET_HZ_JUSTIFY_RIGHT    = 12002;

const ZafEventType TST_SET_VT_JUSTIFY_TOP      = 12010;
const ZafEventType TST_SET_VT_JUSTIFY_CENTER   = 12011;
const ZafEventType TST_SET_VT_JUSTIFY_BOTTOM   = 12012;

const ZafEventType TST_SET_TOOL_TIP            = 12020;

const ZafEventType TST_SET_HELP_CONTEXT        = 12030;

const ZafEventType TST_SET_TEXT_RED            = 12040;
const ZafEventType TST_SET_TEXT_YELLOW         = 12041;
const ZafEventType TST_SET_TEXT_BLACK          = 12042;
const ZafEventType TST_SET_TEXT_DEFAULT        = 12043;

const ZafEventType TST_SET_BACK_RED            = 12050;
const ZafEventType TST_SET_BACK_YELLOW         = 12051;
const ZafEventType TST_SET_BACK_BLACK          = 12052;
const ZafEventType TST_SET_BACK_DEFAULT        = 12053;

const ZafEventType TST_SET_FONT_SMALL          = 12060;
const ZafEventType TST_SET_FONT_DIALOG         = 12061;
const ZafEventType TST_SET_FONT_APPLICATION    = 12062;
const ZafEventType TST_SET_FONT_SYSTEM         = 12063;
const ZafEventType TST_SET_FONT_FIXED		   = 12064;

// ZafFormattedString
const ZafEventType TST_SET_DELETE_TEXT         = 12070;
const ZafEventType TST_SET_FORMAT_TEXT         = 12071;

// ZafButton
const ZafEventType TST_SET_NATIVE_BUTTON       = 12080;
const ZafEventType TST_SET_RADIO_BUTTON        = 12081;
const ZafEventType TST_SET_CHECK_BOX           = 12082;
const ZafEventType TST_SET_3D_BUTTON           = 12083;
const ZafEventType TST_SET_FLAT_BUTTON         = 12084;
const ZafEventType TST_SET_VALUE_NONE          = 12085;
const ZafEventType TST_SET_VALUE_BEEP          = 12086;
const ZafEventType TST_SET_VALUE_REDISPLAY     = 12087;

// ZafIcon
const ZafEventType TST_SET_ICON_IMAGE_NONE     = 12090;
const ZafEventType TST_SET_ICON_IMAGE_APP      = 12091;
const ZafEventType TST_SET_ICON_IMAGE_ASTERISK = 12092;
const ZafEventType TST_SET_ICON_IMAGE_EXCLAMATION= 12093;
const ZafEventType TST_SET_ICON_IMAGE_HAND     = 12094;
const ZafEventType TST_SET_ICON_IMAGE_QUESTION = 12095;

// ZafProgressBar
const ZafEventType TST_SET_INDENTED_PROGRESS   = 12100;
const ZafEventType TST_SET_FLAT_PROGRESS       = 12101;
const ZafEventType TST_SET_RAISED_PROGRESS     = 12102;
const ZafEventType TST_SET_PROGRESS_TEXT_NONE  = 12103;
const ZafEventType TST_SET_PROGRESS_TEXT       = 12104;
const ZafEventType TST_SET_PROGRESS_TEXT_PERCENT= 12105;

// ZafSpinControl
const ZafEventType TST_SET_SPIN_OBJECT_INTEGER = 12110;
const ZafEventType TST_SET_SPIN_OBJECT_DATE    = 12111;
const ZafEventType TST_SET_SPIN_OBJECT_TIME    = 12112;
const ZafEventType TST_SET_SPIN_OBJECT_REAL    = 12113;
const ZafEventType TST_SET_SPIN_OBJECT_BIGNUM  = 12114;
const ZafEventType TST_SET_SPIN_OBJECT_UTIME   = 12115;
const ZafEventType TST_SET_DELTA               = 12116;

// ZafVtList, ZafHzList, ZafComboBox
const ZafEventType TST_SET_SORT_NONE           = 12120;
const ZafEventType TST_SET_SORT_AUTO           = 12121;
const ZafEventType TST_SET_SORT_REVERSE        = 12122;
const ZafEventType TST_SET_SELECTION_SINGLE    = 12130;
const ZafEventType TST_SET_SELECTION_MULTIPLE  = 12131;
const ZafEventType TST_SET_SELECTION_EXTENDED  = 12132;

// ZafPrompt
const ZafEventType TST_SET_TEXT                = 12130;

// ZafToolBar
const ZafEventType TST_SET_DOCK_TOP            = 12140;
const ZafEventType TST_SET_DOCK_LEFT           = 12141;
const ZafEventType TST_SET_DOCK_BOTTOM         = 12142;
const ZafEventType TST_SET_DOCK_RIGHT          = 12143;

// ZafNotebook
const ZafEventType TST_SET_TAB_TEXT            = 12150;

const ZafEventType TST_SET_LAST                = 12999;


const ZafEventType TST_ACTION_FIRST            = 13000;

const ZafEventType TST_STORE                   = 13000;
const ZafEventType TST_SHOW_EVENT_LOG          = 13001;
const ZafEventType TST_REDRAW                  = 13002;
const ZafEventType TST_DUPLICATE               = 13003;
const ZafEventType TST_BEEP                    = 13004;
const ZafEventType TST_RESET_TIMER             = 13005;
const ZafEventType TST_ADD_OBJECTS             = 13006;
const ZafEventType TST_SUBTRACT_TESTOBJECT     = 13007;
const ZafEventType TST_ADD_TESTOBJECT          = 13008;
const ZafEventType TST_ADVANCE_PROGRESS        = 13009;

const ZafEventType TST_ACTION_LAST             = 13999;
