//	Zinc Application Framework - TBAR.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_stdlib.hpp>
#include "maintest.hpp"

// This table contains the list of all attributes that can be set on this 
// object.  AttributeTable.count gets updated by GenericTestWin::Event().
// This list is used to create the attribute chack boxes in the attribute 
// list.
ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafToolBar
	{ ZAF_ITEXT("Multiple selection"),0, TST_TOGGLE_SELECTION_TYPE },
	{ ZAF_ITEXT("Wrap children"),   0, TST_TOGGLE_WRAP_CHILDREN },

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
//	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
//	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
//	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
//	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
//	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
//	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
//	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
//	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),       0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

// ---- Derived test object -------------------------------------------------

class TestObj : public ZafToolBar
{
public:
  	TestObj();
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj() : ZafToolBar(0, 0, 0, 1)
{
	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafToolBar::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 14)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	// Set the title text.
	SetText(ZAF_ITEXT("Tool bar"));

	// Create type combo box.
	Add(new ZafPrompt(1, 9, 10, new ZafStringData("Dock type:")));
	ZafComboBox *typeCombo = new ZafComboBox(11, 9, 10, 3);
	typeCombo->SetStringID(ZAF_ITEXT("DOCK_TYPE_COMBO"));
	typeCombo->SetViewOnly(true);
	typeCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	ZafButton *attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Top"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_DOCK_TOP);
	attr->SetNumberID((ZafNumberID)TST_SET_DOCK_TOP);
	typeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Bottom"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_DOCK_BOTTOM);
	attr->SetNumberID((ZafNumberID)TST_SET_DOCK_BOTTOM);
	typeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Left"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_DOCK_LEFT);
	attr->SetNumberID((ZafNumberID)TST_SET_DOCK_LEFT);
	typeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Right"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_DOCK_RIGHT);
	attr->SetNumberID((ZafNumberID)TST_SET_DOCK_RIGHT);
	typeCombo->Add(attr);

	Add(typeCombo);

	// Add the test object.
	testObject = new TestObj;
	ZafToolBar *tbar = DynamicPtrCast(testObject, ZafToolBar);
	for (int cnt = 0; cnt < 10; cnt++)
	{
		ZafIChar buf[32];
		sprintf(buf, ZAF_ITEXT("Button %d"), cnt);
		ZafButton *tbarButton = new ZafButton(0, 0, 10, 1, buf);
		tbarButton->SetAutoSize(false);
		tbarButton->SetAllowToggling(true);
		tbarButton->SetSelectOnDownClick(true);
		tbar->Add(tbarButton);
	}

	Add(testObject);

	// Add other objects needed to test the object.
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafToolBar *tbar = DynamicPtrCast(testObject, ZafToolBar);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.
	case TST_TOGGLE_SELECTION_TYPE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_SELECTION_TYPE);
			tbar->SetSelectionType(attr->Selected() ? ZAF_MULTIPLE_SELECTION : ZAF_SINGLE_SELECTION);
			attr->SetSelected(tbar->SelectionType() != ZAF_SINGLE_SELECTION);

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_WRAP_CHILDREN:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_WRAP_CHILDREN);
			tbar->SetWrapChildren(attr->Selected());
			attr->SetSelected(tbar->WrapChildren());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_SET_DOCK_TOP:
	case TST_SET_DOCK_LEFT:
	case TST_SET_DOCK_BOTTOM:
	case TST_SET_DOCK_RIGHT:
		{
			tbar->SetDockType((ZafDockType)(ccode - TST_SET_DOCK_TOP));

			ZafComboBox *typeCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("DOCK_TYPE_COMBO")), ZafComboBox);
			switch (tbar->DockType())
			{
			case ZAF_DOCK_TOP:
				typeCombo->GetObject((ZafNumberID)TST_SET_DOCK_TOP)->SetSelected(true);
				break;

			case ZAF_DOCK_LEFT:
				typeCombo->GetObject((ZafNumberID)TST_SET_DOCK_LEFT)->SetSelected(true);
				break;

			case ZAF_DOCK_BOTTOM:
				typeCombo->GetObject((ZafNumberID)TST_SET_DOCK_BOTTOM)->SetSelected(true);
				break;

			case ZAF_DOCK_RIGHT:
				typeCombo->GetObject((ZafNumberID)TST_SET_DOCK_RIGHT)->SetSelected(true);
				break;
			}
		}
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafToolBar *tbar = DynamicPtrCast(testObject, ZafToolBar);
 
	// Preset attributes according to test object's settings.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_SELECTION_TYPE)->SetSelected(tbar->SelectionType() != ZAF_SINGLE_SELECTION);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_WRAP_CHILDREN)->SetSelected(tbar->WrapChildren());

	GenericTestWin::SynchronizeAttributes();
}
