//	Zinc Application Framework - TABLE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_stdlib.hpp>
#include "maintest.hpp"

// This table contains the list of all attributes that can be set on this 
// object.  AttributeTable.count gets updated by GenericTestWin::Event().
// This list is used to create the attribute chack boxes in the attribute 
// list.
ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafTable
	{ ZAF_ITEXT("Multiple selection"),0, TST_TOGGLE_SELECTION_TYPE },

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
//	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
//	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
//	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
//	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
//	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
//	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
//	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
//	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),       0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

// ---- Derived test object -------------------------------------------------

const int MAX_RECORDS = 300;

class TestObj : public ZafTable
{
public:
  	TestObj();
  	TestObj(const TestObj &copy);
	ZafEventType Event(const ZafEventStruct &event);
	virtual ZafError ReadRecord(ZafTableRecord *record, ZafWindowObject *row);
	virtual ZafError WriteRecord(ZafTableRecord *record, ZafWindowObject *row);

	// --- Persistent members ---
	TestObj(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist) { return (new TestObj(name, persist)); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafTable::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafTable::IsA(compareName)); }

  //private:
	struct SampleTableRecord
	{
		ZafIChar name[32];
		ZafIChar extension[8];
	};
	static SampleTableRecord *data[MAX_RECORDS];

protected:
	virtual ZafWindowObject *Duplicate(void) { return (new TestObj(*this)); }

	// --- Persistent members ---
	virtual ZafObjectConstructor ReadFunction(void) { return (TestObj::Read); }

};

TestObj::SampleTableRecord *TestObj::data[MAX_RECORDS];
ZafClassID TestObj::classID = 3500;
ZafClassNameChar ZAF_FARDATA TestObj::className[] = ZAF_ITEXT("TestObj");

TestObj::TestObj() : ZafTable(50, 1, 30, 8)
{
	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));

	// Create the virtual record.
	virtualRecord = new ZafTableRecord(45, 1);
	virtualRecord->Add(new ZafString(1, 0, 15, new ZafStringData("", 32)));
	virtualRecord->Add(new ZafString(16, 0, 5, new ZafStringData("", 8)));

	// Add the header information.
	ZafTableHeader *cornerHeader = new ZafTableHeader(5, 1, ZAF_CORNER_HEADER);
	Add(cornerHeader);

	ZafTableHeader *columnHeader = new ZafTableHeader(45, 1, ZAF_COLUMN_HEADER);
	columnHeader->Add(new ZafPrompt(2, 0, 15, new ZafStringData("Name")));
	columnHeader->Add(new ZafPrompt(16, 0, 4, new ZafStringData("Ext.")));
	Add(columnHeader);

	ZafTableHeader *rowHeader = new ZafTableHeader(5, 1, ZAF_ROW_HEADER);
	ZafPrompt *prompt = new ZafPrompt(0, 0, 4, new ZafStringData(""));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	prompt->SetAutoSize(false);
	rowHeader->SetVirtualField(prompt);
	Add(rowHeader);

	// Add the scroll-bars.
	ZafScrollBar *scrollBar = new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData), ZAF_VERTICAL_SCROLL);
	Add(scrollBar);

	// count the records.
	maxOffset = MAX_RECORDS - 1;
	for (int i = 0; i < MAX_RECORDS; i++)
	{
		data[i] = new SampleTableRecord;
		sprintf(data[i]->name, ZAF_ITEXT("Employee %d"), i);
		sprintf(data[i]->extension, ZAF_ITEXT("%d"), i);
	}
}

TestObj::TestObj(const TestObj &copy) : ZafTable(copy)
{
}

ZafError TestObj::ReadRecord(ZafTableRecord *record, ZafWindowObject *rowField)
{
	// Read the record.
	record->Get(0)->SetText(data[currentOffset]->name);
	record->Get(1)->SetText(data[currentOffset]->extension);

	// Set the row field.
	ZafIChar text[32];
	sprintf(text, ZAF_ITEXT("%d"), currentOffset);
	rowField->SetText(text);
	return (ZAF_ERROR_NONE);
}

ZafError TestObj::WriteRecord(ZafTableRecord *record, ZafWindowObject *)
{
	// Write the changed fields of the record.
	ZafWindowObject *field = record->Get(0);
	if (field->Changed())
		strcpy(data[currentOffset]->name, field->Text());
	field = record->Get(1);
	if (field->Changed())
		strcpy(data[currentOffset]->extension, field->Text());
	return (ZAF_ERROR_NONE);
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafTable::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

TestObj::TestObj(const ZafIChar *name, ZafObjectPersistence &persist) :
	ZafTable(name, persist)
{

}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 85, 12)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	// Set the title text.
	SetText(ZAF_ITEXT("Table"));

	// Add settings objects.

	// Add the test object.
	testObject = new TestObj;

	Add(testObject);

	// Add other objects needed to test the object.
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafTable *table = DynamicPtrCast(testObject, ZafTable);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.
	case TST_TOGGLE_SELECTION_TYPE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_SELECTION_TYPE);
			table->SetSelectionType(attr->Selected() ? ZAF_MULTIPLE_SELECTION : ZAF_SINGLE_SELECTION);
			attr->SetSelected(table->SelectionType() != ZAF_SINGLE_SELECTION);

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafTable *table = DynamicPtrCast(testObject, ZafTable);
 
	// Preset attributes according to test object's settings.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_SELECTION_TYPE)->SetSelected(table->SelectionType() != ZAF_SINGLE_SELECTION);

	GenericTestWin::SynchronizeAttributes();
}
