//	Zinc Application Framework - STRING.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "maintest.hpp"

// This table contains the list of all attributes that can be set on this 
// object.  AttributeTable.count gets updated by GenericTestWin::Event().
// This list is used to create the attribute chack boxes in the attribute 
// list.
ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafString
	{ ZAF_ITEXT("Auto clear *"),      0, TST_TOGGLE_AUTO_CLEAR },
	{ ZAF_ITEXT("Invalid *"),         0, TST_TOGGLE_INVALID },
	{ ZAF_ITEXT("Lower case"),        0, TST_TOGGLE_LOWERCASE },
	{ ZAF_ITEXT("Password"),          0, TST_TOGGLE_PASSWORD },
	{ ZAF_ITEXT("Unanswered *"),      0, TST_TOGGLE_UNANSWERED },
	{ ZAF_ITEXT("Upper case"),        0, TST_TOGGLE_UPPERCASE },
	{ ZAF_ITEXT("Variable name"),     0, TST_TOGGLE_VARIABLENAME },
	{ ZAF_ITEXT("View only"),         0, TST_TOGGLE_VIEW_ONLY },

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),         0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

// ---- Derived test object -------------------------------------------------

class TestObj : public ZafString
{
public:
  	TestObj();
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj() : ZafString(50, 1, 15, ZAF_NULLP(ZafStringData))
{
	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafString::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 11)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	ZafStringData *sharedData = new ZafStringData("Test string", 32);

	// Set the title text.
	SetText(ZAF_ITEXT("String"));

	// Create horizontal justify combo box.
	ZafComboBox *hzJustifyCombo = new ZafComboBox(27, 1, 20, 3);
	hzJustifyCombo->SetViewOnly(true);
	hzJustifyCombo->SetStringID(ZAF_ITEXT("HZ_JUSTIFY_COMBO"));
	hzJustifyCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	ZafButton *attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz left"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_LEFT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz center"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_CENTER);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz right"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_RIGHT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT);
	hzJustifyCombo->Add(attr);

	Add(hzJustifyCombo);

	// Add the test object.
	testObject = new TestObj;
	DynamicPtrCast(testObject, ZafString)->SetStringData(sharedData);
	Add(testObject);

	// Add other objects needed to test the object.
	ZafString *string = new ZafString(50, 2, 15, sharedData);
	string->SetAcceptDrop(true);
	string->SetCopyDraggable(true);
	string->SetMoveDraggable(true);
	Add(string);

	string = new ZafString(50, 5, 15, new ZafStringData("Drag & drop"));
	string->SetAcceptDrop(true);
	string->SetCopyDraggable(true);
	string->SetMoveDraggable(true);
	Add(string);
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafString *string = DynamicPtrCast(testObject, ZafString);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.
	case TST_TOGGLE_AUTO_CLEAR:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_CLEAR);
			string->SetAutoClear(attr->Selected());
			attr->SetSelected(string->AutoClear());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_INVALID:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_INVALID);
			string->SetInvalid(attr->Selected());
			attr->SetSelected(string->Invalid());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_LOWERCASE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_LOWERCASE);
			string->SetLowerCase(attr->Selected());
			attr->SetSelected(string->LowerCase());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_PASSWORD:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_PASSWORD);
			string->SetPassword(attr->Selected());
			attr->SetSelected(string->Password());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_UNANSWERED:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_UNANSWERED);
			string->SetUnanswered(attr->Selected());
			attr->SetSelected(string->Unanswered());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_UPPERCASE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_UPPERCASE);
			string->SetUpperCase(attr->Selected());
			attr->SetSelected(string->UpperCase());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_VARIABLENAME:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_VARIABLENAME);
			string->SetVariableName(attr->Selected());
			attr->SetSelected(string->VariableName());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_VIEW_ONLY:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_VIEW_ONLY);
			string->SetViewOnly(attr->Selected());
			attr->SetSelected(string->ViewOnly());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_SET_HZ_JUSTIFY_LEFT:
	case TST_SET_HZ_JUSTIFY_CENTER:
	case TST_SET_HZ_JUSTIFY_RIGHT:
		{
		 	if (ccode == TST_SET_HZ_JUSTIFY_LEFT)
				string->SetHzJustify(ZAF_HZ_LEFT);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_CENTER)
				string->SetHzJustify(ZAF_HZ_CENTER);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_RIGHT)
				string->SetHzJustify(ZAF_HZ_RIGHT);

			ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
			switch (string->HzJustify())
			{
			case ZAF_HZ_LEFT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
				break;

			case ZAF_HZ_CENTER:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
				break;

			case ZAF_HZ_RIGHT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
				break;
			}
		}
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafString *string = DynamicPtrCast(testObject, ZafString);
 
	// Preset attributes according to test object's settings.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_CLEAR)->SetSelected(string->AutoClear());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_INVALID)->SetSelected(string->Invalid());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_LOWERCASE)->SetSelected(string->LowerCase());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_PASSWORD)->SetSelected(string->Password());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_UNANSWERED)->SetSelected(string->Unanswered());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_UPPERCASE)->SetSelected(string->UpperCase());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_VARIABLENAME)->SetSelected(string->VariableName());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_VIEW_ONLY)->SetSelected(string->ViewOnly());

	ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
	switch (string->HzJustify())
	{
	case ZAF_HZ_LEFT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
		break;

	case ZAF_HZ_CENTER:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
		break;

	case ZAF_HZ_RIGHT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
		break;
	}

	GenericTestWin::SynchronizeAttributes();
}
