//	Zinc Application Framework - SCROLL.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_stdlib.hpp>
#include "maintest.hpp"

ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafScrollBar
	{ ZAF_ITEXT("Auto size"),			0, TST_TOGGLE_AUTO_SIZE },

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),			0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),			0, TST_TOGGLE_VISIBLE },
	{ ZAF_ITEXT("Accept drop *"),		0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),		0, TST_TOGGLE_AUTOMATIC_UPDATE },
	{ ZAF_ITEXT("Changed *"),			0, TST_TOGGLE_CHANGED },
//	{ ZAF_ITEXT("Copy Draggable *"),	0, TST_TOGGLE_COPY_DRAGGABLE },
//	{ ZAF_ITEXT("Link Draggable *"),	0, TST_TOGGLE_LINK_DRAGGABLE },
//	{ ZAF_ITEXT("Move Draggable *"),	0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),				0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),		0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),			0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),				0, TST_TOGGLE_OSDRAW },
//	{ ZAF_ITEXT("Parentdraw border"),	0, TST_TOGGLE_PARENTDRAW_BORDER },
//	{ ZAF_ITEXT("Parent palette"),		0, TST_TOGGLE_PARENTPALETTE },
//	{ ZAF_ITEXT("Parentdraw focus"),	0, TST_TOGGLE_PARENTDRAW_FOCUS },
//	{ ZAF_ITEXT("Selected *"),			0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),			0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),				0, 0 }
};

ZafEventType ScrollFunc(ZafWindowObject *object, ZafEventStruct &, ZafEventType ccode)
{
	if (ccode == L_SELECT)
	{
		ZafScrollBar *scroll = DynamicPtrCast(object, ZafScrollBar);
		ZafInteger *integer = DynamicPtrCast(scroll->Next(), ZafInteger);

		integer->IntegerData()->SetInteger(scroll->ScrollData()->Current());
	}

	return (0);
}

ZafScrollData tstScrollData(0, 100, 0, 1, 10);

// ---- Derived test object -------------------------------------------------

// Derive a test object so can log which events it gets.
class TestObj : public ZafScrollBar
{
public:
  	TestObj();
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj() : ZafScrollBar(51, 1, 0, 6, &tstScrollData)
{
	tstScrollData.SetDestroyable(false);
	SetRegionType(ZAF_INSIDE_REGION);
	SetSupportObject(false);

	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));  
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafScrollBar::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 12)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	// Set the title text.
	SetText(ZAF_ITEXT("Scroll bar"));

	// Add settings objects.

	// Add the test object.
	testObject = new TestObj;
	Add(testObject);
	testObject->SetUserFunction(ScrollFunc);

	ZafInteger *int1 = new ZafInteger(50, 7, 4, new ZafIntegerData(0L));
	int1->SetNoncurrent(true);
	Add(int1);

	// Add other objects needed to test the object.
	ZafScrollBar *scroll2 = new ZafScrollBar(56, 1, 0, 6, new ZafScrollData(0, 100, 0, 1, 10));
	scroll2->SetRegionType(ZAF_INSIDE_REGION);
	scroll2->SetSupportObject(false);
	scroll2->SetScrollType(ZAF_VERTICAL_SLIDER);
	scroll2->SetUserFunction(ScrollFunc);
	Add(scroll2);

	ZafInteger *int2 = new ZafInteger(55, 7, 4, new ZafIntegerData(0L));
	int2->SetNoncurrent(true);
	Add(int2);

	ZafScrollBar *scroll3 = new ZafScrollBar(50, 8, 20, 0, new ZafScrollData(0, 100, 0, 1, 10));
	scroll3->SetRegionType(ZAF_INSIDE_REGION);
	scroll3->SetSupportObject(false);
	scroll3->SetScrollType(ZAF_HORIZONTAL_SCROLL);
	scroll3->SetUserFunction(ScrollFunc);
	Add(scroll3);

	ZafInteger *int3 = new ZafInteger(72, 8, 4, new ZafIntegerData(0L));
	int3->SetNoncurrent(true);
	Add(int3);

	ZafScrollBar *scroll4 = new ZafScrollBar(50, 9, 20, 0, new ZafScrollData(0, 100, 0, 1, 10));
	scroll4->SetRegionType(ZAF_INSIDE_REGION);
	scroll4->SetSupportObject(false);
	scroll4->SetScrollType(ZAF_HORIZONTAL_SLIDER);
	scroll4->SetUserFunction(ScrollFunc);
	Add(scroll4);

	ZafInteger *int4 = new ZafInteger(72, 9, 4, new ZafIntegerData(0L));
	int4->SetNoncurrent(true);
	Add(int4);

}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafScrollBar *scroll = DynamicPtrCast(testObject, ZafScrollBar);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.
	case TST_TOGGLE_AUTO_SIZE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_SIZE);
			scroll->SetAutoSize(attr->Selected());
			attr->SetSelected(scroll->AutoSize());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafScrollBar *scroll = DynamicPtrCast(testObject, ZafScrollBar);

	// Preset attributes according to test object's settings.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_SIZE)->SetSelected(scroll->AutoSize());

	GenericTestWin::SynchronizeAttributes();

	// Set settings fields disabled.
	GetObject(ZAF_ITEXT("TEXT_COLOR_COMBO"))->SetDisabled(true);
	GetObject(ZAF_ITEXT("BACK_COLOR_COMBO"))->SetDisabled(true);
	GetObject(ZAF_ITEXT("FONT_COMBO"))->SetDisabled(true);
}
