//	Zinc Application Framework - SCLWIN.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_appall.hpp>
#include "testevt.hpp"

class ScrolledTestWindow : public ZafScrolledWindow
{
public:
	ScrolledTestWindow(int left, int top);
	ScrolledTestWindow(ScrolledTestWindow &copy);
	ScrolledTestWindow(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual ZafWindowObject *Duplicate(void) { return (new ScrolledTestWindow(*this)); }
};

ScrolledTestWindow::ScrolledTestWindow(int left, int top) :
	ZafScrolledWindow(left, top, 60, 8, 150, 30)
{
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton);
	Add(new ZafTitle(new ZafStringData("Scrolled window")));

	Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData), ZAF_CORNER_SCROLL));
	Add(new ZafScrollBar(0, 0, 0, 0));
	Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData), ZAF_HORIZONTAL_SCROLL));

	ZafButton *store = new ZafButton(1, 1, 15, 1, new ZafStringData("Store"));
	store->SetAutoSize(false);
	store->SetSendMessageWhenSelected(true);
	store->SetValue(TST_STORE);
	Add(store);

	ZafButton *duplicate = new ZafButton(125, 1, 15, 1, new ZafStringData("Duplicate"));
	duplicate->SetAutoSize(false);
	duplicate->SetSendMessageWhenSelected(true);
	duplicate->SetValue(TST_DUPLICATE);
	Add(duplicate);

	ZafButton *button = new ZafButton(1, 25, 15, 1, new ZafStringData("Button 3"));
	button->SetAutoSize(false);
	Add(button);

	button = new ZafButton(125, 25, 15, 1, new ZafStringData("Button 4"));
	button->SetAutoSize(false);
	Add(button);
}

ZafEventType ScrolledTestWindow::Event(const ZafEventStruct &event)
{
	ZafEventType ccode = event.type;

	switch (ccode)
	{
	// Store the window, then load a copy of it from the dat file.
	case TST_STORE:
		{
			ZafStorage *storage = new ZafStorage(ZAF_ITEXT("test.dat"), ZAF_FILE_CREATE | ZAF_FILE_READWRITE);
			ZafObjectPersistence *persist = new ZafObjectPersistence(storage);
			Write(*persist);
			storage->Save();
			ScrolledTestWindow *newWin = new ScrolledTestWindow(StringID(), *persist);
			windowManager->Add(newWin);
			delete persist;
			delete storage;
		}
		break;

	case TST_DUPLICATE:
		{
			ZafWindowObject *newWin = Duplicate();
			windowManager->Add(newWin);
		}
		break;

	default:
		ccode = ZafScrolledWindow::Event(event);
		break;
	}
	return (ccode);
}

ScrolledTestWindow::ScrolledTestWindow(const ZafIChar *name, ZafObjectPersistence &persist) :
	ZafScrolledWindow(name, persist)
{
	// Nothing to do.
}

ScrolledTestWindow::ScrolledTestWindow(ScrolledTestWindow &copy): ZafScrolledWindow(copy)
{
	// Nothing to do.
}

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	ScrolledTestWindow *sclWin = new ScrolledTestWindow(1, 1);

	zafWindowManager->Add(sclWin);

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

