//	Zinc Application Framework - PRGRS.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_stdlib.hpp>
#include "maintest.hpp"

ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafProgressBar

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
//	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
//	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
//	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
//	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
//	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
//	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
//	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
//	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
//	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
//	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),       0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

ZafScrollData progress(0, 100, 0, 1, 100);
ZafProgressBar *progress2 = 0, *progress3 = 0, *progress4 = 0;

// ---- Derived test object -------------------------------------------------

// Derive a test object so can log which events it gets.
class TestObj : public ZafProgressBar
{
public:
  	TestObj();
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj() : ZafProgressBar(50, 1, 3, 6, &progress)
{
	progress.SetDestroyable(false);
	SetRegionType(ZAF_INSIDE_REGION);
	SetSupportObject(false);

	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));  
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafProgressBar::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 12)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	// Set the title text.
	SetText(ZAF_ITEXT("Progress bar"));

	// Add settings objects.

	// Create style combo box.
	ZafComboBox *styleCombo = new ZafComboBox(1, 8, 12, 3);
	styleCombo->SetViewOnly(true);
	styleCombo->SetStringID(ZAF_ITEXT("STYLE_COMBO"));
	styleCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	ZafButton *attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Indented"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_INDENTED_PROGRESS);
	attr->SetNumberID((ZafNumberID)TST_SET_INDENTED_PROGRESS);
	styleCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Flat"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_FLAT_PROGRESS);
	attr->SetNumberID((ZafNumberID)TST_SET_FLAT_PROGRESS);
	styleCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Raised"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_RAISED_PROGRESS);
	attr->SetNumberID((ZafNumberID)TST_SET_RAISED_PROGRESS);
	styleCombo->Add(attr);

	Add(styleCombo);

	// Create text style combo box.
	ZafComboBox *textStyleCombo = new ZafComboBox(14, 8, 12, 3);
	textStyleCombo->SetViewOnly(true);
	textStyleCombo->SetStringID(ZAF_ITEXT("TEXT_STYLE_COMBO"));
	textStyleCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("None"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_PROGRESS_TEXT_NONE);
	attr->SetNumberID((ZafNumberID)TST_SET_PROGRESS_TEXT_NONE);
	textStyleCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Text"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_PROGRESS_TEXT);
	attr->SetNumberID((ZafNumberID)TST_SET_PROGRESS_TEXT);
	textStyleCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Percent"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_PROGRESS_TEXT_PERCENT);
	attr->SetNumberID((ZafNumberID)TST_SET_PROGRESS_TEXT_PERCENT);
	textStyleCombo->Add(attr);

	Add(textStyleCombo);

	ZafButton *resetTimer = new ZafButton(27, 8, 10, 1, new ZafStringData("Reset"));
	resetTimer->SetAutoSize(false);
	resetTimer->SetSendMessageWhenSelected(true);
	resetTimer->SetValue(TST_RESET_TIMER);
	Add(resetTimer);

	// Add the test object.
	testObject = new TestObj;
	Add(testObject);

	// Add other objects needed to test the object.
	progress2 = new ZafProgressBar(54, 1, 3, 6, new ZafScrollData(0, 100, 0, 1, 100));
	progress2->SetProgressType(ZAF_PROGRESS_VERTICAL);
	progress2->SetRegionType(ZAF_INSIDE_REGION);
	progress2->SetSupportObject(false);
	Add(progress2);

	progress3 = new ZafProgressBar(50, 7, 20, 1, new ZafScrollData(0, 100, 0, 1, 100));
	progress3->SetRegionType(ZAF_INSIDE_REGION);
	progress3->SetSupportObject(false);
	Add(progress3);

	progress4 = new ZafProgressBar(50, 8, 20, 1, new ZafScrollData(0, 100, 0, 1, 100));
	progress4->SetRegionType(ZAF_INSIDE_REGION);
	progress4->SetSupportObject(false);
	Add(progress4);
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafProgressBar *progress = DynamicPtrCast(testObject, ZafProgressBar);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	case S_INITIALIZE:
		{
			GenericTestWin::Event(event);

			// Generate timer message to update progress bars.
			ZafTimer *timer = new ZafTimer(D_ON, 10);
			timer->SetQueueEvents(true);
			eventManager->Add(timer);
		}
		break;

	case TST_SET_INDENTED_PROGRESS:
	case TST_SET_FLAT_PROGRESS:
	case TST_SET_RAISED_PROGRESS:
		{
			progress->SetProgressStyle((ZafProgressStyle)(ccode - TST_SET_INDENTED_PROGRESS + 1));

			ZafComboBox *styleCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("STYLE_COMBO")), ZafComboBox);
			switch (progress->ProgressStyle())
			{
			case ZAF_PROGRESS_NATIVE:
			case ZAF_PROGRESS_INDENTED:
				styleCombo->GetObject((ZafNumberID)TST_SET_INDENTED_PROGRESS)->SetSelected(true);
				break;

			case ZAF_PROGRESS_FLAT:
				styleCombo->GetObject((ZafNumberID)TST_SET_FLAT_PROGRESS)->SetSelected(true);
				break;

			case ZAF_PROGRESS_RAISED:
				styleCombo->GetObject((ZafNumberID)TST_SET_RAISED_PROGRESS)->SetSelected(true);
				break;
			}
		}
		break;

	case TST_SET_PROGRESS_TEXT_NONE:
	case TST_SET_PROGRESS_TEXT:
	case TST_SET_PROGRESS_TEXT_PERCENT:
		{
			progress->SetTextStyle((ZafProgressTextStyle)(ccode - TST_SET_PROGRESS_TEXT_NONE));

			ZafComboBox *textStyleCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("TEXT_STYLE_COMBO")), ZafComboBox);
			switch (progress->TextStyle())
			{
			case ZAF_PROGRESS_TEXT_NONE:
				textStyleCombo->GetObject((ZafNumberID)TST_SET_PROGRESS_TEXT_NONE)->SetSelected(true);
				break;

			case ZAF_PROGRESS_TEXT_VALUE:
				textStyleCombo->GetObject((ZafNumberID)TST_SET_PROGRESS_TEXT)->SetSelected(true);
				break;

			case ZAF_PROGRESS_TEXT_PERCENT:
				textStyleCombo->GetObject((ZafNumberID)TST_SET_PROGRESS_TEXT_PERCENT)->SetSelected(true);
				break;
			}
		}
		break;

	case TST_RESET_TIMER:
		progress->SetCurrent(0);
		progress2->SetCurrent(0);
		progress3->SetCurrent(0);
		progress4->SetCurrent(0);
		break;

	case N_TIMER:
		{
			progress->Increment(progress->Step());
			progress3->Increment(progress3->Step());

			static int count = 0;

			// Advance every other event.
			if (count % 2)
			{
				progress2->Increment(progress2->Step());
				progress4->Increment(progress4->Step());
			}
			count++;
		}
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafProgressBar *progress = DynamicPtrCast(testObject, ZafProgressBar);

	GenericTestWin::SynchronizeAttributes();

	// Set settings fields disabled.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_NONCURRENT)->SetDisabled(true);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_DISABLED)->SetDisabled(true);
	GetObject(ZAF_ITEXT("HELP_CONTEXT_COMBO"))->SetDisabled(true);
}
