//	Zinc Application Framework - MAINTEST.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_appall.hpp>
#include <testevt.hpp>

struct ListEntry
{
	ZafIChar *text;     // Text that appears when displayed.
	int count;          // How often item has been used.
	ZafEventType value; // Event value for the item.
};

class GenericTestWin : public ZafWindow
{
public:
	GenericTestWin(int left, int top, int width, int height);
	GenericTestWin(GenericTestWin &copy);
	~GenericTestWin(void);
	GenericTestWin(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	void LogEvent(ZafEventType ccode);
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual void SynchronizeAttributes(void);
	ZafWindowObject *TestObject() { return (testObject) ; }

protected:
	static ListEntry ZAF_FARDATA AttributeTable[];
	static ListEntry ZAF_FARDATA EventLog[];
	ZafWindowObject *testObject;  // Object being tested.
	ZafWindow *testObjectParent;	// "Window" to which the test object is added and subtracted.
	ZafWindowObject *testObjectSibling;	// Next sibling after the test object.  Used to maintain
	                                    // list order when adding and subtracting the testobject
	ZafVtList *attrList;				// Attribute list.

	virtual ZafWindowObject *Duplicate(void) { return (new GenericTestWin(*this)); }
};

class ObjectTestWin : public GenericTestWin
{
public:
	ObjectTestWin();
	ObjectTestWin(ObjectTestWin &copy);
	ObjectTestWin(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual void SynchronizeAttributes(void);

protected:
	virtual ZafWindowObject *Duplicate(void) { return (new ObjectTestWin(*this)); }
};


