//	Zinc Application Framework - GROUP.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_stdlib.hpp>
#include "maintest.hpp"

// This table contains the list of all attributes that can be set on this 
// object.  AttributeTable.count gets updated by GenericTestWin::Event().
// This list is used to create the attribute chack boxes in the attribute 
// list.
ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafGroup
	{ ZAF_ITEXT("Multiple selection"),0, TST_TOGGLE_SELECTION_TYPE },
	{ ZAF_ITEXT("Auto select"),       0, TST_TOGGLE_AUTO_SELECT },

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
//	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
//	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
//	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
//	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
//	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
//	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
//	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
//	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),       0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

ZafEventType HotKeyStringCallback(ZafWindowObject *object, ZafEventStruct &, ZafEventType ccode)
{
	if (ccode == L_SELECT || ccode == N_NON_CURRENT)
	{
		ZafGroup *testObject = DynamicPtrCast(DynamicPtrCast(object->parent, GenericTestWin)->TestObject(), ZafGroup);
		testObject->SetHotKey(*object->Text(), testObject->HotKeyIndex());
		ZafIChar buf[2];
		buf[0] = testObject->HotKeyChar();
		buf[1] = '\0';
		object->SetText(buf);
	}

	return (0);
}

ZafEventType HotKeyIndexCallback(ZafWindowObject *object, ZafEventStruct &, ZafEventType ccode)
{
	if (ccode == L_SELECT || ccode == N_NON_CURRENT)
	{
		ZafGroup *testObject = DynamicPtrCast(DynamicPtrCast(object->parent, GenericTestWin)->TestObject(), ZafGroup);
		testObject->SetHotKey(testObject->HotKeyChar(), atoi(object->Text()));
		ZafSpinControl *spin = DynamicPtrCast(object, ZafSpinControl);
		ZafInteger *integer = DynamicPtrCast(spin->Current(), ZafInteger);
		integer->SetIntegerData(new ZafIntegerData(testObject->HotKeyIndex()));
	}

	return (0);
}

// ---- Derived test object -------------------------------------------------

class TestObj : public ZafGroup
{
public:
  	TestObj();
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj() : ZafGroup(50, 1, 25, 5, new ZafStringData("Group"))
{
	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafGroup::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 12)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	// Set the title text.
	SetText(ZAF_ITEXT("Group"));

	// Add settings objects.
	Add(new ZafPrompt(1, 8, 10, new ZafStringData("Hotkey char:")));
	ZafString *hotKeyString = new ZafString(13, 8, 3, new ZafStringData("", 1));
	hotKeyString->SetUserFunction(HotKeyStringCallback);
	Add(hotKeyString);

	Add(new ZafPrompt(17, 8, 10, new ZafStringData("Hotkey index:")));
	ZafSpinControl *hotKeyIndex = new ZafSpinControl(29, 8, 8, new ZafIntegerData(1));
	hotKeyIndex->Add(new ZafInteger(0, 0, 0, new ZafIntegerData(-1L)));
	hotKeyIndex->SetUserFunction(HotKeyIndexCallback);
	Add(hotKeyIndex);

	// Add the test object.
	testObject = new TestObj;
	ZafGroup *group = DynamicPtrCast(testObject, ZafGroup);
	ZafButton *groupButton = new ZafButton(0, 0, 10, 1, new ZafStringData("Check1"), ZAF_NULLP(ZafBitmapData), ZAF_CHECK_BOX);
	groupButton->SetAllowToggling(true);
	groupButton->SetHzJustify(ZAF_HZ_LEFT);
	groupButton->SetHotKey('1', 5);
	group->Add(groupButton);
	groupButton = new ZafButton(0, 1, 10, 1, new ZafStringData("Check2"), ZAF_NULLP(ZafBitmapData), ZAF_CHECK_BOX);
	groupButton->SetAllowToggling(true);
	groupButton->SetHzJustify(ZAF_HZ_LEFT);
	groupButton->SetHotKey('2', 5);
	group->Add(groupButton);
	groupButton = new ZafButton(0, 2, 10, 1, new ZafStringData("Check3"), ZAF_NULLP(ZafBitmapData), ZAF_CHECK_BOX);
	groupButton->SetAllowToggling(true);
	groupButton->SetHzJustify(ZAF_HZ_LEFT);
	groupButton->SetHotKey('3', 5);
	group->Add(groupButton);
	groupButton = new ZafButton(0, 3, 10, 1, new ZafStringData("Check4"), ZAF_NULLP(ZafBitmapData), ZAF_CHECK_BOX);
	groupButton->SetAllowToggling(true);
	groupButton->SetHzJustify(ZAF_HZ_LEFT);
	groupButton->SetHotKey('4', 5);
	group->Add(groupButton);
	groupButton = new ZafButton(11, 0, 10, 1, new ZafStringData("Check5"), ZAF_NULLP(ZafBitmapData), ZAF_CHECK_BOX);
	groupButton->SetAllowToggling(true);
	groupButton->SetHzJustify(ZAF_HZ_LEFT);
	groupButton->SetHotKey('5', 5);
	group->Add(groupButton);
	groupButton = new ZafButton(11, 1, 10, 1, new ZafStringData("Check6"), ZAF_NULLP(ZafBitmapData), ZAF_CHECK_BOX);
	groupButton->SetAllowToggling(true);
	groupButton->SetHzJustify(ZAF_HZ_LEFT);
	groupButton->SetHotKey('6', 5);
	group->Add(groupButton);
	groupButton = new ZafButton(11, 2, 10, 1, new ZafStringData("Check7"), ZAF_NULLP(ZafBitmapData), ZAF_CHECK_BOX);
	groupButton->SetAllowToggling(true);
	groupButton->SetHzJustify(ZAF_HZ_LEFT);
	groupButton->SetHotKey('7', 5);
	group->Add(groupButton);
	groupButton = new ZafButton(11, 3, 10, 1, new ZafStringData("Check8"), ZAF_NULLP(ZafBitmapData), ZAF_CHECK_BOX);
	groupButton->SetAllowToggling(true);
	groupButton->SetHzJustify(ZAF_HZ_LEFT);
	groupButton->SetHotKey('8', 5);
	group->Add(groupButton);

	Add(testObject);

	// Add other objects needed to test the object.
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafGroup *group = DynamicPtrCast(testObject, ZafGroup);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.
	case TST_TOGGLE_SELECTION_TYPE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_SELECTION_TYPE);
			group->SetSelectionType(attr->Selected() ? ZAF_MULTIPLE_SELECTION : ZAF_SINGLE_SELECTION);
			attr->SetSelected(group->SelectionType() != ZAF_SINGLE_SELECTION);

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_AUTO_SELECT:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_SELECT);
			group->SetAutoSelect(attr->Selected());
			attr->SetSelected(group->AutoSelect());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafGroup *group = DynamicPtrCast(testObject, ZafGroup);
 
	// Preset attributes according to test object's settings.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_SELECTION_TYPE)->SetSelected(group->SelectionType() != ZAF_SINGLE_SELECTION);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_SELECT)->SetSelected(group->AutoSelect());

	GenericTestWin::SynchronizeAttributes();
}
