//	Zinc Application Framework - DISPLAY.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_appall.hpp>
#include "testevt.hpp"

static ZafLogicalColor bitmapArray[] =
{
#define _ ZAF_CLR_BLACK,
#define O ZAF_CLR_BACKGROUND,
#define I ZAF_CLR_YELLOW,
		O O O O O O O O O O O O I I I I I I I I O O O O O O O O O O O O
		O O O O O O O O O I I I I I I I I I I I I I I O O O O O O O O O
		O O O O O O O I I I I I I I I I I I I I I I I I I O O O O O O O
		O O O O O O I I I I I I I I I I I I I I I I I I I I O O O O O O
		O O O O O I I I I I I I I I I I I I I I I I I I I I I O O O O O
		O O O O I I I I I I I I I I I I I I I I I I I I I I I I O O O O
		O O O I I I I I I I I I I I I I I I I I I I I I I I I I I O O O
		O O I I I I I I I I I I I I I I I I I I I I I I I I I I I I O O
		O O I I I I I I I _ _ _ I I I I I I I I _ _ _ I I I I I I I O O
		O I I I I I I I _ _ _ _ _ I I I I I I _ _ _ _ _ I I I I I I I O
		O I I I I I I I _ _ _ _ _ I I I I I I _ _ _ _ _ I I I I I I I O
		O I I I I I I I _ _ _ _ _ I I I I I I _ _ _ _ _ I I I I I I I O
		I I I I I I I I I _ _ _ I I I I I I I I _ _ _ I I I I I I I I I
		I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I
		I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I
		I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I
		I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I
		I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I
		I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I I
		I I I I I _ _ I I I I I I I I I I I I I I I I I I _ _ I I I I I
		O I I I I _ _ I I I I I I I I I I I I I I I I I I _ _ I I I I O
		O I I I I _ _ _ I I I I I I I I I I I I I I I I _ _ _ I I I I O
		O I I I I I _ _ I I I I I I I I I I I I I I I I _ _ I I I I I O
		O O I I I I _ _ _ I I I I I I I I I I I I I I _ _ _ I I I I O O
		O O I I I I I _ _ _ _ I I I I I I I I I I _ _ _ _ I I I I I O O
		O O O I I I I I _ _ _ _ _ _ I I I I I _ _ _ _ _ I I I I I O O O
		O O O O I I I I I I _ _ _ _ _ _ _ _ _ _ _ _ I I I I I I O O O O
		O O O O O I I I I I I I I _ _ _ _ _ _ I I I I I I I I O O O O O
		O O O O O O I I I I I I I I I I I I I I I I I I I I O O O O O O
		O O O O O O O I I I I I I I I I I I I I I I I I I O O O O O O O
		O O O O O O O O O I I I I I I I I I I I I I I O O O O O O O O O
		O O O O O O O O O O O O I I I I I I I I O O O O O O O O O O O O
#undef _
#undef O
#undef I
};

static ZafImageStruct bitmapInfo = 
{
	32, 32, (ZafLogicalColor *)bitmapArray
};

static ZafBitmapData bitmapData(bitmapInfo);
static ZafIconData iconData(bitmapInfo);

class DisplayTestObject : public ZafWindowObject
{
public:
	DisplayTestObject(int left, int top, int width, int height);

	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
};

class DisplayTestWindow : public ZafWindow
{
public:
	DisplayTestWindow();
	virtual ZafEventType Event(const ZafEventStruct &event);
	void SetDisplayAttributes();
	bool Clip();
};

DisplayTestObject::DisplayTestObject(int left, int top, int width, int height) :
	ZafWindowObject(left, top, width, height)
{
	SetOSDraw(false);
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));
//	SetRegionType(ZAF_AVAILABLE_REGION);
}

ZafEventType DisplayTestObject::Draw(const ZafEventStruct &, ZafEventType ccode)
{
	// Compute the actual draw region.
	ZafRegionStruct drawRegion = BeginDraw();

	display->SetBackground(ZAF_CLR_LIGHTGRAY);
	display->Rectangle(drawRegion, 0, true);

	drawRegion -= 16;
	int xMid = drawRegion.left + drawRegion.Width() / 2;
	int yMid = drawRegion.top + drawRegion.Height() / 2;

	DisplayTestWindow *testWin = DynamicPtrCast(parent, DisplayTestWindow);
	
	testWin->SetDisplayAttributes();

	if (testWin->Clip())
		display->SetClipRegion(drawRegion);

	display->Rectangle(drawRegion);

	ZafRegionStruct textSize = display->TextSize(ZAF_ITEXT("Text"));
	int textWidth = textSize.Width();
	int textHeight = textSize.Height();

	display->Text(drawRegion.left - textWidth / 2, drawRegion.top - textHeight / 2, ZAF_ITEXT("Text"), -1, -1, true);
	display->Text(drawRegion.right - textWidth / 2, drawRegion.top - textHeight / 2, ZAF_ITEXT("Text"), -1, -1, true);
	display->Text(drawRegion.left - textWidth / 2, drawRegion.bottom - textHeight / 2, ZAF_ITEXT("Text"));
	display->Text(drawRegion.right - textWidth / 2, drawRegion.bottom - textHeight / 2, ZAF_ITEXT("Text"));

	display->Ellipse(drawRegion.left - 16, drawRegion.top + 16, drawRegion.left + 16, drawRegion.top + 48,
		45, 135, 1, true);
	display->Ellipse(drawRegion.left - 16, drawRegion.bottom - 48, drawRegion.left + 16, drawRegion.bottom - 16,
		0, 360);

	int numPoints = 5;
	static int tPoints[10] = { 15, 0, 30, 15, 21, 30, 9, 30, 0, 15 };
	static int points[10];

	int i, j;
	for (i = 0, j = 0; i < numPoints; i++, j += 2)
	{
		points[j] = tPoints[j] + drawRegion.left + 32;
		points[j+1] = tPoints[j+1] + drawRegion.top;
	}
	display->Polygon(numPoints, points, 1, true, true);

	for (i = 0, j = 0; i < numPoints; i++, j += 2)
	{
		points[j] = tPoints[j] + drawRegion.left + 32;
		points[j+1] = tPoints[j+1] + drawRegion.bottom - 15;
	}
	display->Polygon(numPoints, points, 1, false, true);

	for (int y = 0; y < drawRegion.bottom + 16; y += 5)
		display->Pixel(xMid - 32, y);

	display->Line(xMid + 40, drawRegion.top - 16, xMid + 70, drawRegion.bottom + 16);
	display->Line(xMid + 70, drawRegion.top - 16, xMid + 40, drawRegion.bottom + 16, 5);

	display->Rectangle(drawRegion.right - 16, yMid - 48, drawRegion.right + 16, yMid - 32, 2, true);
	display->Rectangle(drawRegion.right - 16, yMid + 32, drawRegion.right + 16, yMid + 48, 2);

	// Draw bitmaps last because they will change color settings.
	display->Bitmap(xMid - 16, drawRegion.top - 16, bitmapData);
	display->Bitmap(drawRegion.left - 16, yMid - 16, bitmapData);

	display->Icon(drawRegion.right - 16, yMid - 16, iconData);
	display->Icon(xMid - 16, drawRegion.bottom - 16, iconData);

	EndDraw();
	return (ccode);
}

DisplayTestWindow::DisplayTestWindow() : ZafWindow(1, 1, 75, 10)
{
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton);
	Add(new ZafTitle(new ZafStringData("Display")));

	SetSizeable(false);

	Add(new ZafPrompt(1, 1, 10, new ZafStringData("Clip:")));
	ZafComboBox *combo = new ZafComboBox(10, 1, 15, 3);
	combo->SetViewOnly(true);
	combo->SetStringID(ZAF_ITEXT("CLIP_COMBO"));
	ZafButton *option = new ZafButton(0, 0, 0, 0, new ZafStringData("No"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(false);
	option->SetHzJustify(ZAF_HZ_LEFT);
	option->SetSelected(true);
	combo->Add(option);
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("Yes"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(true);
	option->SetHzJustify(ZAF_HZ_LEFT);
	combo->Add(option);
	Add(combo);

	Add(new ZafPrompt(1, 2, 10, new ZafStringData("Back:")));
	combo = new ZafComboBox(10, 2, 15, 3);
	combo->SetViewOnly(true);
	combo->SetStringID(ZAF_ITEXT("BACK_COLOR_COMBO"));
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("Yellow"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_CLR_YELLOW);
	option->SetHzJustify(ZAF_HZ_LEFT);
	option->SetSelected(true);
	combo->Add(option);
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("Light blue"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_CLR_LIGHTBLUE);
	option->SetHzJustify(ZAF_HZ_LEFT);
	combo->Add(option);
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("Light red"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_CLR_LIGHTRED);
	option->SetHzJustify(ZAF_HZ_LEFT);
	combo->Add(option);
	Add(combo);

	Add(new ZafPrompt(1, 3, 10, new ZafStringData("Fore:")));
	combo = new ZafComboBox(10, 3, 15, 3);
	combo->SetViewOnly(true);
	combo->SetStringID(ZAF_ITEXT("FORE_COLOR_COMBO"));
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("Blue"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_CLR_BLUE);
	option->SetHzJustify(ZAF_HZ_LEFT);
	option->SetSelected(true);
	combo->Add(option);
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("Green"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_CLR_GREEN);
	option->SetHzJustify(ZAF_HZ_LEFT);
	combo->Add(option);
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("Brown"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_CLR_BROWN);
	option->SetHzJustify(ZAF_HZ_LEFT);
	combo->Add(option);
	Add(combo);

	Add(new ZafPrompt(1, 4, 10, new ZafStringData("Font:")));
	combo = new ZafComboBox(10, 4, 15, 3);
	combo->SetViewOnly(true);
	combo->SetStringID(ZAF_ITEXT("FONT_COMBO"));
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("Dialog"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_FNT_DIALOG);
	option->SetHzJustify(ZAF_HZ_LEFT);
	option->SetSelected(true);
	combo->Add(option);
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("Small"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_FNT_SMALL);
	option->SetHzJustify(ZAF_HZ_LEFT);
	combo->Add(option);
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("System"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_FNT_SYSTEM);
	option->SetHzJustify(ZAF_HZ_LEFT);
	combo->Add(option);
	Add(combo);

	Add(new ZafPrompt(1, 5, 10, new ZafStringData("Mode:")));
	combo = new ZafComboBox(10, 5, 15, 3);
	combo->SetViewOnly(true);
	combo->SetStringID(ZAF_ITEXT("MODE_COMBO"));
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("Copy"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_MODE_COPY);
	option->SetHzJustify(ZAF_HZ_LEFT);
	option->SetSelected(true);
	combo->Add(option);
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("XOR"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_MODE_XOR);
	option->SetHzJustify(ZAF_HZ_LEFT);
	combo->Add(option);
	Add(combo);

	Add(new ZafPrompt(1, 6, 10, new ZafStringData("Fill ptn:")));
	combo = new ZafComboBox(10, 6, 15, 3);
	combo->SetViewOnly(true);
	combo->SetStringID(ZAF_ITEXT("FILL_PATTERN_COMBO"));
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("Solid"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_PTN_SOLID_FILL);
	option->SetHzJustify(ZAF_HZ_LEFT);
	option->SetSelected(true);
	combo->Add(option);
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("Interleave"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_PTN_INTERLEAVE_FILL);
	option->SetHzJustify(ZAF_HZ_LEFT);
	combo->Add(option);
	Add(combo);

	Add(new ZafPrompt(1, 7, 10, new ZafStringData("Line type:")));
	combo = new ZafComboBox(10, 7, 15, 3);
	combo->SetViewOnly(true);
	combo->SetStringID(ZAF_ITEXT("LINE_STYLE_COMBO"));
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("Solid"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_LINE_SOLID);
	option->SetHzJustify(ZAF_HZ_LEFT);
	option->SetSelected(true);
	combo->Add(option);
	option = new ZafButton(0, 0, 0, 0, new ZafStringData("Dotted"), ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON);
	option->SetValue(ZAF_LINE_DOTTED);
	option->SetHzJustify(ZAF_HZ_LEFT);
	combo->Add(option);
	Add(combo);

	ZafButton *apply = new ZafButton(5, 8, 10, 1, new ZafStringData("Apply"));
	apply->SetValue(TST_REDRAW);
	apply->SetSendMessageWhenSelected(true);
	apply->SetAutoSize(false);
	Add(apply);

	Add(new DisplayTestObject(30, 1, 40, 8));
}

bool DisplayTestWindow::Clip()
{
	ZafComboBox *clipCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("CLIP_COMBO")), ZafComboBox);
	ZafButton *button = DynamicPtrCast(clipCombo->Current(), ZafButton);
	return (button->Value());
}

ZafEventType DisplayTestWindow::Event(const ZafEventStruct &event)
{
	ZafEventType ccode = event.type;
	switch (ccode)
	{
	case TST_REDRAW:
		GetObject(ZAF_ITEXT("TEST_OBJECT"))->Event(S_REDISPLAY);
		break;

	default:
		ccode = ZafWindow::Event(event);
		break;
	}

	return (ccode);
}

void DisplayTestWindow::SetDisplayAttributes()
{
	ZafComboBox *combo;
	ZafButton *option;

	combo = DynamicPtrCast(GetObject(ZAF_ITEXT("BACK_COLOR_COMBO")), ZafComboBox);
	option = DynamicPtrCast(combo->Current(), ZafButton);
	display->SetBackground((ZafLogicalColor)option->Value());

	combo = DynamicPtrCast(GetObject(ZAF_ITEXT("FORE_COLOR_COMBO")), ZafComboBox);
	option = DynamicPtrCast(combo->Current(), ZafButton);
	display->SetForeground((ZafLogicalColor)option->Value());

	combo = DynamicPtrCast(GetObject(ZAF_ITEXT("FONT_COMBO")), ZafComboBox);
	option = DynamicPtrCast(combo->Current(), ZafButton);
	display->SetFont((ZafLogicalFont)option->Value());

	combo = DynamicPtrCast(GetObject(ZAF_ITEXT("MODE_COMBO")), ZafComboBox);
	option = DynamicPtrCast(combo->Current(), ZafButton);
	display->SetMode((ZafLogicalMode)option->Value());

	combo = DynamicPtrCast(GetObject(ZAF_ITEXT("FILL_PATTERN_COMBO")), ZafComboBox);
	option = DynamicPtrCast(combo->Current(), ZafButton);
	display->SetFillPattern((ZafLogicalFillPattern)option->Value());

	combo = DynamicPtrCast(GetObject(ZAF_ITEXT("LINE_STYLE_COMBO")), ZafComboBox);
	option = DynamicPtrCast(combo->Current(), ZafButton);
	display->SetLineStyle((ZafLogicalLineStyle)option->Value());
}

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	zafWindowManager->Add(new DisplayTestWindow);

	// Get the user input.
	Control();

	// Return success.
	return (0);
}
