//	Zinc Application Framework - BUTTON.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_stdlib.hpp>
//#include <z_error.hpp>
#include "maintest.hpp"

ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafButton
	{ ZAF_ITEXT("Auto size"),         0, TST_TOGGLE_AUTO_SIZE },
	{ ZAF_ITEXT("Allow default"),     0, TST_TOGGLE_ALLOW_DEFAULT },
	{ ZAF_ITEXT("Allow toggle"),      0, TST_TOGGLE_ALLOW_TOGGLE },
	{ ZAF_ITEXT("Auto repeat"),       0, TST_TOGGLE_AUTO_REPEAT },
	{ ZAF_ITEXT("Default button *"),  0, TST_TOGGLE_DEFAULT_BUTTON },
	{ ZAF_ITEXT("Double click"),      0, TST_TOGGLE_DOUBLE_CLICK },
	{ ZAF_ITEXT("Down click"),        0, TST_TOGGLE_DOWN_CLICK },
	{ ZAF_ITEXT("Send message"),      0, TST_TOGGLE_SEND_MESSAGE },
	{ ZAF_ITEXT("Bitmap *"),          0, TST_TOGGLE_BITMAP },

	// ZafWindowObject
	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),       0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

static ZafLogicalColor bitmapArray1[16][16] =
{
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
	{ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 },
	{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
	{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
	{ 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 },
	{ 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
	{ 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 },
	{ 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8 },
	{ 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9 },
	{ 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 },
	{ 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 },
	{ 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12 },
	{ 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13 },
	{ 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14 },
	{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 }
};

static ZafImageStruct bitmapInfo1 = 
{
	16, 16, (ZafLogicalColor *)bitmapArray1
};

static ZafBitmapData bitmapData1(bitmapInfo1);

ZafEventType HotKeyStringCallback(ZafWindowObject *object, ZafEventStruct &, ZafEventType ccode)
{
	if (ccode == L_SELECT || ccode == N_NON_CURRENT)
	{
		ZafButton *testObject = DynamicPtrCast(DynamicPtrCast(object->parent, GenericTestWin)->TestObject(), ZafButton);
		testObject->SetHotKey(*object->Text(), testObject->HotKeyIndex());
		ZafIChar buf[2];
		buf[0] = testObject->HotKeyChar();
		buf[1] = '\0';
		object->SetText(buf);
	}

	return (0);
}

ZafEventType HotKeyIndexCallback(ZafWindowObject *object, ZafEventStruct &, ZafEventType ccode)
{
	if (ccode == L_SELECT || ccode == N_NON_CURRENT)
	{
		ZafButton *testObject = DynamicPtrCast(DynamicPtrCast(object->parent, GenericTestWin)->TestObject(), ZafButton);
		testObject->SetHotKey(testObject->HotKeyChar(), atoi(object->Text()));
		ZafSpinControl *spin = DynamicPtrCast(object, ZafSpinControl);
		ZafInteger *integer = DynamicPtrCast(spin->Current(), ZafInteger);
		integer->SetIntegerData(new ZafIntegerData(testObject->HotKeyIndex()));
	}

	return (0);
}

// ---- Derived test object -------------------------------------------------

// Derive a test object so can log which events it gets.
class TestObj : public ZafButton
{
public:
  	TestObj(void);
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj(void) :
	ZafButton(50, 2, 15, 1, new ZafStringData(ZAF_ITEXT("button")), new ZafBitmapData(bitmapData1))
{
	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafButton::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	if (ccode == S_DROP_DEFAULT || ccode == S_DROP_COPY || ccode == S_DROP_MOVE)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_BITMAP)->SetSelected(BitmapData() ? true : false);
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 11)
{
	// The test object can place settings combo boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	// Set the title text.
	SetText(ZAF_ITEXT("Button"));

	// Add settings objects.

	// Create horizontal justify combo box.
	ZafComboBox *hzJustifyCombo = new ZafComboBox(27, 1, 20, 3);
	hzJustifyCombo->SetViewOnly(true);
	hzJustifyCombo->SetStringID(ZAF_ITEXT("HZ_JUSTIFY_COMBO"));
	hzJustifyCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	ZafButton *attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz left"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_LEFT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz center"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_CENTER);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER);
	hzJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Hz right"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_HZ_JUSTIFY_RIGHT);
	attr->SetNumberID((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT);
	hzJustifyCombo->Add(attr);

	Add(hzJustifyCombo);

	// Create vertical justify combo box.
	ZafComboBox *vtJustifyCombo = new ZafComboBox(27, 2, 20, 3);
	vtJustifyCombo->SetViewOnly(true);
	vtJustifyCombo->SetStringID(ZAF_ITEXT("VT_JUSTIFY_COMBO"));
	vtJustifyCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Vt top"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_VT_JUSTIFY_TOP);
	attr->SetNumberID((ZafNumberID)TST_SET_VT_JUSTIFY_TOP);
	vtJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Vt Center"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_VT_JUSTIFY_CENTER);
	attr->SetNumberID((ZafNumberID)TST_SET_VT_JUSTIFY_CENTER);
	vtJustifyCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Vt Bottom"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_VT_JUSTIFY_BOTTOM);
	attr->SetNumberID((ZafNumberID)TST_SET_VT_JUSTIFY_BOTTOM);
	vtJustifyCombo->Add(attr);

	Add(vtJustifyCombo);

	Add(new ZafPrompt(1, 8, 10, new ZafStringData("Hotkey char:")));
	ZafString *hotKeyString = new ZafString(13, 8, 3, new ZafStringData("", 1));
	hotKeyString->SetUserFunction(HotKeyStringCallback);
	Add(hotKeyString);

	Add(new ZafPrompt(17, 8, 10, new ZafStringData("Hotkey index:")));
	ZafSpinControl *hotKeyIndex = new ZafSpinControl(29, 8, 8, new ZafIntegerData(1));
	hotKeyIndex->Add(new ZafInteger(0, 0, 0, new ZafIntegerData(-1L)));
	hotKeyIndex->SetUserFunction(HotKeyIndexCallback);
	Add(hotKeyIndex);

	// Create type combo box.
	Add(new ZafPrompt(1, 9, 5, new ZafStringData("Type:")));
	ZafComboBox *typeCombo = new ZafComboBox(6, 9, 10, 3);
	typeCombo->SetStringID(ZAF_ITEXT("TYPE_COMBO"));
	typeCombo->SetViewOnly(true);
	typeCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Native"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_NATIVE_BUTTON);
	attr->SetNumberID((ZafNumberID)TST_SET_NATIVE_BUTTON);
	typeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Radio"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_RADIO_BUTTON);
	attr->SetNumberID((ZafNumberID)TST_SET_RADIO_BUTTON);
	typeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Check"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_CHECK_BOX);
	attr->SetNumberID((ZafNumberID)TST_SET_CHECK_BOX);
	typeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("3D"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_3D_BUTTON);
	attr->SetNumberID((ZafNumberID)TST_SET_3D_BUTTON);
	typeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Flat"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_FLAT_BUTTON);
	attr->SetNumberID((ZafNumberID)TST_SET_FLAT_BUTTON);
	typeCombo->Add(attr);

	Add(typeCombo);

	// Create value combo box.
	Add(new ZafPrompt(18, 9, 7, new ZafStringData("Value: *")));
	ZafComboBox *valueCombo = new ZafComboBox(27, 9, 12, 3);
	valueCombo->SetStringID(ZAF_ITEXT("VALUE_COMBO"));
	valueCombo->SetViewOnly(true);
	valueCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("None"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_VALUE_NONE);
	attr->SetNumberID((ZafNumberID)TST_SET_VALUE_NONE);
	valueCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Beep"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_VALUE_BEEP);
	attr->SetNumberID((ZafNumberID)TST_SET_VALUE_BEEP);
	valueCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Redisplay"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_VALUE_REDISPLAY);
	attr->SetNumberID((ZafNumberID)TST_SET_VALUE_REDISPLAY);
	valueCombo->Add(attr);

	Add(valueCombo);

	// Add the test object.
	testObject = new TestObj;
	Add(testObject);

	// Add other objects needed to test the object.
	ZafButton *button = new ZafButton(50, 5, 15, 1, new ZafStringData("Drag & drop"));
	button->SetAcceptDrop(true);
	button->SetCopyDraggable(true);
	button->SetMoveDraggable(true);
	Add(button);

	ZafString *string = new ZafString(50, 6, 15, new ZafStringData("Drag & drop"));
	string->SetAcceptDrop(true);
	string->SetCopyDraggable(true);
	string->SetMoveDraggable(true);
	Add(string);
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafButton *button = DynamicPtrCast(testObject, ZafButton);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.
	case TST_TOGGLE_AUTO_SIZE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_SIZE);
			button->SetAutoSize(attr->Selected());
			attr->SetSelected(button->AutoSize());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_ALLOW_DEFAULT:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_ALLOW_DEFAULT);
			button->SetAllowDefault(attr->Selected());
			attr->SetSelected(button->AllowDefault());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_ALLOW_TOGGLE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_ALLOW_TOGGLE);
			button->SetAllowToggling(attr->Selected());
			attr->SetSelected(button->AllowToggling());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_AUTO_REPEAT:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_REPEAT);
			button->SetAutoRepeatSelection(attr->Selected());
			attr->SetSelected(button->AutoRepeatSelection());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_DEFAULT_BUTTON:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_DEFAULT_BUTTON);
			SetDefaultButton((DefaultButton(true) == button) ? ZAF_NULLP(ZafButton) : button);
			attr->SetSelected(DefaultButton(true) == button);

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_SELECTED:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_SELECTED);
			button->SetSelected(attr->Selected());
			attr->SetSelected(button->Selected());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_DOUBLE_CLICK:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_DOUBLE_CLICK);
			button->SetSelectOnDoubleClick(attr->Selected());
			attr->SetSelected(button->SelectOnDoubleClick());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_DOWN_CLICK:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_DOWN_CLICK);
			button->SetSelectOnDownClick(attr->Selected());
			attr->SetSelected(button->SelectOnDownClick());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_SEND_MESSAGE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_SEND_MESSAGE);
			button->SetSendMessageWhenSelected(attr->Selected());
			attr->SetSelected(button->SendMessageWhenSelected());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_BITMAP:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_BITMAP);
			if (attr->Selected())
				button->SetBitmapData(new ZafBitmapData(bitmapData1));
			else
				button->ClearImage();

			attr->SetSelected(button->BitmapData() ? true : false);

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_SET_NATIVE_BUTTON:
	case TST_SET_RADIO_BUTTON: 
	case TST_SET_CHECK_BOX:
	case TST_SET_3D_BUTTON:    
	case TST_SET_FLAT_BUTTON:
		{
			button->SetButtonType((ZafButtonType)(ccode - TST_SET_NATIVE_BUTTON));

			ZafComboBox *typeCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("TYPE_COMBO")), ZafComboBox);
			switch (button->ButtonType())
			{
			case ZAF_NATIVE_BUTTON:
				typeCombo->GetObject((ZafNumberID)TST_SET_NATIVE_BUTTON)->SetSelected(true);
				break;

			case ZAF_RADIO_BUTTON:
				typeCombo->GetObject((ZafNumberID)TST_SET_RADIO_BUTTON)->SetSelected(true);
				break;

			case ZAF_CHECK_BOX:
				typeCombo->GetObject((ZafNumberID)TST_SET_CHECK_BOX)->SetSelected(true);
				break;

			case ZAF_3D_BUTTON:
				typeCombo->GetObject((ZafNumberID)TST_SET_3D_BUTTON)->SetSelected(true);
				break;

			case ZAF_FLAT_BUTTON:
				typeCombo->GetObject((ZafNumberID)TST_SET_FLAT_BUTTON)->SetSelected(true);
				break;

			case ZAF_TOOLBAR_BUTTON:
				// ???
				break;
			}
		}
		break;

	case TST_SET_VALUE_NONE:
	case TST_SET_VALUE_BEEP:
	case TST_SET_VALUE_REDISPLAY:
		{
			if (ccode == TST_SET_VALUE_NONE)
				button->SetValue(0);
			else if (ccode == TST_SET_VALUE_BEEP)
				button->SetValue(TST_BEEP);
		 	else if (ccode == TST_SET_VALUE_REDISPLAY)
				button->SetValue(TST_REDRAW);

			ZafComboBox *valueCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("VALUE_COMBO")), ZafComboBox);
			switch (button->Value())
			{
			case TST_SET_VALUE_NONE:
				valueCombo->GetObject((ZafNumberID)TST_SET_VALUE_NONE)->SetSelected(true);
				break;

			case TST_SET_VALUE_BEEP:
				valueCombo->GetObject((ZafNumberID)TST_SET_VALUE_BEEP)->SetSelected(true);
				break;

			case TST_SET_VALUE_REDISPLAY:
				valueCombo->GetObject((ZafNumberID)TST_SET_VALUE_REDISPLAY)->SetSelected(true);
				break;
			}
		}
		break;

	case TST_BEEP:
		ZafErrorSystem::Beep();
		break;

	case TST_SET_VT_JUSTIFY_TOP:
	case TST_SET_VT_JUSTIFY_CENTER:
	case TST_SET_VT_JUSTIFY_BOTTOM:
		{
		 	if (ccode == TST_SET_VT_JUSTIFY_TOP)
				button->SetVtJustify(ZAF_VT_TOP);
		 	else if (ccode == TST_SET_VT_JUSTIFY_CENTER)
				button->SetVtJustify(ZAF_VT_CENTER);
		 	else if (ccode == TST_SET_VT_JUSTIFY_BOTTOM)
				button->SetVtJustify(ZAF_VT_BOTTOM);

			ZafComboBox *vtJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("VT_JUSTIFY_COMBO")), ZafComboBox);
			switch (button->VtJustify())
			{
			case ZAF_VT_TOP:
				vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_TOP)->SetSelected(true);
				break;

			case ZAF_VT_CENTER:
				vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_CENTER)->SetSelected(true);
				break;

			case ZAF_VT_BOTTOM:
				vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_BOTTOM)->SetSelected(true);
				break;
			}
		}
		break;

	case TST_SET_HZ_JUSTIFY_LEFT:
	case TST_SET_HZ_JUSTIFY_CENTER:
	case TST_SET_HZ_JUSTIFY_RIGHT:
		{
		 	if (ccode == TST_SET_HZ_JUSTIFY_LEFT)
				button->SetHzJustify(ZAF_HZ_LEFT);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_CENTER)
				button->SetHzJustify(ZAF_HZ_CENTER);
		 	else if (ccode == TST_SET_HZ_JUSTIFY_RIGHT)
				button->SetHzJustify(ZAF_HZ_RIGHT);

			ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
			switch (button->HzJustify())
			{
			case ZAF_HZ_LEFT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
				break;

			case ZAF_HZ_CENTER:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
				break;

			case ZAF_HZ_RIGHT:
				hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
				break;
			}
		}
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafButton *button = DynamicPtrCast(testObject, ZafButton);

	// Preset attributes according to test object's settings.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_SIZE)->SetSelected(button->AutoSize());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_ALLOW_DEFAULT)->SetSelected(button->AllowDefault());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_ALLOW_TOGGLE)->SetSelected(button->AllowToggling());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_AUTO_REPEAT)->SetSelected(button->AutoRepeatSelection());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_DEFAULT_BUTTON)->SetSelected(DefaultButton(true) == button);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_DOUBLE_CLICK)->SetSelected(button->SelectOnDoubleClick());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_DOWN_CLICK)->SetSelected(button->SelectOnDownClick());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_SEND_MESSAGE)->SetSelected(button->SendMessageWhenSelected());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_BITMAP)->SetSelected(button->BitmapData() ? true : false);

	ZafComboBox *typeCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("TYPE_COMBO")), ZafComboBox);
	switch (button->ButtonType())
	{
	case ZAF_NATIVE_BUTTON:
		typeCombo->GetObject((ZafNumberID)TST_SET_NATIVE_BUTTON)->SetSelected(true);
		break;

	case ZAF_RADIO_BUTTON:
		typeCombo->GetObject((ZafNumberID)TST_SET_RADIO_BUTTON)->SetSelected(true);
		break;

	case ZAF_CHECK_BOX:
		typeCombo->GetObject((ZafNumberID)TST_SET_CHECK_BOX)->SetSelected(true);
		break;

	case ZAF_3D_BUTTON:
		typeCombo->GetObject((ZafNumberID)TST_SET_3D_BUTTON)->SetSelected(true);
		break;

	case ZAF_FLAT_BUTTON:
		typeCombo->GetObject((ZafNumberID)TST_SET_FLAT_BUTTON)->SetSelected(true);
		break;

	case ZAF_TOOLBAR_BUTTON:
		// ???
		break;
	}

	ZafComboBox *valueCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("VALUE_COMBO")), ZafComboBox);
	switch (button->Value())
	{
	case TST_SET_VALUE_NONE:
		valueCombo->GetObject((ZafNumberID)TST_SET_VALUE_NONE)->SetSelected(true);
		break;

	case TST_SET_VALUE_BEEP:
		valueCombo->GetObject((ZafNumberID)TST_SET_VALUE_BEEP)->SetSelected(true);
		break;

	case TST_SET_VALUE_REDISPLAY:
		valueCombo->GetObject((ZafNumberID)TST_SET_VALUE_REDISPLAY)->SetSelected(true);
		break;
	}

	ZafComboBox *hzJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("HZ_JUSTIFY_COMBO")), ZafComboBox);
	switch (button->HzJustify())
	{
	case ZAF_HZ_LEFT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_LEFT)->SetSelected(true);
		break;

	case ZAF_HZ_CENTER:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_CENTER)->SetSelected(true);
		break;

	case ZAF_HZ_RIGHT:
		hzJustifyCombo->GetObject((ZafNumberID)TST_SET_HZ_JUSTIFY_RIGHT)->SetSelected(true);
		break;
	}

	ZafComboBox *vtJustifyCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("VT_JUSTIFY_COMBO")), ZafComboBox);
	switch (button->VtJustify())
	{
	case ZAF_VT_TOP:
		vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_TOP)->SetSelected(true);
		break;

	case ZAF_VT_CENTER:
		vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_CENTER)->SetSelected(true);
		break;

	case ZAF_VT_BOTTOM:
		vtJustifyCombo->GetObject((ZafNumberID)TST_SET_VT_JUSTIFY_BOTTOM)->SetSelected(true);
		break;
	}

	GenericTestWin::SynchronizeAttributes();
}
