# Zinc Application Framework - BORLAND.MAK
# COPYRIGHT (C) 1990-1997.  All Rights Reserved.
# Zinc Software Incorporated.  Pleasant Grove, Utah  USA

# ===========================================================================
# Usage

usage:
	@type &&|

Usage:

make -f borland.mak win16      (16 bit Windows)
make -f borland.mak win32      (32 bit Windows)
make -f borland.mak win32dll   (32 bit Windows dll's)
make -f borland.mak dos16      (16 bit DOS extended)
|


# ===========================================================================
# Build dependencies

clean:
	z_clean

win16: wprmpt16 wstr16 wtime16 wreal16 wbnum16 wint16\
       wdate16 wfstr16 wbtn16 wutime16 wicon16 wprgrs16\
       wtext16 wspin16 wcombo16 wvlist16 whlist16 wtbar16\
       wsbar16 wgroup16 wntbk16 wscrl16 wtree16 wtritm16\
       wdisp16 wtable16 wsclwn16 wgmgmt16

win32: wprmpt32 wstr32 wtime32 wreal32 wbnum32 wint32\
       wdate32 wfstr32 wbtn32 wutime32 wicon32 wprgrs32\
       wtext32 wspin32 wcombo32 wvlist32 whlist32 wtbar32\
       wsbar32 wgroup32 wntbk32 wscrl32 wtree32 wtritm32\
       wdisp32 wtable32 wsclwn32 wgmgmt32

win32dll: wprmpt wstr wtime wreal wbnum wint\
       wdate wfstr wbtn wutime wicon wprgrs\
       wtext wspin wcombo wvlist whlist wtbar\
       wsbar wgroup wntbk wscrl wtree wtritm\
       wdisp wtable wsclwn wgmgmt

dos16: prmpt16 str16 time16 real16 bnum16 int16\
       date16 fstr16 btn16 utime16 icon16 prgrs16\
       text16 spin16 combo16 vlist16 hlist16 tbar16\
       sbar16 group16 ntbk16 scrl16 tree16 tritm16\
       disp16 table16 sclwn16 gmgmt16


# ===========================================================================
# Build options for each target

# Shared options
ZAF_ROOT=..
PERSISTENCE=all
DEBUG=off

# Target-specific options
!if "$(TARGET)" == "wprmpt16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=prompt.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wstr16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=string.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wint16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=integer.cpp maintest.cpp format.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wreal16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=real.cpp maintest.cpp format.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wbnum16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=bnum.cpp maintest.cpp format.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wtime16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=time.cpp maintest.cpp format.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wdate16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=date.cpp maintest.cpp format.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wfstr16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=fstr.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wbtn16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=button.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wutime16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=utime.cpp maintest.cpp format.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wicon16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=icon.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wprgrs16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=prgrs.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wtext16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=text.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wspin16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=spin.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wcombo16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=combo.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wvlist16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=vlist.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "whlist16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=hlist.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wtbar16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=tbar.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wsbar16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=status.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wgroup16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=group.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wntbk16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=ntbk.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wscrl16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=scroll.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wtree16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=tree.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wtritm16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=tritm.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wdisp16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=display.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wtable16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=table.cpp maintest.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wsclwn16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=sclwin.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wgmgmt16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=gmgmt.cpp
DEFINITION_FILE=wtest16.def

!elif "$(TARGET)" == "wprmpt32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=prompt.obw maintest.obw

!elif "$(TARGET)" == "wstr32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=string.obw maintest.obw

!elif "$(TARGET)" == "wint32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=integer.obw maintest.obw format.obw

!elif "$(TARGET)" == "wreal32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=real.obw maintest.obw format.obw

!elif "$(TARGET)" == "wbnum32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=bnum.obw maintest.obw format.obw

!elif "$(TARGET)" == "wtime32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=time.obw maintest.obw format.obw

!elif "$(TARGET)" == "wdate32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=date.obw maintest.obw format.obw

!elif "$(TARGET)" == "wfstr32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=fstr.obw maintest.obw

!elif "$(TARGET)" == "wbtn32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=button.obw maintest.obw

!elif "$(TARGET)" == "wutime32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=utime.obw maintest.obw format.obw

!elif "$(TARGET)" == "wicon32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=icon.obw maintest.obw

!elif "$(TARGET)" == "wprgrs32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=prgrs.obw maintest.obw

!elif "$(TARGET)" == "wtext32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=text.obw maintest.obw

!elif "$(TARGET)" == "wspin32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=spin.obw maintest.obw

!elif "$(TARGET)" == "wcombo32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=combo.obw maintest.obw

!elif "$(TARGET)" == "wvlist32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=vlist.obw maintest.obw

!elif "$(TARGET)" == "whlist32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=hlist.obw maintest.obw

!elif "$(TARGET)" == "wtbar32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=tbar.obw maintest.obw

!elif "$(TARGET)" == "wsbar32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=status.obw maintest.obw

!elif "$(TARGET)" == "wgroup32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=group.obw maintest.obw

!elif "$(TARGET)" == "wntbk32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=ntbk.obw maintest.obw

!elif "$(TARGET)" == "wscrl32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=scroll.obw maintest.obw

!elif "$(TARGET)" == "wtree32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=tree.obw maintest.obw

!elif "$(TARGET)" == "wtritm32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=tritm.obw maintest.obw

!elif "$(TARGET)" == "wdisp32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=display.obw

!elif "$(TARGET)" == "wtable32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=table.obw maintest.obw

!elif "$(TARGET)" == "wsclwn32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=sclwin.obw

!elif "$(TARGET)" == "wgmgmt32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=gmgmt.obw

!elif "$(TARGET)" == "wprmpt.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=prompt.obi maintest.obi

!elif "$(TARGET)" == "wstr.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=string.obi maintest.obi

!elif "$(TARGET)" == "wint.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=integer.obi maintest.obi format.obi

!elif "$(TARGET)" == "wreal.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=real.obi maintest.obi format.obi

!elif "$(TARGET)" == "wbnum.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=bnum.obi maintest.obi format.obi

!elif "$(TARGET)" == "wtime.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=time.obi maintest.obi format.obi

!elif "$(TARGET)" == "wdate.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=date.obi maintest.obi format.obi

!elif "$(TARGET)" == "wfstr.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=fstr.obi maintest.obi

!elif "$(TARGET)" == "wbtn.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=button.obi maintest.obi

!elif "$(TARGET)" == "wutime.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=utime.obi maintest.obi format.obi

!elif "$(TARGET)" == "wicon.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=icon.obi maintest.obi

!elif "$(TARGET)" == "wprgrs.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=prgrs.obi maintest.obi

!elif "$(TARGET)" == "wtext.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=text.obi maintest.obi

!elif "$(TARGET)" == "wspin.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=spin.obi maintest.obi

!elif "$(TARGET)" == "wcombo.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=combo.obi maintest.obi

!elif "$(TARGET)" == "wvlist.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=vlist.obi maintest.obi

!elif "$(TARGET)" == "whlist.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=hlist.obi maintest.obi

!elif "$(TARGET)" == "wtbar.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=tbar.obi maintest.obi

!elif "$(TARGET)" == "wsbar.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=status.obi maintest.obi

!elif "$(TARGET)" == "wgroup.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=group.obi maintest.obi

!elif "$(TARGET)" == "wntbk.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=ntbk.obi maintest.obi

!elif "$(TARGET)" == "wscrl.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=scroll.obi maintest.obi

!elif "$(TARGET)" == "wtree.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=tree.obi maintest.obi

!elif "$(TARGET)" == "wtritm.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=tritm.obi maintest.obi

!elif "$(TARGET)" == "wdisp.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=display.obi

!elif "$(TARGET)" == "wtable.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=table.obi maintest.obi

!elif "$(TARGET)" == "wsclwn.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=sclwin.obi

!elif "$(TARGET)" == "wgmgmt.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=gmgmt.obi
!endif

# ===========================================================================
# Continue build, or define options

!ifdef TARGET
# When options defined, build using ZAF 5 make files for Borland
!include "$(ZAF_ROOT)\include\zafbor.mak"

!else
# Define options (macros) based on command-line platform

wprmpt16 wstr16 wint16 wreal16 wbnum16 wtime16 \
wdate16 wfstr16 wbtn16 wutime16 wicon16 wprgrs16 \
wtext16 wspin16 wcombo16 wvlist16 whlist16 wtbar16 \
wsbar16 wgroup16 wntbk16 wscrl16 wtree16 wtritm16 \
wdisp16 wtable16 wsclwn16 wgmgmt16 wprmpt32 wstr32 \
wint32 wreal32 wbnum32 wtime32 wdate32 wfstr32 \
wbtn32 wutime32 wicon32 wprgrs32 wtext32 wspin32 \
wcombo32 wvlist32 whlist32 wtbar32 wsbar32 wgroup32 \
wntbk32 wscrl32 wtree32 wtritm32 wdisp32 wtable32 \
wsclwn32 wgmgmt32 wprmpt wstr wint wreal wbnum \
wtime wdate wfstr wbtn wutime wicon wprgrs \
wtext wspin wcombo wvlist whlist wtbar wsbar \
wgroup wntbk wscrl wtree wtritm wdisp wtable \
wsclwn wgmgmt:
	@ECHO .
	@ECHO .
	@ECHO Making $<.exe...
	@$(MAKE) -f borland.mak TARGET=$<.exe $<.exe

!endif
