//	Zinc Application Framework - Z_UNISTD.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_unistd.hpp>
#include <z_cset.hpp>

#if defined(ZAF_UNICODE)
#	include "u_unistd.cpp"
#elif defined(ZAF_ISO8859_1)
int ChDir(const ZafIChar *path)
{
	char mappedPath[ZAF_MAXPATHLEN];
	zafCodeSet->ConvertToOSString(path, mappedPath, false);
#undef chdir
	return OSchdir(mappedPath);
}

ZafIChar *GetCwd(ZafIChar *path, unsigned int)
{
	static char mappedPath[ZAF_MAXPATHLEN];
#undef getcwd
	if (OSgetcwd(mappedPath, ZAF_MAXPATHLEN))
	{
		zafCodeSet->ConvertToOSString(mappedPath, path, false);
		return path;
	}
	return ZAF_NULLP(ZafIChar);
}

int Rename(const ZafIChar *oldPath, const ZafIChar *newPath)
{
	char mappedOldPath[ZAF_MAXPATHLEN], mappedNewPath[ZAF_MAXPATHLEN];
	zafCodeSet->ConvertToOSString(oldPath, mappedOldPath, false);
	zafCodeSet->ConvertToOSString(newPath, mappedNewPath, false);
#undef rename
	return OSrename(mappedOldPath, mappedNewPath);
}

int Unlink(const ZafIChar *path)
{
	char mappedPath[ZAF_MAXPATHLEN];
	zafCodeSet->ConvertToOSString(path, mappedPath, false);
#undef unlink
	return OSunlink(mappedPath);
}
#else
	// We use the compiler's library for OEM characters
#endif
