//	Zinc Application Framework - Z_TIMER.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_timer.hpp>
#define ZAF_TIMER_INFO
#include "gbl_def.cpp"

// ----- ZafTimer -----------------------------------------------------------

ZafTimer::ZafTimer(ZafDeviceState state, unsigned long tInterval) :
	ZafDevice(E_TIMER, state), interval(tInterval), queueEvents(false), 
	notifyMessage(N_TIMER)
{
}

ZafTimer::ZafTimer(const ZafTimer &copy) :
	ZafDevice(E_TIMER, copy.deviceState), interval(copy.interval),
	queueEvents(copy.queueEvents), notifyMessage(copy.notifyMessage)
{
	// Do not copy the notify list, since two timers should not
	// send timer messages to the same objects.
}

ZafTimer::~ZafTimer(void)
{
}

unsigned long ZafTimer::SetInterval(unsigned long tInterval)
{
	interval = tInterval;
	return (interval);
}

bool ZafTimer::SetQueueEvents(bool tQueueEvents)
{
	queueEvents = tQueueEvents;
	return queueEvents;
}

// ----- ZafNotifyElement & ZafNotifyList -----------------------------------

ZafTimer::ZafNotifyList::ZafNotifyElement::ZafNotifyElement(ZafWindowObject *tNotifyObject, ZafEventType tNotifyMessage) :
	notifyObject(tNotifyObject), notifyMessage(tNotifyMessage)
{
}

ZafTimer::ZafNotifyList::ZafNotifyElement::~ZafNotifyElement(void)
{
}

ZafWindowObject *ZafTimer::ZafNotifyList::Add(ZafWindowObject *object, ZafWindowObject *position)
{
	// Check for a null object.
	if (!object)
		return (ZAF_NULLP(ZafWindowObject));

	// Add a new notify element.
	ZafNotifyElement *element = new ZafNotifyElement(object, 0);
	for (ZafNotifyElement *temp = First(); temp; temp = temp->Next())
		if (temp->notifyObject == position)
		{
			ZafList::Add(element, temp);	// position insert.
			return (object);
		}
	ZafList::Add(element);					// compareFunction insert.
	return (object);
}

ZafWindowObject *ZafTimer::ZafNotifyList::Add(ZafWindowObject *object, ZafEventType tNotifyMessage, ZafWindowObject *position)
{
	// Check for a null object.
	if (!object)
		return (ZAF_NULLP(ZafWindowObject));

	// Add a new notify element.
	ZafNotifyElement *element = new ZafNotifyElement(object, tNotifyMessage);
	for (ZafNotifyElement *temp = First(); temp; temp = temp->Next())
		if (temp->notifyObject == position)
		{
			ZafList::Add(element, temp);	// position insert.
			return (object);
		}
	ZafList::Add(element);					// compareFunction insert.
	return (object);
}

ZafWindowObject *ZafTimer::ZafNotifyList::Subtract(ZafWindowObject *object)
{
	// Make sure there is an object to subtract.
	if (!object)
		return (ZAF_NULLP(ZafWindowObject));

	// Remove the object from the list.
	for (ZafNotifyElement *temp = First(); temp; temp = temp->Next())
		if (temp->notifyObject == object)
		{
			ZafWindowObject *nextObject = temp->Next() ?
				temp->Next()->notifyObject : ZAF_NULLP(ZafWindowObject);
			ZafList::Subtract(temp);
			return (nextObject);
		}

	// Object is not in the list.
	return (ZAF_NULLP(ZafWindowObject));
}

