//	Zinc Application Framework - Z_TIME.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_time.hpp>
#define ZAF_TIME_DATA_INFO
#include "gbl_def.cpp"

// ----- ZafTimeData --------------------------------------------------------

ZafTimeData::ZafTimeData(void) :
	ZafUTimeData()
{
	// No additional information needs to be initialized.
}

ZafTimeData::ZafTimeData(int hour, int minute, int second, int milliSecond) :
	ZafUTimeData(0, 0, 0, hour, minute, second, milliSecond)
{
	// No additional information needs to be initialized.
}

ZafTimeData::ZafTimeData(const ZafIChar *string, const ZafIChar *format) :
	ZafUTimeData()
{
	// Set the time from the string argument.
	SetTime(string, format);
}

ZafTimeData::ZafTimeData(const ZafTimeData &copy) :
	ZafUTimeData(copy)
{
	// No additional information needs to be initialized.
}

ZafTimeData::ZafTimeData(const ZafUTimeData &copy) :
	ZafUTimeData(copy)
{
	// No additional information needs to be initialized.
}

ZafTimeData::~ZafTimeData(void)
{
	// No information needs to be deleted.
}

void ZafTimeData::Clear(void)
{
	// Defer to the base class.
	ZafUTimeData::Clear();
}

ZafData *ZafTimeData::Duplicate(void)
{
	return (new ZafTimeData(*this));
}

int ZafTimeData::FormattedText(ZafIChar *buffer, int maxLength, const ZafIChar *format) const
{
	// Format the text.
	return (Sprintf(buffer, maxLength, format ? format : zafLocale->time12StringOutputFormat));
}

ZafError ZafTimeData::SetTime(int hour, int minute, int second, int milliSecond)
{
	// Defer to the base class.
	return SetUTime(0, 0, 0, hour, minute, second, milliSecond);
}

ZafError ZafTimeData::SetTime(const ZafTimeData &time)
{
	// Defer to the base class.
	return SetUTime(time);
}

ZafError ZafTimeData::SetTime(const ZafIChar *buffer, const ZafIChar *format)
{
	// Reset the value.
	PushLevel();
	Sscanf(buffer, format ? format : zafLocale->timeStringInputFormat);
	PopLevel();

	// Return success.
	return (ZAF_ERROR_NONE);
}

// ----- Persistent functions -----------------------------------------------

ZafTimeData::ZafTimeData(const ZafIChar *name, ZafDataPersistence &persist) :
	ZafUTimeData(name, persist.PushLevel(className, classID, ZAF_PERSIST_FILE))
{
	Bind();
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

ZafElement *ZafTimeData::Read(const ZafIChar *name, ZafDataPersistence &persist)
{
	return (new ZafTimeData(name, persist));
}

void ZafTimeData::Write(ZafDataPersistence &persist)
{
	// Write the object.
	ZafUTimeData::Write(persist.PushLevel(className, classID, ZAF_PERSIST_FILE));
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

