//	Zinc Application Framework - Z_STDLIB.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_stdlib.hpp>
#include <z_cset.hpp>

#if defined(ZAF_UNICODE)
#	include "u_stdlib.cpp"
#elif defined(ZAF_ISO8859_1)
ZafIChar *GetEnv(const ZafIChar *envname)
{
	static ZafIChar newEnv[256];
	char mappedEnvname[256];
	zafCodeSet->ConvertToOSString(envname, mappedEnvname, false);
#undef getenv
	char *env = OSgetenv(mappedEnvname);
	zafCodeSet->ConvertToZafString(env, newEnv, false);
	newEnv[0] = 0;
	return newEnv;
}
#else
	// We use the compiler's library for OEM characters
#endif
