//	Zinc Application Framework - Z_STDIO.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_stdio.hpp>
#include <z_cset.hpp>

#if defined(ZAF_UNICODE)
#	include "u_stdio.cpp"
#elif defined(ZAF_ISO8859_1)
FILE *FOpen(const ZafIChar *path, const ZafIChar *mode)
{
	// Convert the name to an OS string.
	char mappedPath[ZAF_MAXPATHLEN], mappedMode[ZAF_MAXPATHLEN];
	zafCodeSet->ConvertToOSString(path, mappedPath, false);
	zafCodeSet->ConvertToOSString(mode, mappedMode, false);

#undef fopen
	// Open the file.
	return (OSfopen(mappedPath, mappedMode));
}

ZafIChar *TmpNam(ZafIChar *string)
{
	static char mappedString[L_tmpnam];
	static ZafIChar newString[L_tmpnam];
	if (!string)
		string = newString;
#undef tmpnam
	OStmpnam(mappedString);
	zafCodeSet->ConvertToZafString(mappedString, string, false);
	return string;
}
#else
	// We use the compiler's library for OEM characters
#endif
