//	Zinc Application Framework - Z_STATUS.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_status.hpp>
#define ZAF_STATUS_BAR_INFO
#include "gbl_def.cpp"

// ----- ZafStatusBar -------------------------------------------------------

ZafStatusBar::ZafStatusBar(int left, int top, int right, int bottom) :
	ZafWindow(left, top, right, bottom)
{
#if defined(ZAF_MSWINDOWS)
	// Check the image information.
	ImageAllocate();
#endif

	SetBordered(true);
	SetRegionType(ZAF_AVAILABLE_REGION);
	SetSupportObject(true);
	SetNoncurrent(true);
}

ZafStatusBar::ZafStatusBar(const ZafStatusBar &copy) :
	ZafWindow(copy)
{
#if defined(ZAF_MSWINDOWS)
	// Check the image information.
	ImageAllocate();
#endif

	// Set all children as non-system objects.  ZafWindow copy
	// constructor will not call ZafStatusBar::Add() since it is in the base
	// class phase of construction when the children are added.
	for (ZafWindowObject *object = First(); object; object = object->Next())
	{
		object->SetSystemObject(false);
		object->SetParentPalette(true);
		object->SetParentDrawBorder(true);
	}
}

ZafStatusBar::~ZafStatusBar(void)
{
}

ZafWindowObject *ZafStatusBar::Add(ZafWindowObject *object, ZafWindowObject *position)
{
	// Add the item to the list.
	object->SetSystemObject(false); // prevent object registration.
	object->SetParentPalette(true);
	object->SetParentDrawBorder(true);
	return (ZafWindow::Add(object, position));
}

ZafWindowObject *ZafStatusBar::Duplicate(void)
{
	return (new ZafStatusBar(*this));
}

const ZafPaletteStruct *ZafStatusBar::MapClassPalette(ZafPaletteType type, ZafPaletteState state)
{
	const ZafPaletteStruct *palette = MapPalette(defaultPaletteMap, type, state);
	return (palette ? palette : ZafWindow::MapClassPalette(type, state));
}

bool ZafStatusBar::SetAcceptDrop(bool )
{
	// acceptDrop is false for this class.
	acceptDrop = false;
	return (acceptDrop);
}

bool ZafStatusBar::SetDestroyable(bool )
{
	// destroyable is false for this class.
	destroyable = false;
	return (destroyable);
}

bool ZafStatusBar::SetDisabled(bool )
{
	// disabled is true for this class.
	disabled = true;
	return (disabled);
}

bool ZafStatusBar::SetFocus(bool )
{
	// focus is false for this class.
	focus = false;
	return (focus);
}

bool ZafStatusBar::SetLocked(bool )
{
	// locked is false for this class.
	locked = false;
	return (locked);
}

bool ZafStatusBar::SetMaximized(bool )
{
	// maximized is false for this class.
	maximized = false;
	return (maximized);
}

bool ZafStatusBar::SetMinimized(bool )
{
	// minimized is false for this class.
	minimized = false;
	return (minimized);
}

bool ZafStatusBar::SetMoveable(bool )
{
	// moveable is false for this class.
	moveable = false;
	return (moveable);
}

bool ZafStatusBar::SetNoncurrent(bool )
{
	// noncurrent is true for this class.
	noncurrent = true;
	return (noncurrent);
}

ZafRegionType ZafStatusBar::SetRegionType(ZafRegionType )
{
	// regionType is ZAF_AVAILABLE_REGION for this class.
	regionType = ZAF_AVAILABLE_REGION;
	return (regionType);
}

ZafSelectionType ZafStatusBar::SetSelectionType(ZafSelectionType )
{
	// selectionType is ZAF_SINGLE_SELECTION for this class.
	selectionType = ZAF_SINGLE_SELECTION;
	return (selectionType);
}

bool ZafStatusBar::SetSizeable(bool )
{
	// sizeable is false for this class.
	sizeable = false;
	return (sizeable);
}

bool ZafStatusBar::SetSupportObject(bool )
{
	// supportObject is true for this class.
	supportObject = true;
	return (supportObject);
}

bool ZafStatusBar::SetTemporary(bool )
{
	// temporary is false for this class.
	temporary = false;
	return (temporary);
}

ZafUserFunction ZafStatusBar::SetUserFunction(ZafUserFunction )
{
	// userFunction is null for this class.
	userFunction = ZAF_NULLF(ZafUserFunction);
	return (userFunction);
}

ZafWindowObject *ZafStatusBar::Subtract(ZafWindowObject *object)
{
	// Defer to the base class.
	return (ZafWindow::Subtract(object));
}

// ----- Persistent functions -----------------------------------------------

ZafStatusBar::ZafStatusBar(const ZafIChar *name, ZafObjectPersistence &persist) :
	ZafWindow(name, persist.PushLevel(className, classID, ZAF_PERSIST_DIRECTORY))
{
#if defined(ZAF_MSWINDOWS)
	// Check the image information.
	ImageAllocate();
#endif

	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());

	// Set all children as non-system objects.  ZafWindow persistent
	// constructor will not call ZafStatusBar::Add() since it is in the base
	// class phase of construction when the children are added.
	for (ZafWindowObject *object = First(); object; object = object->Next())
	{
		object->SetSystemObject(false);
		object->SetParentPalette(true);
		object->SetParentDrawBorder(true);
	}
}

ZafElement *ZafStatusBar::Read(const ZafIChar *name, ZafObjectPersistence &persist)
{
	return (new ZafStatusBar(name, persist));
}

void ZafStatusBar::Write(ZafObjectPersistence &persist)
{
	// Write the object.
	ZafWindow::Write(persist.PushLevel(className, classID, ZAF_PERSIST_DIRECTORY));
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

