//	Zinc Application Framework - Z_PLLDN1.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_plldn.hpp>
#include <z_string.hpp>

static ZafStringID _menuName = ZAF_ITEXT("menu");

// ----- ZafPullDownItem ----------------------------------------------------

ZafPullDownItem::ZafPullDownItem(ZafStringData *zStringData) :
	ZafButton(0, 0, zStringData ? strlen(zStringData->Text()) : 1, 1,
		zStringData, ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON),
	menu(0, 0)
{
	// Initialize the menu item information.
	SetHzJustify(ZAF_HZ_LEFT);
	SetDepth(0);
	SetAutoSize(false);

	menu.SetTemporary(true);
	menu.SetDestroyable(false);
	menu.parent = this;
	menu.SetStringID(_menuName);
}

ZafPullDownItem::ZafPullDownItem(const ZafIChar *text) :
	ZafButton(0, 0, text ? strlen(text) : 1, 1, text, ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON),
	menu(0, 0)
{
	// Initialize the menu item information.
	SetHzJustify(ZAF_HZ_LEFT);
	SetDepth(0);
	SetAutoSize(false);

	menu.SetTemporary(true);
	menu.SetDestroyable(false);
	menu.parent = this;
	menu.SetStringID(_menuName);
}

ZafPullDownItem::ZafPullDownItem(const ZafPullDownItem &copy) :
	ZafButton(copy), menu(copy.menu)
{
	// Initialize the menu item information.
	menu.parent = this;
}

ZafPullDownItem::~ZafPullDownItem(void)
{
	// No item information needs to be destroyed.
}

ZafWindowObject *ZafPullDownItem::Duplicate(void)
{
	return(new ZafPullDownItem(*this));
}

ZafWindowObject *ZafPullDownItem::FocusObject(void) const
{
	// Return a pointer to self.
	if (menu.Focus())
		return (menu.Current() ? menu.FocusObject() : (ZafWindowObject *)&menu);
	else if (focus)
		return ((ZafWindowObject *)this);
	return (ZAF_NULLP(ZafWindowObject));
}

ZafWindowObject *ZafPullDownItem::GetObject(ZafNumberID zNumberID)
{
	ZafWindowObject *match = ZafWindowObject::GetObject(zNumberID);
	if (!match)
		match = menu.GetObject(zNumberID);
	return (match);
}

ZafWindowObject *ZafPullDownItem::GetObject(const ZafIChar *zStringID)
{
	ZafWindowObject *match = ZafWindowObject::GetObject(zStringID);
	if (!match)
		match = menu.GetObject(zStringID);
	return (match);
}

const ZafPaletteStruct *ZafPullDownItem::MapClassPalette(ZafPaletteType type, ZafPaletteState state)
{
	const ZafPaletteStruct *palette = MapPalette(defaultPaletteMap, type, state);
	return (palette ? palette : ZafButton::MapClassPalette(type, state));
}

bool ZafPullDownItem::SetAcceptDrop(bool )
{
	// acceptDrop is false for this class.
	acceptDrop = false;
	return (acceptDrop);
}

bool ZafPullDownItem::SetAllowDefault(bool )
{
	// allowDefault is false for this class.
	allowDefault = false;
	return (allowDefault);
}

bool ZafPullDownItem::SetAllowToggling(bool )
{
	// allowToggling is false for this class.
	allowToggling = false;
	return (allowToggling);
}

bool ZafPullDownItem::SetAutoRepeatSelection(bool )
{
	// autoRepeatSelection is false for this class.
	autoRepeatSelection = false;
	return (autoRepeatSelection);
}

bool ZafPullDownItem::SetAutoSize(bool )
{
	// autoSize is true for this class.
	autoSize = false;
	return (autoSize);
}

ZafError ZafPullDownItem::SetBitmapData(ZafBitmapData *)
{
	// bitmapData is null for this class.
	bitmapData = ZAF_NULLP(ZafBitmapData);
	return (ZAF_ERROR_INVALID);
}

bool ZafPullDownItem::SetBordered(bool )
{
	// bordered is false for this class.
	bordered = false;
	return (bordered);
}

ZafButtonType ZafPullDownItem::SetButtonType(ZafButtonType )
{
	// buttonType is ZAF_FLAT_BUTTON for this class.
	buttonType = ZAF_FLAT_BUTTON;
	return (buttonType);
}

bool ZafPullDownItem::SetCopyDraggable(bool )
{
	// copyDraggable is false for this class.
	copyDraggable = false;
	return (copyDraggable);
}

bool ZafPullDownItem::SetDepressed(bool )
{
	// depressed is false for this class.
	depressed = false;
	return (depressed);
}

int ZafPullDownItem::SetDepth(int )
{
	// depth is 0 for this class.
	depth = 0;
	return (depth);
}

ZafHzJustify ZafPullDownItem::SetHzJustify(ZafHzJustify )
{
	// hzJustify is ZAF_HZ_LEFT for this class.
	hzJustify = ZAF_HZ_LEFT;
	return (hzJustify);
}

bool ZafPullDownItem::SetLinkDraggable(bool )
{
	// linkDraggable is false for this class.
	linkDraggable = false;
	return (linkDraggable);
}

bool ZafPullDownItem::SetMoveDraggable(bool )
{
	// moveDraggable is false for this class.
	moveDraggable = false;
	return (moveDraggable);
}

bool ZafPullDownItem::SetParentDrawBorder(bool )
{
	// parentDrawBorder is false for this class.
	parentDrawBorder = false;
	return (parentDrawBorder);
}

bool ZafPullDownItem::SetParentDrawFocus(bool )
{
	// parentDrawFocus is false for this class.
	parentDrawFocus = false;
	return (parentDrawFocus);
}

bool ZafPullDownItem::SetParentPalette(bool )
{
	// parentPalette is false for this class.
	parentPalette = false;
	return (parentPalette);
}

ZafRegionType ZafPullDownItem::SetRegionType(ZafRegionType )
{
	// regionType is ZAF_INSIDE_REGION for this class.
	regionType = ZAF_INSIDE_REGION;
	return (regionType);
}

bool ZafPullDownItem::SetSelected(bool )
{
	// selected is false for this class.
	selected = false;
	return (selected);
}

bool ZafPullDownItem::SetSelectOnDoubleClick(bool )
{
	// selectOnDoubleClick is false for this class.
	selectOnDoubleClick = false;
	return (selectOnDoubleClick);
}

bool ZafPullDownItem::SetSelectOnDownClick(bool )
{
	// selectOnDownClick is false for this class.
	selectOnDownClick = false;
	return (selectOnDownClick);
}

bool ZafPullDownItem::SetSendMessageWhenSelected(bool )
{
	// sendMessageWhenSelected is false for this class.
	sendMessageWhenSelected = false;
	return (sendMessageWhenSelected);
}

bool ZafPullDownItem::SetSupportObject(bool )
{
	// supportObject is false for this class.
	supportObject = false;
	return (supportObject);
}

ZafEventType ZafPullDownItem::SetValue(ZafEventType )
{
	// value is 0 for this class.
	value = 0;
	return (value);
}

ZafVtJustify ZafPullDownItem::SetVtJustify(ZafVtJustify )
{
	// vtJustify is ZAF_VT_CENTER for this class.
	vtJustify = ZAF_VT_CENTER;
	return (vtJustify);
}

// ----- Persistent functions -----------------------------------------------

ZafPullDownItem::ZafPullDownItem(const ZafIChar *name, ZafObjectPersistence &persist) :
	ZafButton(name, persist.PushLevel(className, classID, ZAF_PERSIST_DIRECTORY)),
	menu(0, 0)
{
	// Read the menu data.
	ZafIChar menuName[ZAF_MAXNAMELEN];
	ZafFile *file = persist.File();
	*file >> menuName;
	if (*menuName)
	{
		menu.SetStringID(menuName);
		persist.PushLevel(menu.ClassName(), menu.ClassID(), ZAF_PERSIST_DIRECTORY);
		persist.AllocateFile(menu.StringID());
		menu.ZafWindowObject::ReadData(persist);
		menu.ZafWindow::ReadData(persist);
		menu.ZafWindow::ReadChildren(persist);
		persist.PopLevel();
	}
	menu.parent = this;

	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

ZafElement *ZafPullDownItem::Read(const ZafIChar *name, ZafObjectPersistence &persist)
{
	return (new ZafPullDownItem(name, persist));
}

void ZafPullDownItem::Write(ZafObjectPersistence &persist)
{
	// Write the object.
	ZafButton::Write(persist.PushLevel(className, classID, ZAF_PERSIST_DIRECTORY));

	// Write the menu data.
	const ZafIChar *menuName = menu.First() ? menu.StringID() : ZAF_NULLP(ZafIChar);
	ZafFile *file = persist.File();
	*file << menuName;
	if (menu.First())
	{
		menu.Write(persist.PushLevel(menu.ClassName(), menu.ClassID(), ZAF_PERSIST_DIRECTORY));
		persist.PopLevel();
	}

	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

