//	Zinc Application Framework - Z_PALL.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_appall.hpp>

ZafDataPersistence::DataConstructor ZAF_FARDATA ZafDataPersistence::defaultDataConstructor[] =
{
	{ 0, ID_ZAF_BIGNUM_DATA, 		ZafBignumData::className, 		ZafBignumData::Read },
	{ 0, ID_ZAF_BITMAP_DATA, 		ZafBitmapData::className, 		ZafBitmapData::Read },
	{ 0, ID_ZAF_CODE_SET_DATA, 		ZafCodeSetData::className, 		ZafCodeSetData::Read },
	{ 0, ID_ZAF_DATE_DATA, 			ZafDateData::className, 		ZafDateData::Read },
	{ 0, ID_ZAF_ICON_DATA, 			ZafIconData::className, 		ZafIconData::Read },
	{ 0, ID_ZAF_INTEGER_DATA, 		ZafIntegerData::className, 		ZafIntegerData::Read },
	{ 0, ID_ZAF_LANGUAGE_DATA, 		ZafLanguageData::className, 	ZafLanguageData::Read },
	{ 0, ID_ZAF_LOCALE_DATA, 		ZafLocaleData::className, 		ZafLocaleData::Read },
	{ 0, ID_ZAF_MOUSE_DATA, 		ZafMouseData::className, 		ZafMouseData::Read },
	{ 0, ID_ZAF_REAL_DATA, 			ZafRealData::className, 		ZafRealData::Read },
	{ 0, ID_ZAF_SCROLL_DATA, 		ZafScrollData::className, 		ZafScrollData::Read },
	{ 0, ID_ZAF_STRING_DATA, 		ZafStringData::className, 		ZafStringData::Read },
	{ 0, ID_ZAF_TIME_DATA, 			ZafTimeData::className, 		ZafTimeData::Read },
	{ 0, ID_ZAF_UTIME_DATA, 		ZafUTimeData::className, 		ZafUTimeData::Read },
	// --- End-of-array ---
	{ 0, ID_END, 0, 0 }
};

ZafObjectPersistence::ObjectConstructor ZAF_FARDATA ZafObjectPersistence::defaultObjectConstructor[] =
{
	// --- Window objects ---
	{ 0, ID_ZAF_BIGNUM, 			ZafBignum::className, 			ZafBignum::Read },
	{ 0, ID_ZAF_BORDER, 			ZafBorder::className, 			ZafBorder::Read },
	{ 0, ID_ZAF_BUTTON, 			ZafButton::className, 			ZafButton::Read },
	{ 0, ID_ZAF_COMBO_BOX,			ZafComboBox::className,			ZafComboBox::Read },
	{ 0, ID_ZAF_DATE,				ZafDate::className,				ZafDate::Read },
	{ 0, ID_ZAF_FORMATTED_STRING,	ZafFormattedString::className,	ZafFormattedString::Read },
	{ 0, ID_ZAF_GROUP, 				ZafGroup::className, 			ZafGroup::Read },
	{ 0, ID_ZAF_HZ_LIST, 			ZafHzList::className, 			ZafHzList::Read },
	{ 0, ID_ZAF_ICON, 				ZafIcon::className, 			ZafIcon::Read },
	{ 0, ID_ZAF_IMAGE, 				ZafImage::className, 			ZafImage::Read },
	{ 0, ID_ZAF_INTEGER, 			ZafInteger::className, 			ZafInteger::Read },
	{ 0, ID_ZAF_MAXIMIZE_BUTTON, 	ZafMaximizeButton::className, 	ZafMaximizeButton::Read },
	{ 0, ID_ZAF_MINIMIZE_BUTTON, 	ZafMinimizeButton::className, 	ZafMinimizeButton::Read },
	{ 0, ID_ZAF_NOTEBOOK, 			ZafNotebook::className, 		ZafNotebook::Read },
	{ 0, ID_ZAF_POP_UP_ITEM, 		ZafPopUpItem::className, 		ZafPopUpItem::Read },
	{ 0, ID_ZAF_POP_UP_MENU, 		ZafPopUpMenu::className, 		ZafPopUpMenu::Read },
	{ 0, ID_ZAF_PROGRESS_BAR, 		ZafProgressBar::className, 		ZafProgressBar::Read },
	{ 0, ID_ZAF_PROMPT, 			ZafPrompt::className, 			ZafPrompt::Read },
	{ 0, ID_ZAF_PULL_DOWN_ITEM, 	ZafPullDownItem::className, 	ZafPullDownItem::Read },
	{ 0, ID_ZAF_PULL_DOWN_MENU, 	ZafPullDownMenu::className, 	ZafPullDownMenu::Read },
	{ 0, ID_ZAF_REAL, 				ZafReal::className, 			ZafReal::Read },
	{ 0, ID_ZAF_SCROLL_BAR, 		ZafScrollBar::className, 		ZafScrollBar::Read },
	{ 0, ID_ZAF_SPIN_CONTROL,		ZafSpinControl::className,		ZafSpinControl::Read },
	{ 0, ID_ZAF_STATUS_BAR, 		ZafStatusBar::className, 		ZafStatusBar::Read },
	{ 0, ID_ZAF_STRING, 			ZafString::className, 			ZafString::Read },
	{ 0, ID_ZAF_SYSTEM_BUTTON, 		ZafSystemButton::className, 	ZafSystemButton::Read },
	{ 0, ID_ZAF_TABLE, 				ZafTable::className, 			ZafTable::Read },
	{ 0, ID_ZAF_TABLE_HEADER, 		ZafTableHeader::className, 		ZafTableHeader::Read },
	{ 0, ID_ZAF_TABLE_RECORD, 		ZafTableRecord::className, 		ZafTableRecord::Read },
	{ 0, ID_ZAF_TEXT, 				ZafText::className, 			ZafText::Read },
	{ 0, ID_ZAF_TREE_ITEM, 			ZafTreeItem::className, 		ZafTreeItem::Read },
	{ 0, ID_ZAF_TREE_LIST, 			ZafTreeList::className, 		ZafTreeList::Read },
	{ 0, ID_ZAF_TIME, 				ZafTime::className, 			ZafTime::Read },
	{ 0, ID_ZAF_TITLE, 				ZafTitle::className, 			ZafTitle::Read },
	{ 0, ID_ZAF_TOOL_BAR, 			ZafToolBar::className, 			ZafToolBar::Read },
	{ 0, ID_ZAF_UTIME, 				ZafUTime::className, 			ZafUTime::Read },
	{ 0, ID_ZAF_VT_LIST, 			ZafVtList::className, 			ZafVtList::Read },
	{ 0, ID_ZAF_WINDOW, 			ZafWindow::className, 			ZafWindow::Read },
	// --- Dialog windows ---
	{ 0, ID_ZAF_DIALOG_WINDOW,		ZafDialogWindow::className,		ZafDialogWindow::Read },
	{ 0, ID_ZAF_MDI_WINDOW, 		ZafMDIWindow::className, 		ZafMDIWindow::Read },
	{ 0, ID_ZAF_MESSAGE_WINDOW, 	ZafMessageWindow::className, 	ZafMessageWindow::Read },
	{ 0, ID_ZAF_SCROLLED_WINDOW, 	ZafScrolledWindow::className, 	ZafScrolledWindow::Read },
	// --- Geometry management ---
	{ 0, ID_ZAF_GEOMETRY_MANAGER,	ZafGeometryManager::className,	ZafGeometryManager::Read },
	{ 0, ID_ZAF_ATTACHMENT,			ZafAttachment::className,		ZafAttachment::Read },
	{ 0, ID_ZAF_DIMENSION_CONSTRAINT, ZafDimensionConstraint::className, ZafDimensionConstraint::Read },
	{ 0, ID_ZAF_RELATIVE_CONSTRAINT, ZafRelativeConstraint::className, ZafRelativeConstraint::Read },
	// --- End-of-array ---
	{ 0, ID_END, 0, 0 }
};

