//	Zinc Application Framework - Z_MIN.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_min.hpp>
#include <z_app.hpp>
#define ZAF_MINIMIZE_BUTTON_INFO
#include "img_def.cpp"
#include "gbl_def.cpp"

ZafMinimizeButton *ZafWindow::MinimizeButton(void) const
{
	for (ZafWindowObject *object = SupportFirst(); object; object = object->Next())
		if (object->NumberID() == ZAF_NUMID_MINIMIZE)
			return (DynamicPtrCast(object, ZafMinimizeButton));
	return (ZAF_NULLP(ZafMinimizeButton));
}

// ----- ZafMinimizeButton --------------------------------------------------

static ZafStringIDChar ZAF_FARDATA _stringID[] = ZAF_ITEXT("ZAF_NUMID_MINIMIZE");

ZafMinimizeButton::ZafMinimizeButton(void) :
	ZafButton(0, 0, 0, 0, ZAF_NULLP(ZafIChar))
{
	// Check the image information.
	ImageAllocate();

	// Initialize the minimize button information.
	SetNumberID(ZAF_NUMID_MINIMIZE);
	SetStringID(_stringID);

	SetBordered(true);
	SetNoncurrent(true);
	SetSupportObject(true);
	SetSystemObject(false);
	SetRegionType(ZAF_AVAILABLE_REGION);

	SetAllowToggling(false);
	SetSendMessageWhenSelected(true);
	SetValue(S_MINIMIZE);
	SetButtonType(ZAF_3D_BUTTON);

	SetHzJustify(ZAF_HZ_CENTER);
	SetDepth(1);
}

ZafMinimizeButton::ZafMinimizeButton(const ZafMinimizeButton &copy) :
	ZafButton(copy)
{
	// Check the image information.
	ImageAllocate();
}

ZafMinimizeButton::~ZafMinimizeButton(void)
{
	// Check the image information.
	ImageFree();
}

ZafWindowObject *ZafMinimizeButton::Duplicate(void)
{
	return (new ZafMinimizeButton(*this));
}

void ZafMinimizeButton::ImageAllocate(void)
{
	// Initialize the images.
	if (!minBitmap)
	{
		ZafApplication::AddStaticModule(ImageFree);
		minBitmap = new ZafBitmapData(_min_ZafBitmap);
		minBitmap->staticHandle = true;
		minBitmap->SetDestroyable(false);
		minDepressedBitmap = new ZafBitmapData(_minDepressed_ZafBitmap);
		minDepressedBitmap->staticHandle = true;
		minDepressedBitmap->SetDestroyable(false);
	}
}

void ZafMinimizeButton::ImageFree(bool globalRequest)
{
	// Destroy the static images.
	if (globalRequest && minBitmap)
	{
		minBitmap->staticHandle = false;
		delete minBitmap;
		minBitmap = ZAF_NULLP(ZafBitmapData);
		minDepressedBitmap->staticHandle = false;
		delete minDepressedBitmap;
		minDepressedBitmap = ZAF_NULLP(ZafBitmapData);
	}
}

const ZafPaletteStruct *ZafMinimizeButton::MapClassPalette(ZafPaletteType type, ZafPaletteState state)
{
	const ZafPaletteStruct *palette = MapPalette(defaultPaletteMap, type, state);
	return (palette ? palette : ZafButton::MapClassPalette(type, state));
}

bool ZafMinimizeButton::SetAcceptDrop(bool )
{
	// acceptDrop is false for this class.
	acceptDrop = false;
	return (acceptDrop);
}

bool ZafMinimizeButton::SetAllowDefault(bool )
{
	// allowDefault is false for this class.
	allowDefault = false;
	return (allowDefault);
}

bool ZafMinimizeButton::SetAllowToggling(bool )
{
	// allowToggling is false for this class.
	allowToggling = false;
	return (allowToggling);
}

bool ZafMinimizeButton::SetAutoRepeatSelection(bool )
{
	// autoRepeatSelection is false for this class.
	autoRepeatSelection = false;
	return (autoRepeatSelection);
}

bool ZafMinimizeButton::SetAutoSize(bool )
{
	// autoSize is true for this class.
	autoSize = true;
	return (autoSize);
}

bool ZafMinimizeButton::SetBordered(bool )
{
	// bordered is false for this class.
	bordered = false;
	return (bordered);
}

ZafButtonType ZafMinimizeButton::SetButtonType(ZafButtonType )
{
	// buttonType is ZAF_3D_BUTTON for this class.
	buttonType = ZAF_3D_BUTTON;
	return (buttonType);
}

bool ZafMinimizeButton::SetCopyDraggable(bool )
{
	// copyDraggable is false for this class.
	copyDraggable = false;
	return (copyDraggable);
}

int ZafMinimizeButton::SetDepth(int )
{
	// depth is 1 for this class.
	depth = 1;
	return (depth);
}

bool ZafMinimizeButton::SetDisabled(bool )
{
	// disabled is false for this class.
	disabled = false;
	return (disabled);
}

bool ZafMinimizeButton::SetFocus(bool )
{
	// focus is false for this class.
	focus = false;
	return (focus);
}

const ZafIChar *ZafMinimizeButton::SetHelpContext(const ZafIChar *)
{
	// help context is empty for this class.
	return (ZAF_NULLP(ZafIChar));
}

const ZafIChar *ZafMinimizeButton::SetHelpObjectTip(const ZafIChar *)
{
	// helpObjectTip cannot be set for this class.
	return (ZAF_NULLP(ZafIChar));
}

ZafIChar ZafMinimizeButton::SetHotKey(ZafIChar , int )
{
	// hotKeyChar and hotKeyIndex are null for this class.
	hotKeyChar = 0;
	hotKeyIndex = -1;
	return (hotKeyChar);
}

ZafHzJustify ZafMinimizeButton::SetHzJustify(ZafHzJustify )
{
	// hzJustify is ZAF_HZ_CENTER for this class.
	hzJustify = ZAF_HZ_CENTER;
	return (hzJustify);
}

bool ZafMinimizeButton::SetLinkDraggable(bool )
{
	// linkDraggable is false for this class.
	linkDraggable = false;
	return (linkDraggable);
}

bool ZafMinimizeButton::SetMoveDraggable(bool )
{
	// moveDraggable is false for this class.
	moveDraggable = false;
	return (moveDraggable);
}

bool ZafMinimizeButton::SetNoncurrent(bool )
{
	// noncurrent is true for this class.
	noncurrent = true;
	return (noncurrent);
}

bool ZafMinimizeButton::SetParentDrawBorder(bool )
{
	// parentDrawBorder is false for this class.
	parentDrawBorder = false;
	return (parentDrawBorder);
}

bool ZafMinimizeButton::SetParentDrawFocus(bool )
{
	// parentDrawFocus is false for this class.
	parentDrawFocus = false;
	return (parentDrawFocus);
}

bool ZafMinimizeButton::SetParentPalette(bool )
{
	// parentPalette is false for this class.
	parentPalette = false;
	return (parentPalette);
}

const ZafIChar *ZafMinimizeButton::SetQuickTip(const ZafIChar *)
{
	// quickTip cannot be set for this class.
	return (ZAF_NULLP(ZafIChar));
}

ZafRegionType ZafMinimizeButton::SetRegionType(ZafRegionType )
{
	// regionType is ZAF_AVAILABLE_REGION for this class.
	regionType = ZAF_AVAILABLE_REGION;
	return (regionType);
}

bool ZafMinimizeButton::SetSelected(bool )
{
	// selected is false for this class.
	selected = false;
	return (selected);
}

bool ZafMinimizeButton::SetSelectOnDoubleClick(bool )
{
	// selectOnDoubleClick is false for this class.
	selectOnDoubleClick = false;
	return (selectOnDoubleClick);
}

bool ZafMinimizeButton::SetSelectOnDownClick(bool )
{
	// selectOnDownClick is false for this class.
	selectOnDownClick = false;
	return (selectOnDownClick);
}

bool ZafMinimizeButton::SetSendMessageWhenSelected(bool )
{
	// sendMessageWhenSelected is true for this class.
	sendMessageWhenSelected = true;
	memberUserFunction = (MemberUserFunction)&ZafButton::SendMessage;
	return (sendMessageWhenSelected);
}

ZafEventType ZafMinimizeButton::SetValue(ZafEventType setValue)
{
	// value is either S_MINIMIZE or S_RESTORE for this class.
	if (setValue == S_MINIMIZE || setValue == S_RESTORE)
		value = setValue;
	return (value);
}

bool ZafMinimizeButton::SetSupportObject(bool )
{
	// supportObject is true for this class.
	supportObject = true;
	return (supportObject);
}

ZafUserFunction ZafMinimizeButton::SetUserFunction(ZafUserFunction )
{
	// userFunction is null for this class.
	userFunction = ZAF_NULLF(ZafUserFunction);
	return (userFunction);
}

ZafVtJustify ZafMinimizeButton::SetVtJustify(ZafVtJustify )
{
	// vtJustify is ZAF_VT_CENTER for this class.
	vtJustify = ZAF_VT_CENTER;
	return (vtJustify);
}

// ----- Persistent functions -----------------------------------------------

ZafMinimizeButton::ZafMinimizeButton(const ZafIChar *, ZafObjectPersistence &) :
	ZafButton(0, 0, 0, 0, ZAF_NULLP(ZafStringData))
{
	// Check the image information.
	ImageAllocate();

	// Set the attributes.
	SetBordered(true);
	SetNoncurrent(true);
	SetHzJustify(ZAF_HZ_CENTER);
	SetSupportObject(true);
	SetSystemObject(false);
	SetRegionType(ZAF_AVAILABLE_REGION);
	SetAllowToggling(false);
	SetSendMessageWhenSelected(true);
	SetValue(S_MINIMIZE);
	SetNumberID(ZAF_NUMID_MINIMIZE);
	SetStringID(_stringID);
	SetDepth(1);
}

ZafElement *ZafMinimizeButton::Read(const ZafIChar *name, ZafObjectPersistence &persist)
{
	return (new ZafMinimizeButton(name, persist));
}

void ZafMinimizeButton::Write(ZafObjectPersistence &persist)
{
	// Register the read procedure.
	persist.AddObjectConstructor(ClassName(), ClassID(), ReadFunction());

	// Prepare the file.
	persist.PushLevel(ClassName(), ClassID(), ZAF_PERSIST_DIRECTORY);
	persist.AllocateFile(stringID);
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

