//	Zinc Application Framework - Z_MAX.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_max.hpp>
#include <z_app.hpp>
#define ZAF_MAXIMIZE_BUTTON_INFO
#include "img_def.cpp"
#include "gbl_def.cpp"

ZafMaximizeButton *ZafWindow::MaximizeButton(void) const
{
	for (ZafWindowObject *object = SupportFirst(); object; object = object->Next())
		if (object->NumberID() == ZAF_NUMID_MAXIMIZE)
			return (DynamicPtrCast(object, ZafMaximizeButton));
	return (ZAF_NULLP(ZafMaximizeButton));
}

// ----- ZafMaximizeButton --------------------------------------------------

static ZafStringIDChar ZAF_FARDATA _stringID[] = ZAF_ITEXT("ZAF_NUMID_MAXIMIZE");

ZafMaximizeButton::ZafMaximizeButton(void) :
	ZafButton(0, 0, 0, 0, ZAF_NULLP(ZafIChar))
{
	// Check the image information.
	ImageAllocate();

	// Initialize the maximize button information.
	SetNumberID(ZAF_NUMID_MAXIMIZE);
	SetStringID(_stringID);

	SetBordered(true);
	SetNoncurrent(true);
	SetSupportObject(true);
	SetSystemObject(false);
	SetRegionType(ZAF_AVAILABLE_REGION);

	SetAllowToggling(false);
	SetSendMessageWhenSelected(true);
	SetValue(S_MAXIMIZE);
	SetButtonType(ZAF_3D_BUTTON);

	SetHzJustify(ZAF_HZ_CENTER);
	SetDepth(1);
}

ZafMaximizeButton::ZafMaximizeButton(const ZafMaximizeButton &copy) :
	ZafButton(copy)
{
	// Check the image information.
	ImageAllocate();
}

ZafMaximizeButton::~ZafMaximizeButton(void)
{
	// Check the image information.
	ImageFree();
}

ZafWindowObject *ZafMaximizeButton::Duplicate(void)
{
	return (new ZafMaximizeButton(*this));
}

void ZafMaximizeButton::ImageAllocate(void)
{
	// Initialize the images.
	if (!maxBitmap)
	{
		ZafApplication::AddStaticModule(ImageFree);
		maxBitmap = new ZafBitmapData(_max_ZafBitmap);
		maxBitmap->staticHandle = true;
		maxBitmap->SetDestroyable(false);
		maxDepressedBitmap = new ZafBitmapData(_maxDepressed_ZafBitmap);
		maxDepressedBitmap->staticHandle = true;
		maxDepressedBitmap->SetDestroyable(false);
		maximizedBitmap = new ZafBitmapData(_maximized_ZafBitmap);
		maximizedBitmap->staticHandle = true;
		maximizedBitmap->SetDestroyable(false);
		maximizedDepressedBitmap = new ZafBitmapData(_maximizedDepressed_ZafBitmap);
		maximizedDepressedBitmap->staticHandle = true;
		maximizedDepressedBitmap->SetDestroyable(false);
	}
}

void ZafMaximizeButton::ImageFree(bool globalRequest)
{
	// Destroy the static images.
	if (globalRequest && maxBitmap)
	{
		maxBitmap->staticHandle = false;
		delete maxBitmap;
		maxBitmap = ZAF_NULLP(ZafBitmapData);
		maxDepressedBitmap->staticHandle = false;
		delete maxDepressedBitmap;
		maxDepressedBitmap = ZAF_NULLP(ZafBitmapData);
		maximizedBitmap->staticHandle = false;
		delete maximizedBitmap;
		maximizedBitmap = ZAF_NULLP(ZafBitmapData);
		maximizedDepressedBitmap->staticHandle = false;
		delete maximizedDepressedBitmap;
		maximizedDepressedBitmap = ZAF_NULLP(ZafBitmapData);
	}
}

const ZafPaletteStruct *ZafMaximizeButton::MapClassPalette(ZafPaletteType type, ZafPaletteState state)
{
	const ZafPaletteStruct *palette = MapPalette(defaultPaletteMap, type, state);
	return (palette ? palette : ZafButton::MapClassPalette(type, state));
}

bool ZafMaximizeButton::SetAcceptDrop(bool )
{
	// acceptDrop is false for this class.
	acceptDrop = false;
	return (acceptDrop);
}

bool ZafMaximizeButton::SetAllowDefault(bool )
{
	// allowDefault is false for this class.
	allowDefault = false;
	return (allowDefault);
}

bool ZafMaximizeButton::SetAllowToggling(bool )
{
	// allowToggling is false for this class.
	allowToggling = false;
	return (allowToggling);
}

bool ZafMaximizeButton::SetAutoRepeatSelection(bool )
{
	// autoRepeatSelection is false for this class.
	autoRepeatSelection = false;
	return (autoRepeatSelection);
}

bool ZafMaximizeButton::SetAutoSize(bool )
{
	// autoSize is true for this class.
	autoSize = true;
	return (autoSize);
}

bool ZafMaximizeButton::SetBordered(bool )
{
	// bordered is false for this class.
	bordered = false;
	return (bordered);
}

ZafButtonType ZafMaximizeButton::SetButtonType(ZafButtonType )
{
	// buttonType is ZAF_3D_BUTTON for this class.
	buttonType = ZAF_3D_BUTTON;
	return (buttonType);
}

bool ZafMaximizeButton::SetCopyDraggable(bool )
{
	// copyDraggable is false for this class.
	copyDraggable = false;
	return (copyDraggable);
}

int ZafMaximizeButton::SetDepth(int )
{
	// depth is 1 for this class.
	depth = 1;
	return (depth);
}

bool ZafMaximizeButton::SetDisabled(bool )
{
	// disabled is false for this class.
	disabled = false;
	return (disabled);
}

bool ZafMaximizeButton::SetFocus(bool )
{
	// focus is false for this class.
	focus = false;
	return (focus);
}

const ZafIChar *ZafMaximizeButton::SetHelpContext(const ZafIChar *)
{
	// help context is empty for this class.
	return (ZAF_NULLP(ZafIChar));
}

const ZafIChar *ZafMaximizeButton::SetHelpObjectTip(const ZafIChar *)
{
	// helpObjectTip cannot be set for this class.
	return (ZAF_NULLP(ZafIChar));
}

ZafIChar ZafMaximizeButton::SetHotKey(ZafIChar , int )
{
	// hotKeyChar and hotKeyIndex are null for this class.
	hotKeyChar = 0;
	hotKeyIndex = -1;
	return (hotKeyChar);
}

ZafHzJustify ZafMaximizeButton::SetHzJustify(ZafHzJustify )
{
	// hzJustify is ZAF_HZ_CENTER for this class.
	hzJustify = ZAF_HZ_CENTER;
	return (hzJustify);
}

bool ZafMaximizeButton::SetLinkDraggable(bool )
{
	// linkDraggable is false for this class.
	linkDraggable = false;
	return (linkDraggable);
}

bool ZafMaximizeButton::SetMoveDraggable(bool )
{
	// moveDraggable is false for this class.
	moveDraggable = false;
	return (moveDraggable);
}

bool ZafMaximizeButton::SetNoncurrent(bool )
{
	// noncurrent is true for this class.
	noncurrent = true;
	return (noncurrent);
}

bool ZafMaximizeButton::SetParentDrawBorder(bool )
{
	// parentDrawBorder is false for this class.
	parentDrawBorder = false;
	return (parentDrawBorder);
}

bool ZafMaximizeButton::SetParentDrawFocus(bool )
{
	// parentDrawFocus is false for this class.
	parentDrawFocus = false;
	return (parentDrawFocus);
}

bool ZafMaximizeButton::SetParentPalette(bool )
{
	// parentPalette is false for this class.
	parentPalette = false;
	return (parentPalette);
}

const ZafIChar *ZafMaximizeButton::SetQuickTip(const ZafIChar *)
{
	// quickTip cannot be set for this class.
	return (ZAF_NULLP(ZafIChar));
}

ZafRegionType ZafMaximizeButton::SetRegionType(ZafRegionType )
{
	// regionType is ZAF_AVAILABLE_REGION for this class.
	regionType = ZAF_AVAILABLE_REGION;
	return (regionType);
}

bool ZafMaximizeButton::SetSelected(bool )
{
	// selected is false for this class.
	selected = false;
	return (selected);
}

bool ZafMaximizeButton::SetSelectOnDoubleClick(bool )
{
	// selectOnDoubleClick is false for this class.
	selectOnDoubleClick = false;
	return (selectOnDoubleClick);
}

bool ZafMaximizeButton::SetSelectOnDownClick(bool )
{
	// selectOnDownClick is false for this class.
	selectOnDownClick = false;
	return (selectOnDownClick);
}

bool ZafMaximizeButton::SetSendMessageWhenSelected(bool )
{
	// sendMessageWhenSelected is true for this class.
	sendMessageWhenSelected = true;
	memberUserFunction = (MemberUserFunction)&ZafButton::SendMessage;
	return (sendMessageWhenSelected);
}

bool ZafMaximizeButton::SetSupportObject(bool )
{
	// supportObject is true for this class.
	supportObject = true;
	return (supportObject);
}

ZafUserFunction ZafMaximizeButton::SetUserFunction(ZafUserFunction )
{
	// userFunction is null for this class.
	userFunction = ZAF_NULLF(ZafUserFunction);
	return (userFunction);
}

ZafEventType ZafMaximizeButton::SetValue(ZafEventType setValue)
{
	// value is either S_MAXIMIZE or S_RESTORE for this class.
	if (setValue == S_MAXIMIZE || setValue == S_RESTORE)
		value = setValue;
	return (value);
}

ZafVtJustify ZafMaximizeButton::SetVtJustify(ZafVtJustify )
{
	// vtJustify is ZAF_VT_CENTER for this class.
	vtJustify = ZAF_VT_CENTER;
	return (vtJustify);
}

// ----- Persistent functions -----------------------------------------------

ZafMaximizeButton::ZafMaximizeButton(const ZafIChar *, ZafObjectPersistence &) :
	ZafButton(0, 0, 0, 0, ZAF_NULLP(ZafStringData))
{
	// Check the image information.
	ImageAllocate();

	// Set the attributes.
	SetBordered(true);
	SetNoncurrent(true);
	SetHzJustify(ZAF_HZ_CENTER);
	SetSupportObject(true);
	SetSystemObject(false);
	SetRegionType(ZAF_AVAILABLE_REGION);
	SetAllowToggling(false);
	SetSendMessageWhenSelected(true);
	SetValue(S_MAXIMIZE);
	SetNumberID(ZAF_NUMID_MAXIMIZE);
	SetStringID(_stringID);
	SetDepth(1);
}

ZafElement *ZafMaximizeButton::Read(const ZafIChar *name, ZafObjectPersistence &persist)
{
	return (new ZafMaximizeButton(name, persist));
}

void ZafMaximizeButton::Write(ZafObjectPersistence &persist)
{
	// Register the read procedure.
	persist.AddObjectConstructor(ClassName(), ClassID(), ReadFunction());

	// Prepare the file.
	persist.PushLevel(ClassName(), ClassID(), ZAF_PERSIST_DIRECTORY);
	persist.AllocateFile(stringID);
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

