//	Zinc Application Framework - Z_IDATA.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_idata.hpp>
#include <z_string.hpp>
#define ZAF_IMAGE_DATA_INFO
#include "gbl_def.cpp"

// ----- ZafImageData -------------------------------------------------------

ZafImageData::ZafImageData(void) :
	ZafData()
{
}

ZafImageData::ZafImageData(const ZafImageData &copy) :
	ZafData(copy)
{
}

ZafImageData::~ZafImageData(void)
{
}

ZafError ZafImageData::InitializeImage(ZafImageStruct &image)
{
	// Initialize the image information.
	image.staticArray = false;
	image.width = image.height = 0;
	image.array = ZAF_NULLP(ZafLogicalColor);

	// Return success.
	return (ZAF_ERROR_NONE);
}

ZafError ZafImageData::SetImage(ZafImageStruct &image,
	const ZafImageStruct &copy)
{
	// Initialize the image information.
	image.width = copy.width;
	image.height = copy.height;

	image.staticArray = copy.staticArray;
	if (image.staticArray)
		image.array = copy.array;
	else if (image.array != copy.array)
	{
		if (image.array)
			delete []image.array;
		image.array = new ZafLogicalColor[image.width * image.height];
		memcpy(image.array, copy.array, image.width * image.height);
	}

	// Return success.
	return (ZAF_ERROR_NONE);
}

ZafError ZafImageData::SetImage(ZafImageStruct &image, int tWidth,
	int tHeight, ZafLogicalColor *tArray)
{
	// Reset the icon information.
	image.width = tWidth;
	image.height = tHeight;

	if (image.staticArray && tArray)
		image.array = tArray;
	else if (tArray != image.array)
	{
		if (image.array)
			delete []image.array;
		image.array = new ZafLogicalColor[image.width * image.height];
		memcpy(image.array, tArray, image.width * image.height);
	}

	// Return success.
	return (ZAF_ERROR_NONE);
}

// ----- Persistent functions -----------------------------------------------

ZafImageData::ZafImageData(const ZafIChar *name, ZafDataPersistence &persist):
	ZafData(name, persist.PushLevel(className, classID, ZAF_PERSIST_FILE))
{
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

void ZafImageData::Write(ZafDataPersistence &persist)
{
	// Write the object.
	ZafData::Write(persist.PushLevel(className, classID, ZAF_PERSIST_FILE));
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

