//	Zinc Application Framework - Z_FILDLG.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_app.hpp>
#include <z_fildlg.hpp>
#include <z_string.hpp>
#define ZAF_FILE_DIALOG_INFO
#include "lang_def.cpp"
#include "gbl_def.cpp"

// ----- ZafFileDialog ------------------------------------------------------

ZafFileDialog::ZafFileDialog(const ZafFileDialog &copy) :
	ZafDialogWindow(copy)
{
	// Check the language and local information.
	LanguageAllocate();

	// Initialize the file dialog information.
	directory[0] = file[0] = filter[0] = 0;
	SetDirectory(copy.directory);
	SetFile(copy.file);
	SetFilter(copy.filter);
}

ZafFileDialog::~ZafFileDialog(void)
{
	// Check the language information.
	LanguageFree();
}

void ZafFileDialog::FullPath(ZafIChar *pathBuffer, int bufferSize)
{
	int bufferIndex = 0;

	// Copy directory string.
	strncpy(&pathBuffer[bufferIndex], directory, bufferSize - bufferIndex);
	bufferIndex += strlen(directory);

	// Append a directory separator character if neccessary.
	if (pathBuffer[bufferIndex - 1] != zafCodeSet->dirSepStr[0])
	{
		strncpy(&pathBuffer[bufferIndex], zafCodeSet->dirSepStr, bufferSize - bufferIndex);
		bufferIndex++;
	}

	// Append the file name.
	strncpy(&pathBuffer[bufferIndex], file, bufferSize - bufferIndex);
}

void ZafFileDialog::LanguageAllocate(void)
{
	// Check for initialization.
	if (language)
		return;
	ZafApplication::AddStaticModule(LanguageFree);

	// Try the zafDataManager.
	if (!language && zafDataManager)
		language = DynamicPtrCast(zafDataManager->AllocateData(className, ZafLanguageData::className, ZafLanguageData::classID), ZafLanguageData);

	// Default to code initialization.
	if (!language)
		language = new ZafLanguageData(defaultFileStrings, true);
}

void ZafFileDialog::LanguageFree(bool globalRequest)
{
	// Destroy the static language.
	if (globalRequest && language && language->Destroyable() &&
		language->NotifyCount() == 0)
	{
		delete language;
		language = ZAF_NULLP(ZafLanguageData);
	}
}

void ZafFileDialog::SetDirectory(const ZafIChar *setDirectory)
{
	strncpy(directory, setDirectory, ZAF_MAXPATHLEN);
}

void ZafFileDialog::SetFile(const ZafIChar *setFile)
{
	strncpy(file, setFile, ZAF_MAXPATHLEN);
}

void ZafFileDialog::SetFilter(const ZafIChar *setFilter)
{
	strncpy(filter, setFilter, ZAF_MAXPATHLEN);
}

