//	Zinc Application Framework - Z_FDATA.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_fdata.hpp>
#include <z_app.hpp>
#include <z_stdio.hpp>
#include <z_string.hpp>
#define ZAF_FORMAT_DATA_INFO
#include "gbl_def.cpp"

// ----- ZafFormatData ------------------------------------------------------

ZafFormatData::ZafFormatData(void) :
	ZafData()
{
}

ZafFormatData::ZafFormatData(const ZafFormatData &copy) :
	ZafData(copy)
{
}

ZafFormatData::~ZafFormatData(void)
{
}

// ----- Printf functions ---------------------------------------------------

const ZafIChar *ZafFormatData::ParseFormat(ZafIChar *format, const ZafIChar *formatArray) const
{
	// Check the format.
	if (!formatArray || !formatArray[0])
	{
		format[0] = 0;
		return (ZAF_NULLP(ZafIChar));
	}

	// Parse the format.
	int offset = 0;
	for ( ; formatArray[offset] != '\0' && formatArray[offset] != '\n'; offset++)
		format[offset] = formatArray[offset];
	format[offset] = '\0';

	// Return the offset position.
	return (formatArray[offset] ? &formatArray[++offset] : ZAF_NULLP(ZafIChar));
}

int ZafFormatData::Sprintf(ZafIChar *buffer, int maxLength, const ZafIChar *format) const
{
	// Get the output format, defined as the first format in the buffer.
	ZafIChar oFormat[ZAF_FORMAT_LENGTH];
	ParseFormat(oFormat, format);

	int count;
	ZafIChar *tmpFormat = new ZafIChar[strlen(oFormat)+2];
	strcpy(tmpFormat, oFormat);
	ZafIChar *percent = strchr(tmpFormat, '%');
	if (percent)
	{
		percent++;
		memmove(percent+1, percent, (strlen(percent)+1)*sizeof(*percent));
		*percent = 'Z';
		count = sprintf(buffer, tmpFormat, this);
	}
	else
	{
		count = strlen(oFormat);
		strcpy(buffer, oFormat);
	}
	delete []tmpFormat;

	// Determine the error status based on maxLength.
	return ((count > maxLength) ? 0 : count);
}

int ZafFormatData::Sscanf(const ZafIChar *buffer, const ZafIChar *format)
{
	int count = 0;
	ZafIChar iFormat[ZAF_FORMAT_LENGTH];
	format = ParseFormat(iFormat, format);
	while (!count && *iFormat)
	{
		ZafIChar *tmpFormat = new ZafIChar[strlen(iFormat)+2];
		strcpy(tmpFormat, iFormat);

		ZafIChar *percent = strchr(tmpFormat, '%');
		if (percent)
		{
			percent++;
			memmove(percent+1, percent, (strlen(percent)+1)*sizeof(*percent));
			*percent = 'Z';
			count = sscanf(buffer, tmpFormat, this);
		}
		delete []tmpFormat;

		if (!count)
			format = ParseFormat(iFormat, format);
	}
	return (count);
}

// ----- Persistent functions -----------------------------------------------

ZafFormatData::ZafFormatData(const ZafIChar *name, ZafDataPersistence &persist):
	ZafData(name, persist.PushLevel(className, classID, ZAF_PERSIST_FILE))
{
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

void ZafFormatData::Write(ZafDataPersistence &persist)
{
	// Write the object.
	ZafData::Write(persist.PushLevel(className, classID, ZAF_PERSIST_FILE));
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

