//	Zinc Application Framework - Z_ERROR1.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_error.hpp>
#include <z_stdarg.hpp>
#include <z_app.hpp>
#define ZAF_ERROR_SYSTEM_INFO
#include "lang_def.cpp"
#include "gbl_def.cpp"

// ----- ZafErrorSystem -----------------------------------------------------

ZafErrorSystem::ZafErrorSystem(void) :
	ZafErrorStub()
{
	// Initialize the global variable.
	if (!zafErrorSystem)
		zafErrorSystem = this;

	// Check the language and local information.
	LanguageAllocate();
}

ZafErrorSystem::~ZafErrorSystem(void)
{
	// Check the language and local information.
	LanguageFree();
}

void ZafErrorSystem::LanguageAllocate(void)
{
	// Check for initialization.
	if (language)
		return;
	ZafApplication::AddStaticModule(LanguageFree);

	// Try the zafDataManager.
	if (!language && zafDataManager)
		language = DynamicPtrCast(zafDataManager->AllocateData(className, ZafLanguageData::className, ZafLanguageData::classID), ZafLanguageData);

	// Default to code initialization.
	if (!language)
		language = new ZafLanguageData(defaultErrorStrings, true);
}

void ZafErrorSystem::LanguageFree(bool globalRequest)
{
	// Destroy the static language.
	if (globalRequest && language && language->Destroyable() &&
		language->NotifyCount() == 0)
	{
		delete language;
		language = ZAF_NULLP(ZafLanguageData);
	}
}

