//	Zinc Application Framework - Z_DLGWIN.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_dlgwin.hpp>

#if defined(ZAF_LOCAL_FILE_STATICS)
#define ZAF_DIALOG_WINDOW_INFO
#include "gbl_def.cpp"
#else
#include <z_dlgall.hpp>
#define ZAF_LOCAL_FILE_STATICS
#define ZAF_DIALOG_WINDOW_INFO
#define ZAF_ERROR_STUB_INFO
#define ZAF_ERROR_SYSTEM_INFO
#define ZAF_FILE_DIALOG_INFO
#define ZAF_HELP_STUB_INFO
#define ZAF_HELP_SYSTEM_INFO
#define ZAF_MDI_WINDOW_INFO
#define ZAF_MESSAGE_WINDOW_INFO
#define ZAF_SCROLLED_WINDOW_INFO
#include "gbl_def.cpp"
#endif

// ----- ZafDialogWindow ----------------------------------------------------

ZafDialogWindow::ZafDialogWindow(int left, int top, int width, int height) :
	ZafWindow(left, top, width, height), modal(true)
{
	SetDestroyable(false);
}

ZafDialogWindow::ZafDialogWindow(const ZafDialogWindow &copy) :
	ZafWindow(copy), modal(copy.modal)
{
}

ZafDialogWindow::~ZafDialogWindow(void)
{
}

ZafEventType ZafDialogWindow::Control(void)
{
	// Add the object to the window manager.
	zafWindowManager->Add(this);

	// Wait for user response.
	ZafEventType ccode = S_NO_OBJECT;
	ZafEventStruct event;
	do
	{
		eventManager->Get(event);
		if (event.type >= S_DIALOG_FIRST && event.type <= S_DIALOG_LAST)
			ccode = Event(event);
		else
			windowManager->Event(event);
	} while (screenID && ccode == S_NO_OBJECT);

	// Remove the object from the window manager.
	zafWindowManager->Subtract(this);

	// Return the control code.
	return (ccode);
}

ZafEventType ZafDialogWindow::Event(const ZafEventStruct &event)
{
	// Check for zinc events.
	ZafEventType ccode = event.type;
	switch (ccode)
	{
	case S_DLG_OK:
	case S_DLG_YES:
	case S_DLG_NO:
	case S_DLG_ABORT:
	case S_DLG_RETRY:
	case S_DLG_IGNORE:
	case S_DLG_CANCEL:
	case S_DLG_HELP:
		break;

	default:
		ccode = ZafWindow::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}

bool ZafDialogWindow::SetAcceptDrop(bool )
{
	// acceptDrop is false for this class.
	acceptDrop = false;
	return (acceptDrop);
}

bool ZafDialogWindow::SetBordered(bool )
{
	// bordered is false for this class.
	bordered = false;
	return (bordered);
}

bool ZafDialogWindow::SetDisabled(bool )
{
	// disabled is false for this class.
	disabled = false;
	return (disabled);
}

bool ZafDialogWindow::SetModal(bool tModal)
{
	// Make sure the attribute has changed.
	if (modal != tModal && !screenID)
		modal = tModal;

	// Return the current attribute.
	return modal;
}

bool ZafDialogWindow::SetNoncurrent(bool )
{
	// noncurrent is false for this class.
	noncurrent = false;
	return (noncurrent);
}

bool ZafDialogWindow::SetParentPalette(bool )
{
	// parentPalette is false for this class.
	parentPalette = false;
	return (parentPalette);
}

ZafRegionType ZafDialogWindow::SetRegionType(ZafRegionType )
{
	// regionType is ZAF_INSIDE_REGION for this class.
	regionType = ZAF_INSIDE_REGION;
	return (regionType);
}

bool ZafDialogWindow::SetSizeable(bool )
{
	// sizeable is false for this class.
	sizeable = false;
	return (sizeable);
}

bool ZafDialogWindow::SetTemporary(bool )
{
	// temporary is false for this class.
	temporary = false;
	return (temporary);
}

// ----- Persistent functions -----------------------------------------------

ZafDialogWindow::ZafDialogWindow(const ZafIChar *name, ZafObjectPersistence &persist) :
	ZafWindow(name, persist.PushLevel(className, classID, ZAF_PERSIST_ROOT_DIRECTORY))
{
	// Read the data.
	ZafDialogWindow::ReadData(persist);
	persist.PopLevel();

	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

ZafElement *ZafDialogWindow::Read(const ZafIChar *name, ZafObjectPersistence &persist)
{
	return (new ZafDialogWindow(name, persist));
}

void ZafDialogWindow::ReadData(ZafObjectPersistence &persist)
{
	// Read the data.
	ZafUInt16 flag1;
	ZafFile *file = persist.File();
	*file >> flag1;
	modal = (flag1 & 0x0001) ? true : false;
}

void ZafDialogWindow::Write(ZafObjectPersistence &persist)
{
	// Write the object.
	ZafWindow::Write(persist.PushLevel(className, classID, ZAF_PERSIST_ROOT_DIRECTORY));
	ZafDialogWindow::WriteData(persist);
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

void ZafDialogWindow::WriteData(ZafObjectPersistence &persist)
{
	// Write the data.
	ZafUInt16 flag1 = 0;
	ZafFile *file = persist.File();
	flag1 |= modal ? 0x0001 : 0;
	*file << flag1;
}

