//	Zinc Application Framework - Z_DEVICE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_device.hpp>
#include <z_evtmgr.hpp>
#define ZAF_DEVICE_INFO
#include "gbl_def.cpp"

// ----- ZafDevice ----------------------------------------------------------

ZafDevice::ZafDevice(ZafDeviceType tDeviceType,
	ZafDeviceState tDeviceState) :
	installed(false), deviceType(tDeviceType), deviceState(tDeviceState)
{
}

ZafDevice::~ZafDevice(void)
{
}

int ZafDevice::CompareDevices(void *device1, void *device2)
{
	return ((int)(((ZafDevice *)device1)->deviceType - ((ZafDevice *)device2)->deviceType));
}

ZafDeviceState ZafDevice::SetDeviceState(ZafDeviceState tDeviceState)
{
	deviceState = tDeviceState;
	return (deviceState);
}

