//	Zinc Application Framework - Z_DATA2.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_data.hpp>
#include <z_utils.hpp>

#if defined(ZAF_LOCAL_FILE_STATICS)
#define ZAF_DATA_INFO
#include "gbl_def.cpp"
#else
#include <z_datall.hpp>
#define ZAF_LOCAL_FILE_STATICS
#define ZAF_BIGNUM_DATA_INFO
#define ZAF_BITMAP_DATA_INFO
#define ZAF_CODE_SET_INFO
#define ZAF_DATA_INFO
#define ZAF_DATE_DATA_INFO
#define ZAF_FORMAT_DATA_INFO
#define ZAF_ICON_DATA_INFO
#define ZAF_IMAGE_DATA_INFO
#define ZAF_INTEGER_DATA_INFO
#define ZAF_I18N_DATA_INFO
#define ZAF_LANGUAGE_DATA_INFO
#define ZAF_LOCALE_DATA_INFO
#define ZAF_MOUSE_DATA_INFO
#define ZAF_PALETTE_DATA_INFO
#define ZAF_REAL_DATA_INFO
#define ZAF_SCROLL_DATA_INFO
#define ZAF_STRING_DATA_INFO
#define ZAF_TIME_DATA_INFO
#define ZAF_UTIME_DATA_INFO
#include "gbl_def.cpp"
#endif

// ----- ZafDataManager -----------------------------------------------------

ZafDataManager::ZafDataManager(void)
{
}

ZafDataManager::~ZafDataManager(void)
{
}

ZafData *ZafDataManager::AllocateData(const ZafIChar *matchID, ZafClassName , ZafClassID matchClassID)
{
	// Try to find a matching entry.
	ZafData *data = GetObject(matchID);

	// Try persistence construction.
	if (!data && zafDataPersistence)
	{
		ZafDataConstructor constructor = zafDataPersistence->GetDataConstructor(matchClassID);
		if (constructor)
		{
			ZafData *newData = (ZafData *)(constructor)(matchID, *zafDataPersistence);
			if (newData->Error())
				delete newData;
			else
			{
				data = Add(newData);
				data->AddNotification(this);
			}
		}
	}

	// Return the object.
	return (data);
}

