//	Zinc Application Framework - Z_DATA1.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_data.hpp>
#include <z_utils.hpp>

// ----- ZafDataRecord ------------------------------------------------------

ZafDataRecord::ZafDataRecord(void)
{
}

ZafDataRecord::~ZafDataRecord(void)
{
}

ZafData *ZafDataRecord::Add(ZafData *object, ZafData *position)
{
	// Check for a null.
	if (!object)
		return (ZAF_NULLP(ZafData));
	else if (position)
		ZafList::Add(object, position);	// position insert.
	else
		ZafList::Add(object);			// compareFunction insert.
	return (object);
}

void ZafDataRecord::Clear(void)
{
}

void ZafDataRecord::Destroy(void)
{
	// Destroy the list elements (low level).
	ZafList::Destroy();
}

ZafData *ZafDataRecord::Duplicate(void)
{
	return (new ZafDataRecord(*this));
}

ZafData *ZafDataRecord::GetObject(ZafNumberID matchID)
{
	// Try to find a matching entry.
	ZafData *match = ZAF_NULLP(ZafData);
	for (ZafData *object = First(); object; object = object->Next())
		if ((match = object->GetObject(matchID)) != ZAF_NULLP(ZafData))
		{
			object->AddNotification(this);
			break;
		}

	// Return the object.
	return (match);
}

ZafData *ZafDataRecord::GetObject(const ZafIChar *matchID)
{
	// Try to find a matching entry.
	ZafData *match = ZAF_NULLP(ZafData);
	for (ZafData *object = First(); object; object = object->Next())
		if ((match = object->GetObject(matchID)) != ZAF_NULLP(ZafData))
		{
			object->AddNotification(this);
			break;
		}

	// Return the object.
	return (match);
}

ZafData *ZafDataRecord::Subtract(ZafData *object)
{
	// Check for a null.
	if (!object)
		return (ZAF_NULLP(ZafData));
	return ((ZafData *)ZafList::Subtract(object));
}

// ----- Persistent functions -----------------------------------------------

ZafDataRecord::ZafDataRecord(const ZafIChar *name, ZafDataPersistence &persist) :
	ZafData(name, persist.PushLevel(className, classID, ZAF_PERSIST_FILE))
{
}

ZafElement *ZafDataRecord::Read(const ZafIChar *name, ZafDataPersistence &persist)
{
	return (new ZafDataRecord(name, persist));
}

void ZafDataRecord::Write(ZafDataPersistence &persist)
{
	// Write the object.
	ZafData::Write(persist.PushLevel(className, classID, ZAF_PERSIST_FILE));
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

