//	Zinc Application Framework - Z_DATA.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_data.hpp>
#include <z_utils.hpp>

// ----- ZafData ------------------------------------------------------------

ZafData::ZafData(void) :
	ZafNotification(), error(ZAF_ERROR_NONE), level(0), destroyable(true)
{
}

ZafData::ZafData(const ZafData &) :
	ZafNotification(), error(ZAF_ERROR_NONE), level(0), destroyable(true)
{
	// Copy constructor does not set any values from the original copy.
	// New notifications and useCounts must be re-established.
}

ZafData::~ZafData(void)
{
}

ZafData *ZafData::GetObject(ZafNumberID matchID)
{
	return ((matchID == numberID) ? this : ZAF_NULLP(ZafData));
}

ZafData *ZafData::GetObject(const ZafIChar *matchID)
{
	return (streq(stringID, matchID) ? ZAF_NULLP(ZafData) : this);
}

int ZafData::PopLevel(bool levelNotify)
{
	// Decrement the level count.
	if (--level == 0 && levelNotify)
		UpdateObjects();
	return (level);
}

int ZafData::PushLevel(void)
{
	// Increment the level count.
	return (++level);
}

ZafError ZafData::SetError(ZafError setError)
{
	// Make sure the attribute has changed.
	if (error != setError)
		error = setError;

	// Return the current attribute.
	return (error);
}

// ----- Persistent functions -----------------------------------------------

ZafData::ZafData(const ZafIChar *name, ZafDataPersistence &persist) :
	ZafNotification(), error(ZAF_ERROR_NONE), level(0), destroyable(true)
{
	// Set the string identification.
	if (name)
		SetStringID(name);

	// Prepare the file.
	persist.AllocateFile(stringID);
}

void ZafData::Write(ZafDataPersistence &persist)
{
	// Register the read procedure.
	persist.AddDataConstructor(ClassID(), ClassName(), ReadFunction());

	// Prepare the file.
	persist.AllocateFile(stringID);
}

