//	Zinc Application Framework - Z_CTYPE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_env.hpp>
#include <z_ctype.hpp>

#if defined(ZAF_UNICODE)
#	include "u_ctype.cpp"
#elif defined(ZAF_ISO8859_1)

// These are the ANSI C ctype.h equivalents for ISO 8859-1.

int IsAscii(ZafIChar c)
{
	return ((unsigned int)c <= (unsigned int)0x7f);
}

int IsCntrl(ZafIChar c)
{
	// This form stops the warnings when compiling with ZafIChar
	// as an unsigned short.
	return ((c >= (ZafIChar)0x01 && c <= (ZafIChar)0x1f) ||
		(c >= (ZafIChar)0x7f && c <= (ZafIChar)0x9f) ||
		(c == (ZafIChar)0x00));
}

int IsDigit(ZafIChar c)
{
	return (c >= '0' && c <= '9');
}

int IsGraph(ZafIChar c)
{
	return ((c >= '!' && c <= '~') ||
		(c >= (ZafIChar)0xa0 && c <= (ZafIChar)0xff));
}

int IsPrint(ZafIChar c)
{
	return ((c >= ' ' && c <= '~') ||
		(c >= (ZafIChar)0xa0) && c <= (ZafIChar)0xff);
}

int IsSpace(ZafIChar c)
{
	return (c == ' ' || ('\t' <= c && c <= '\r') || c == (ZafIChar)0xa0);
}

int IsXDigit(ZafIChar c)
{
	return ((c >= '0' && c <= '9') ||
		(c >= 'a' && c <= 'f') ||
		(c >= 'A' && c <= 'F'));
}

int IsLower(ZafIChar c)
{
	return ((c >= 'a' && c <= 'z') ||
		(c >= (ZafIChar)0xdf && c <= (ZafIChar)0xf6) ||
		(c >= (ZafIChar)0xf8 && c <= (ZafIChar)0xff));
}

int IsUpper(ZafIChar c)
{
	return ((c >= 'A' && c <= 'Z') ||
		(c >= (ZafIChar)0xc0 && c <= (ZafIChar)0xd6) ||
		(c >= (ZafIChar)0xd8 && c <= (ZafIChar)0xde));
}

ZafIChar ToLower(ZafIChar c)
{
	if (c >= 'A' && c <= 'Z')
		return ((ZafIChar)(c + 0x20));
	if (c >= (ZafIChar)0xc0 && c <= (ZafIChar)0xd6)
		return ((ZafIChar)(c + 0x20));
	if (c >= (ZafIChar)0xd8 && c <= (ZafIChar)0xde)
		return ((ZafIChar)(c + 0x20));
	return (c);
}

ZafIChar ToUpper(ZafIChar c)
{
	if (c >= 'a' && c <= 'z')
		return ((ZafIChar)(c - 0x20));
	if (c >= (ZafIChar)0xe0 && c <= (ZafIChar)0xf6)
		return ((ZafIChar)(c - 0x20));
	if (c >= (ZafIChar)0xf8 && c <= (ZafIChar)0xfe)
		return ((ZafIChar)(c - 0x20));
	return (c);
}

int IsAlnum(ZafIChar c)
{
	return ((c >= '0' && c <= '9') ||
		(c >= 'a' && c <= 'z') ||
		(c >= 'A' && c <= 'Z') ||
		(c >= (ZafIChar)0xc0 && c <= (ZafIChar)0xd6) ||
		(c >= (ZafIChar)0xd8 && c <= (ZafIChar)0xf6) ||
		(c >= (ZafIChar)0xf8 && c <= (ZafIChar)0xff));
}

int IsAlpha(ZafIChar c)
{
	return ((c >= 'a' && c <= 'z') ||
		(c >= 'A' && c <= 'Z') ||
		(c >= (ZafIChar)0xc0 && c <= (ZafIChar)0xd6) ||
		(c >= (ZafIChar)0xd8 && c <= (ZafIChar)0xf6) ||
		(c >= (ZafIChar)0xf8 && c <= (ZafIChar)0xff));
}

int IsPunct(ZafIChar c)
{
	return ((c >= '!' && c <= '/') ||
		(c >= ':' && c <= '?') ||
		(c >= '[' && c <= '`') ||
		(c >= '{' && c <= '~') ||
		(c >= (ZafIChar)0xa1 && c <= (ZafIChar)0xbf) ||
		(c == (ZafIChar)0xd7 || c == (ZafIChar)0xf7));
}

int IsNonspacing(ZafIChar)
{
	return false;
}

#else
	// We use the compiler's library for OEM characters
#endif

