//	Zinc Application Framework - Z_BORDER.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_border.hpp>
#define ZAF_BORDER_INFO
#include "gbl_def.cpp"

ZafBorder *ZafWindow::Border(void) const
{
	for (ZafWindowObject *object = SupportFirst(); object; object = object->Next())
		if (object->NumberID() == ZAF_NUMID_BORDER)
			return (DynamicPtrCast(object, ZafBorder));
	return (ZAF_NULLP(ZafBorder));
}

// ----- ZafBorder ----------------------------------------------------------

static ZafStringIDChar ZAF_FARDATA _stringID[] = ZAF_ITEXT("ZAF_NUMID_BORDER");

ZafBorder::ZafBorder(void) :
	ZafWindowObject(0, 0, 0, 0)
{
	// Initialize the border information.
	SetSupportObject(true);
	SetSystemObject(false);
	SetRegionType(ZAF_OUTSIDE_REGION);
	SetNoncurrent(true);
	SetNumberID(ZAF_NUMID_BORDER);
	SetStringID(_stringID);
}

ZafBorder::ZafBorder(const ZafBorder &copy) :
	ZafWindowObject(copy)
{
}

ZafBorder::~ZafBorder(void)
{
}

ZafWindowObject *ZafBorder::Duplicate(void)
{
	return (new ZafBorder(*this));
}

const ZafPaletteStruct *ZafBorder::MapClassPalette(ZafPaletteType type, ZafPaletteState state)
{
	const ZafPaletteStruct *palette = MapPalette(defaultPaletteMap, type, state);
	return (palette ? palette : ZafWindowObject::MapClassPalette(type, state));
}

bool ZafBorder::SetAcceptDrop(bool )
{
	// acceptDrop is false for this class.
	acceptDrop = false;
	return (acceptDrop);
}

bool ZafBorder::SetBordered(bool )
{
	// bordered is false for this class.
	bordered = false;
	return (bordered);
}

bool ZafBorder::SetCopyDraggable(bool )
{
	// copyDraggable is false for this class.
	copyDraggable = false;
	return (copyDraggable);
}

bool ZafBorder::SetDisabled(bool )
{
	// disabled is false for this class.
	disabled = false;
	return (disabled);
}

bool ZafBorder::SetFocus(bool )
{
	// focus is false for this class.
	focus = false;
	return (focus);
}

ZafLogicalFont ZafBorder::SetFont(ZafLogicalFont )
{
	// This class does not permit font changes.
	return (ZAF_FNT_NULL);
}

const ZafIChar *ZafBorder::SetHelpContext(const ZafIChar *)
{
	// help context is empty for this class.
	return (ZAF_NULLP(ZafIChar));
}

const ZafIChar *ZafBorder::SetHelpObjectTip(const ZafIChar *)
{
	// helpObjectTip cannot be set for this class.
	return (ZAF_NULLP(ZafIChar));
}

bool ZafBorder::SetLinkDraggable(bool )
{
	// linkDraggable is false for this class.
	linkDraggable = false;
	return (linkDraggable);
}

bool ZafBorder::SetMoveDraggable(bool )
{
	// moveDraggable is false for this class.
	moveDraggable = false;
	return (moveDraggable);
}

bool ZafBorder::SetNoncurrent(bool )
{
	// noncurrent is true for this class.
	noncurrent = true;
	return (noncurrent);
}

bool ZafBorder::SetParentDrawBorder(bool )
{
	// parentDrawBorder is false for this class.
	parentDrawBorder = false;
	return (parentDrawBorder);
}

bool ZafBorder::SetParentDrawFocus(bool )
{
	// parentDrawFocus is false for this class.
	parentDrawFocus = false;
	return (parentDrawFocus);
}

bool ZafBorder::SetParentPalette(bool )
{
	// parentPalette is false for this class.
	parentPalette = false;
	return (parentPalette);
}

const ZafIChar *ZafBorder::SetQuickTip(const ZafIChar *)
{
	// quickTip cannot be set for this class.
	return (ZAF_NULLP(ZafIChar));
}

ZafRegionType ZafBorder::SetRegionType(ZafRegionType )
{
	// regionType is ZAF_OUTSIDE_REGION for this class.
	regionType = ZAF_OUTSIDE_REGION;
	return (regionType);
}

bool ZafBorder::SetSelected(bool )
{
	// selected is false for this class.
	selected = false;
	return (selected);
}

bool ZafBorder::SetSupportObject(bool )
{
	// SupportObject is automatically true for border.
	supportObject = true;
	return (bordered);
}

ZafLogicalColor ZafBorder::SetTextColor(ZafLogicalColor , ZafLogicalColor )
{
	// This class does not permit text color changes.
	return (ZAF_CLR_NULL);
}

ZafUserFunction ZafBorder::SetUserFunction(ZafUserFunction )
{
	// userFunction is null for this class.
	userFunction = ZAF_NULLF(ZafUserFunction);
	return (userFunction);
}

ZafError ZafBorder::SetWidth(int newWidth)
{
	// Reset the default border width.
	int save = width;
	width = (newWidth > 0) ? newWidth : 1;
	ZafError result = OSSetWidth();
	if (result != ZAF_ERROR_NONE)
		width = save;
	return (result);
}

int ZafBorder::Width(void)
{
	// Update the width.
	OSGetWidth();
	return (width);
}

// ----- Persistent functions -----------------------------------------------

ZafBorder::ZafBorder(const ZafIChar *, ZafObjectPersistence &) :
	ZafWindowObject(0, 0, 0, 0)
{
	// Set the border information.
	SetSupportObject(true);
	SetSystemObject(false);
	SetRegionType(ZAF_OUTSIDE_REGION);
	SetNoncurrent(true);
	SetNumberID(ZAF_NUMID_BORDER);
	SetStringID(_stringID);
}

ZafElement *ZafBorder::Read(const ZafIChar *name, ZafObjectPersistence &persist)
{
	return (new ZafBorder(name, persist));
}

void ZafBorder::Write(ZafObjectPersistence &persist)
{
	// Register the read procedure.
	persist.AddObjectConstructor(ClassName(), ClassID(), ReadFunction());

	// Prepare the file.
	persist.PushLevel(ClassName(), ClassID(), ZAF_PERSIST_DIRECTORY);
	persist.AllocateFile(stringID);
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

