//	Zinc Application Framework - Z_BNUM1.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_bnum.hpp>
#include <z_ctype.hpp>
// The next two lines must be in this order to compile on SunOS 4.1.x
#include <z_stdlib.hpp>
#include <z_stdio.hpp>
#include <z_stdarg.hpp>
#include <z_utils.hpp>

static ZafIChar _bnumfFormat[]	= { '%','l','f', 0 };
static ZafIChar _bnumnfFormat[]	= { '%','-','.','*','l','f', 0 };

// ----- ZafBignumData ------------------------------------------------------

ZafBignumData::ZafBignumData(double zValue) :
	ZafFormatData()
{
	// Check the printf binding.
	Bind();
	SetBignum(zValue);
}

void ZafBignumData::Rtob(double value)
{
	Clear();

	ZafIChar buffer[ZAF_NUMBER_WHOLE+ZAF_NUMBER_DECIMAL+4];
	sprintf(buffer, _bnumnfFormat, ZAF_NUMBER_DECIMAL, value);
	SetBignum(buffer, ZAF_NULLP(ZafIChar));
}

double ZafBignumData::RValue(void) const
{
	double value;
	ZafIChar buffer[ZAF_NUMBER_WHOLE+ZAF_NUMBER_DECIMAL+4];
	FormattedText(buffer, ZAF_NUMBER_WHOLE+ZAF_NUMBER_DECIMAL+4, ZAF_NULLP(ZafIChar));
	sscanf(buffer, _bnumfFormat, &value);
	return (value);
}

ZafError ZafBignumData::SetBignum(double value)
{
	// Reset the value.
	PushLevel();
	Rtob(value);
	PopLevel();

	// Return success.
	return (ZAF_ERROR_NONE);
}

