ZAF_ROOT=..

!include $(ZAF_ROOT)\include\optswat.mak
!include watfiles.mak

# Zinc Application Framework 5.0 library makefile
# Uses Watcom C/C++ 10.6 and 11.0 with Watcom WMAKE.EXE (excluding QNX)
#
# Builds Zinc library for 32 bit DOS (using DOS4GW), Windows 16, Windows 32,
#  OS2, DESQview/X (using Motif toolkit), QNX (Motif).
#    wmake -f watcom.mak dos32
#    wmake -f watcom.mak win16
#    wmake -f watcom.mak win32
#    wmake -f watcom.mak os2
#    wmake -f watcom.mak dvx
#    make -f watcom.mak qnx
#
# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
# DOS 32:
#    set INCLUDE=.;C:\WATCOM\H;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\DOS;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# WIN 16:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\WIN;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB286\WIN;C:\WATCOM\LIB286;C:\ZINC\LIB\WCCPP
# WIN 32:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\NT;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\NT;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# OS/2:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\OS2;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\OS2;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# DESQView/X:
#    set INCLUDE=.;C:\DVX\INCLUDE;C:\WATCOM\H;C:\ZINC\INCLUDE
#    set LIB=.;C:\DVX\LIB\C386;C:\WATCOM\LIB386\DOS;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
#
# ----- General Definitions -------------------------------------------------
VERSION=watcom

# ----- Usage ---------------------------------------------------------------
usage: .SYMBOLIC
	@echo This makefile supports Watcom 10.6 and 11.0
	@echo ...........
	@echo ...........
	@echo To generate the library modules for specific environments type:
	@echo wmake -f watcom.mak dos32
	@echo wmake -f watcom.mak win16
	@echo wmake -f watcom.mak win32
	@echo wmake -f watcom.mak os2
	@echo wmake -f watcom.mak dvx
	@echo make -f watcom.mak qnx
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean: .SYMBOLIC
	z_clean.bat

# ----- Copy files ----------------------------------------------------------
copy: .SYMBOLIC
	-@md ..\include
	-@copy z_*.hpp ..\include
	-@copy ?_env.hpp ..\include
	-@md ..\bin
   	-@copy z_clean.* ..\bin
	-@md ..\lib

met_copy: .SYMBOLIC
	copy meta\*.fnt ..\bin
	copy meta\*.drp ..\bin
	copy meta\*.h ..\include
	copy meta\*.c ..\include
	-@md ..\lib\$(VERSION)
	copy meta\met_xr3l.lib ..\lib\$(VERSION)

# ----- DOS 32 bit (DOS4GW extender) Libraries and Programs -----------------

# This is pending

# ----- Windows 16 bit Libraries and Programs -------------------------------
win16: wtest16.exe copy .SYMBOLIC

wtest16.exe: test.ob1 zafw16.lib
	$(WIN_LINK) $(WIN_LINK_OPTS) N wtest16 F test.ob1 $(WIN_OBJS) L $(WIN_LIBS)

W16_LIB_OBJECTS=&
	$(W16_SOURCE_CORE)&
	$(W16_SOURCE_WINDOWS)&
	$(W16_SOURCE_WINDOWS_NO_DLL)

W16_OBJECTS=&
	$(W16_LIB_OBJECTS)&
	$(W16_SOURCE_PERSIST_ALL)&
	$(W16_SOURCE_PERSIST_NONE)

zafw16.lib: &
	$(W16_OBJECTS)
	-@del zafw16.lib
	%write watw16.wcc $(W16_LIB_OBJECTS)
	$(WIN_LIBRARIAN) $(WIN_LIB_OPTS) zafw16.lib @watw16.wcc
	@del watw16.wcc
	$(WIN_LIBRARIAN) $(WIN_LIB_OPTS) zafw16p.lib $(W16_SOURCE_PERSIST_ALL)
	$(WIN_LIBRARIAN) $(WIN_LIB_OPTS) zafw16n.lib $(W16_SOURCE_PERSIST_NONE)
	-@md ..\lib\$(VERSION)
	copy zafw16.lib ..\lib\$(VERSION)
	copy zafw16p.lib ..\lib\$(VERSION)
	copy zafw16n.lib ..\lib\$(VERSION)

# ----- Windows 32 bit Libraries and Programs -------------------------------
win32: wtest32.exe copy .SYMBOLIC

wtest32.exe: test.obw zafw32.lib
	$(W32_LINK) $(W32_LINK_OPTS) N wtest32 F test.obw$(W32_OBJS) L $(W32_LIBS)

WIN_LIB_OBJECTS=&
	$(W32_SOURCE_CORE) &
	$(W32_SOURCE_WINDOWS) &
	$(W32_SOURCE_WINDOWS_NO_DLL)

WIN_OBJECTS=&
	$(WIN_LIB_OBJECTS)&
	$(W32_SOURCE_PERSIST_ALL)&
	$(W32_SOURCE_PERSIST_NONE)

zafw32.lib: &
	$(WIN_OBJECTS)
	-@del zafw32.lib
	%write watw32.wcc $(WIN_LIB_OBJECTS)
	$(W32_LIBRARIAN) $(W32_LIB_OPTS) zafw32.lib @watw32.wcc
	@del watw32.wcc
	$(W32_LIBRARIAN) $(W32_LIB_OPTS) zafw32p.lib $(W32_SOURCE_PERSIST_ALL)
	$(W32_LIBRARIAN) $(W32_LIB_OPTS) zafw32n.lib $(W32_SOURCE_PERSIST_NONE)
	-@md ..\lib\$(VERSION)
	copy zafw32.lib ..\lib\$(VERSION)
	copy zafw32p.lib ..\lib\$(VERSION)
	copy zafw32n.lib ..\lib\$(VERSION)

# ----- 32 bit Windows DLL compiler options ---------------------------------
win32dll: wtest.exe copy .SYMBOLIC

wtest.exe: zafw32.dll zafw32nd.lib zafw32pd.lib zafw32d.lib test.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N $@ F test.obi $(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

PERSIST_IMPORT_ALL=&
	$(W32_DLL_SOURCE_PERSIST_ALL)
PERSIST_IMPORT_NONE=&
	$(W32_DLL_SOURCE_PERSIST_NONE)
IMPORT_WINDOWS_NO_DLL=&
	$(W32_DLL_SOURCE_WINDOWS_NO_DLL)

zafw32d.lib: $(IMPORT_WINDOWS_NO_DLL)
	$(W32_LIBRARIAN) $(W32_LIB_OPTS) $@ +$(IMPORT_WINDOWS_NO_DLL)
	copy $@ ..\lib\$(VERSION)

zafw32nd.lib: $(PERSIST_IMPORT_NONE)
	$(W32_LIBRARIAN) $(W32_LIB_OPTS) $@ +$(PERSIST_IMPORT_NONE)
	copy $@ ..\lib\$(VERSION)

zafw32pd.lib: $(PERSIST_IMPORT_ALL)
	$(W32_LIBRARIAN) $(W32_LIB_OPTS) $@ +$(PERSIST_IMPORT_ALL)
	copy $@ ..\lib\$(VERSION)

W32_DLL_EXPORT_OBJECTS=&
	$(W32_DLL_SOURCE_CORE)&
	$(W32_DLL_SOURCE_WINDOWS)

W32_LIB_DLL_EXPORT_OBJECTS=&
	$(W32_LIB_DLL_SOURCE_CORE),&
	$(W32_LIB_DLL_SOURCE_WINDOWS)

zafw32.dll: &
	$(PERSIST_IMPORT_ALL)&
	$(W32_DLL_EXPORT_OBJECTS)
	-@del zafw32.dll
	%write watw32d.wcc File $(W32_LIB_DLL_EXPORT_OBJECTS),$(PERSIST_IMPORT_ALL)
	$(W32_LINK) N $@ $(W32_DLL_EXPORT_LINK_OPTS) libr $(W32_DLL_EXPORT_LIBS) @watw32d.wcc
	@del watw32d.wcc
	$(W32_LIBRARIAN) -n -b zafw32i.lib +zafw32.dll
	-@md ..\lib
	-@md ..\lib\$(VERSION)
	copy zafw32.dll ..\lib\$(VERSION)
	copy zafw32i.lib ..\lib\$(VERSION)

# ----- OS/2 Libraries and Programs -----------------------------------------

# This is pending.

# ----- QNX Motif Libraries and Programs ------------------------------------
qnx: qcopy zaftest

qcopy:
	cp z_*.hpp ../include
	cp m_env.hpp ../include

ZAF_Z_OBJS = z_app.o \
	z_bitmap.o \
	z_bnum.o \
	z_bnum1.o \
	z_bnum2.o \
	z_border.o \
	z_button.o \
	z_combo.o \
	z_cset.o \
	z_ctype.o \
	z_data.o \
	z_data1.o \
	z_data2.o \
	z_date.o \
	z_date1.o \
	z_device.o \
	z_dskfil.o \
	z_error.o \
	z_error1.o \
	z_event.o \
	z_evtmgr.o \
	z_fdata.o \
	z_file.o \
	z_file1.o \
	z_fmtstr.o \
	z_gmgr.o \
	z_gmgr1.o \
	z_gmgr2.o \
	z_gmgr3.o \
	z_gmgr4.o \
	z_group.o \
	z_help.o \
	z_help1.o \
	z_hlist.o \
	z_htips.o \
	z_icon.o \
	z_icon1.o \
	z_idata.o \
	z_image.o \
	z_int.o \
	z_int1.o \
	z_i18n.o \
	z_lang.o \
	z_list.o \
	z_list1.o \
	z_loc.o \
	z_max.o \
	z_min.o \
	z_mouse.o \
	z_notebk.o \
	z_notify.o \
	z_pal.o \
	z_plldn.o \
	z_plldn1.o \
	z_popup.o \
	z_popup1.o \
	z_prgrss.o \
	z_printf.o \
	z_prompt.o \
	z_pall.o \
	z_pnone.o \
	z_prst.o \
	z_prst1.o \
	z_real.o \
	z_real1.o \
	z_region.o \
	z_scanf.o \
	z_scrll.o \
	z_scrll1.o \
	z_spin.o \
	z_status.o \
	z_stdarg.o \
	z_stdio.o \
	z_stdlib.o \
	z_store.o \
	z_store1.o \
	z_str.o \
	z_str1.o \
	z_string.o \
	z_sys.o \
	z_table.o \
	z_table1.o \
	z_table2.o \
	z_tbar.o \
	z_text.o \
	z_time.o \
	z_time1.o \
	z_timer.o \
	z_title.o \
	z_tree.o \
	z_tree1.o \
	z_unistd.o \
	z_utils.o \
	z_utime.o \
	z_utime1.o \
	z_vlist.o \
	z_win.o \
	z_win1.o \
	z_win2.o \
	z_win3.o

ZAF_M_OBJS = m_app.o \
	m_border.o \
	m_button.o \
	m_client.o \
	m_combo.o \
	m_cursor.o \
	m_dsp.o \
	m_error.o \
	m_error1.o \
	m_evtmgr.o \
	m_fmtstr.o \
	m_frame.o \
	m_group.o \
	m_hlist.o \
	m_htips.o \
	m_icon.o \
	m_image.o \
	m_keybrd.o \
	m_max.o \
	m_min.o \
	m_mouse.o \
	m_notebk.o \
	m_plldn.o \
	m_plldn1.o \
	m_popup.o \
	m_popup1.o \
	m_prompt.o \
	m_scrll.o \
	m_shell.o \
	m_spin.o \
	m_status.o \
	m_str.o \
	m_sys.o \
	m_table.o \
	m_table1.o \
	m_table2.o \
	m_tbar.o \
	m_text.o \
	m_timer.o \
	m_title.o \
	m_tree.o \
	m_tree1.o \
	m_utils.o \
	m_vlist.o \
	m_win.o \
	m_win1.o \
	m_win2.o

ZAF_A_OBJS = z_dlgwin.o \
	z_fildlg.o \
	z_mdiwin.o \
	z_msgwin.o \
	z_sclwin.o \
	m_dlgwin.o \
	m_fildlg.o \
	m_mdiwin.o \
	m_sclwin.o

$(QNX_LIB_NAME): \
	$(ZAF_Z_OBJS) \
	$(ZAF_M_OBJS) \
	$(ZAF_A_OBJS)
	$(QNX_LIBRARIAN) $(QNX_LIB_OPTS) $@ $?
	cp z_pall.o ..\lib\$(VERSION)
	cp z_pnone.o ..\lib\$(VERSION)

zaftest: test.o $(QNX_LIB_NAME)
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ test.o $(QNX_LIB_DIRS) $(QNX_LIBS)

qclean:
	rm -f $(QNX_LIB_NAME) zaftest *.o

# --- Done with libraries ---------------------------------------------------

