//	Zinc Application Framework - LOC_TW.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#define locCodeset	CP_UNICODE
#define LENGTHOF(x)	(sizeof(x)/sizeof((x)[0]))

// Locale definitions for the Republic of China (TW).
static ZafIChar ZAF_FARDATA defaultLocaleName[] = ZAF_ITEXT("TW");
static ZafEraStruct ZAF_FARDATA eraTable[] =
{
	{ 1, 2, 2419769L, 0xffffffffL, { 0x4e2d, 0x83ef, 0x6c11, 0x570b }, { '%','E','C','%','E','y', 0x5e74, 0 } },	// JungHwaMingGwo [] Nyan
	{ 1, 1, 2419403L, 2419768L, { 0x4e2d, 0x83ef, 0x6c11, 0x570b }, { '%','E','C', 0x5143, 0x5e74, 0 } },			// JungHwaMingGwo YwanNyan
	{ 1, 1, 1721424L, 2419402L, ZAF_ITEXT("AD"), ZAF_ITEXT("%EC %Ey") },											// MingChyan [] Nyan
	{ 0, 4713, 0L, 1721423L, ZAF_ITEXT("BCE"), ZAF_ITEXT("%Ey %EC") }
};
static ZafLocaleStruct ZAF_FARDATA defaultLocale =
{
	ZAF_ITEXT("."),	// decimalSeparator
	ZAF_ITEXT("."),	// monDecimalSeparator
	ZAF_ITEXT(","),	// thousandsSeparator
	ZAF_ITEXT(","),	// monthousandsSeparator
	ZAF_ITEXT("NT$"),	// CurrencySymbol
	{ 3, 0 },	// grouping
	{ 3, 0 },	// monGrouping
	ZAF_ITEXT("TWD "),	// IntCurrencySymbol
	1,		// posCurrencyPrecedes
	1,		// negCurrencyPrecedes
	2,		// fractionDigits
	2,		// intFractionDigits
	ZAF_ITEXT(""),		// positiveSign
	1,		// posSignPreceides
	0,		// posSpaceSeparation
	ZAF_ITEXT("-"),	// negativeSign
	1,		// negSignPreceides
	0,		// negSpaceSeparation
	ZAF_ITEXT("("),
	ZAF_ITEXT(")"),
	ZAF_ITEXT("%d"),
	ZAF_ITEXT("%d"),
	ZAF_ITEXT("%g"),
	ZAF_ITEXT("%g"),
	(ZAF_ITEXT("%H:%M:%S\n")
				ZAF_ITEXT("%H%M%S\n")
				ZAF_ITEXT("%H:%M\n")
				ZAF_ITEXT("%H%M\n")
				ZAF_ITEXT("%H%")),
	ZAF_ITEXT("%H:%M:%S"),
	ZAF_ITEXT("%H:%M:%S"),
	(ZAF_ITEXT("%y/%m/%d\n")
				ZAF_ITEXT("%y%m%d\n")
				ZAF_ITEXT("%y%h%d\n")
				ZAF_ITEXT("%Y/%m/%d\n")
				ZAF_ITEXT("%Y%m%d\n")
				ZAF_ITEXT("%Y%h%d\n")
				ZAF_ITEXT("%m%d\n")
				ZAF_ITEXT("%h%d\n")
				ZAF_ITEXT("%d")),
	ZAF_ITEXT("%y/%m/%d"),
	ZAF_ITEXT("%D%T"),
	ZAF_ITEXT("%y/%m/%d %H:%M:%S"),
	ZAF_ITEXT("0123456789"),
	{ 0x3007, 0x4e00, 0x4e8c, 0x4e09, 0x56db, 0x4e94, 0x516d, 0x4e03, 0x516b, 0x4e5d, 0x5341, 0x767e, 0x5343, 0x842c, 0 },
	ZAF_ITEXT(":"),
	ZAF_ITEXT("-"),
	2299160L,	// Oct 4, 1582
	11,		// to 2299171L	Oct 15, 1582
	LENGTHOF(eraTable),
	eraTable
};
