//	Zinc Application Framework - LOC_NL.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if defined(ZAF_UNICODE)
#	define locCodeset	CP_UNICODE
#else
#	define locCodeset	CP_ISO8859_1
#endif

// Locale definitions for NETHERLANDS (NL).
static ZafIChar ZAF_FARDATA defaultLocaleName[] = ZAF_ITEXT("NL");
static ZafLocaleStruct ZAF_FARDATA defaultLocale =
{
	ZAF_ITEXT(","),	// DecimalSeparator
	ZAF_ITEXT(","),	// MonDecimalSeparator
	ZAF_ITEXT("."),	// ThousandsSeparator
	ZAF_ITEXT("."),	// MonThousandsSeparator
	ZAF_ITEXT("F"),	// CurrencySymbol
	{ 3, 0 },	// Grouping
	{ 3, 0 },	// MonGrouping
	ZAF_ITEXT("NLG "),	// IntCurrencySymbol
	1,		// posCurrencyPrecedes
	1,		// negCurrencyPrecedes
	2,		// fractionDigits
	2,		// intFractionDigits
	ZAF_ITEXT(""),		// PositiveSign
	1,		// posSignPreceides
	1,		// posSpaceSeparation
	ZAF_ITEXT("-"),	// NegativeSign
	2,		// negSignPreceides
	1,		// negSpaceSeparation
	ZAF_ITEXT("("),
	ZAF_ITEXT(")"),
	ZAF_ITEXT("%d"),
	ZAF_ITEXT("%d"),
	ZAF_ITEXT("%g"),
	ZAF_ITEXT("%g"),
	(ZAF_ITEXT("%H:%M:%S\n")
				ZAF_ITEXT("%H%M%S\n")
				ZAF_ITEXT("%H:%M\n")
				ZAF_ITEXT("%H%M\n")
				ZAF_ITEXT("%H%")),
	ZAF_ITEXT("%H:%M:%S"),
	ZAF_ITEXT("%H:%M:%S"),
	(ZAF_ITEXT("%d.%m.%y\n")
				ZAF_ITEXT("%d%m%y\n")
				ZAF_ITEXT("%d%B%y\n")
				ZAF_ITEXT("%d.%m.%Y\n")
				ZAF_ITEXT("%d%m%Y\n")
				ZAF_ITEXT("%d%B%Y\n")
				ZAF_ITEXT("%d%m\n")
				ZAF_ITEXT("%d%B\n")
				ZAF_ITEXT("%d")),
	ZAF_ITEXT("%d %B %Y"),
	ZAF_ITEXT("%D%T"),
	ZAF_ITEXT("%d %B %Y %H:%M:%S"),
	ZAF_ITEXT("0123456789"),
	ZAF_ITEXT("0123456789"),
	ZAF_ITEXT(":"),	// TimeSeparator
	ZAF_ITEXT("-"),	// DateSeparator
	2299160L,	// Oct 4, 1582
	11,		// to 2299171L	Oct 15, 1582
	0,
	ZAF_NULLP(ZafEraStruct)
};
