//	Zinc Application Framework - LOC_JP.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#define locCodeset	CP_UNICODE
#define LENGTHOF(x)	(sizeof(x)/sizeof((x)[0]))

// Locale definitions for JAPAN (JP).
static ZafIChar ZAF_FARDATA defaultLocaleName[] = ZAF_ITEXT("JP");
static ZafEraStruct ZAF_FARDATA eraTable[] =
{
	{ 1, 2, 2447893L, 0xffffffffL, { 0x5e73, 0x6210, 0 }, { '%','E','C','%','E','y', 0x5e74, 0 } },		// Heisei [] nen
	{ 1, 1, 2447535L, 2447892L, { 0x5e73, 0x6210, 0 }, { '%','E','C', 0x5143, 0x5e74, 0 } },			// Heisei gannen
	{ 1, 2, 2424882L, 2447534L, { 0x662D, 0x5442, 0 }, { '%','E','C','%','E','y', 0x5e74, 0 } },		// Shouwa [] nen
	{ 1, 1, 2424875L, 2424881L, { 0x662D, 0x5442, 0 }, { '%','E','C', 0x5143, 0x5e74, 0 } },			// Shouwa gannen
	{ 1, 2, 2419769L, 2424874L, { 0x5927, 0x6b63, 0 }, { '%','E','C','%','E','y', 0x5e74, 0 } },		// Taishou [] nen
	{ 1, 1, 2419614L, 2419768L, { 0x5927, 0x6b63, 0 }, { '%','E','C', 0x5143, 0x5e74, 0 } },			// Taishou gannen
	{ 1, 2, 2403699L, 2419613L, { 0x660e, 0x6cbb, 0 }, { '%','E','C','%','E','y', 0x5e74, 0 } },		// Meiji [] nen
	{ 1, 1, 2403584L, 2403698L, { 0x660e, 0x6cbb, 0 }, { '%','E','C', 0x5143, 0x5e74, 0 } },			// Meiji [] gannen
	{ 1, 1, 1721424L, 2403583L, { 0x897f, 0x66a6, 0 }, { '%','E','C','%','E','y', 0x5e74, 0 } },		// CE [] nen
	{ 0, 4713, 0L, 1721423L, { 0x7D00, 0x5143, 0x524d, 0 }, { '%','E','C','%','E','y', 0x5e74, 0 } }	// BCE [] nen
};
static ZafLocaleStruct ZAF_FARDATA defaultLocale =
{
	ZAF_ITEXT("."),	// decimalSeparator
	{ 0 },	// monDecimalSeparator
	ZAF_ITEXT(","),	// thousandsSeparator
	ZAF_ITEXT(","),	// monthousandsSeparator
	{ 0xa5, 0 },	// CurrencySymbol
	{ 3, 0 },	// grouping
	{ 3, 0 },	// monGrouping
	ZAF_ITEXT("JPY "),	// IntCurrencySymbol
	1,		// posCurrencyPrecedes
	1,		// negCurrencyPrecedes
	0,		// fractionDigits
	0,		// intFractionDigits
	ZAF_ITEXT(""),		// positiveSign
	1,		// posSignPreceides
	0,		// posSpaceSeparation
	ZAF_ITEXT("-"),	// negativeSign
	1,		// negSignPreceides
	0,		// negSpaceSeparation
#if defined(ZAF_UNICODE)
	{ 0xff08, 0 },
	{ 0xff09, 0 },
#else
	ZAF_ITEXT("("),
	ZAF_ITEXT(")"),
#endif
	ZAF_ITEXT("%d"),
	ZAF_ITEXT("%d"),
	ZAF_ITEXT("%g"),
	ZAF_ITEXT("%g"),
	(ZAF_ITEXT("%H:%M:%S\n")
				ZAF_ITEXT("%H%M%S\n")
				ZAF_ITEXT("%H:%M\n")
				ZAF_ITEXT("%H%M\n")
				ZAF_ITEXT("%H%")),
	ZAF_ITEXT("%H:%M:%S"),
	ZAF_ITEXT("%H:%M:%S"),
	(ZAF_ITEXT("%y-%m-%d\n")
				ZAF_ITEXT("%y%m%d\n")
				ZAF_ITEXT("%y%h%d\n")
				ZAF_ITEXT("%Y-%m-%d\n")
				ZAF_ITEXT("%Y%m%d\n")
				ZAF_ITEXT("%Y%h%d\n")
				ZAF_ITEXT("%m%d\n")
				ZAF_ITEXT("%h%d\n")
				ZAF_ITEXT("%d")),
	ZAF_ITEXT("%Y-%m-%d"),
	ZAF_ITEXT("%D%T"),
	ZAF_ITEXT("%Y-%m-%d %H:%M:%S"),
	ZAF_ITEXT("0123456789"),
	ZAF_ITEXT("0123456789"),
	ZAF_ITEXT(":"),
	ZAF_ITEXT("-"),
	2299160L,	// Oct 4, 1582
	11,		// to 2299171L	Oct 15, 1582
	LENGTHOF(eraTable),
	eraTable
};
