//	Zinc Application Framework - LANG_JA.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

// In error statements, the %1%s is the data, the %2%s is the range.

#if defined(ZAF_LANGUAGE_INFO)
#	define langCodeset	CP_OTHER
#	define langCodesetName	"IBM_932"
	// Language definitions for JAPANESE (JA).
	static ZafIChar ZAF_FARDATA defaultLanguageName[] = { 'j','a',0 };
#endif

#if defined(ZAF_LANGUAGE_DATA_INFO)
ZafIChar ZafLanguageData::blankString[] = ZAF_ITEXT("");
ZafIChar ZafLanguageData::errorString[] = ZAF_ITEXT("G[");
#endif

#if defined(ZAF_UTIME_DATA_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultDayStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("j"),	ZAF_DAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("j"),	ZAF_DAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Ηj"),	ZAF_DAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("j"),	ZAF_DAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("ؗj"),	ZAF_DAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("j"),	ZAF_DAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("yj"),	ZAF_DAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(""), ZAF_SHDAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(""), ZAF_SHDAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(""), ZAF_SHDAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(""), ZAF_SHDAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(""), ZAF_SHDAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(""), ZAF_SHDAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("y"), ZAF_SHDAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(""), ZAF_ABDAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(""), ZAF_ABDAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(""), ZAF_ABDAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(""), ZAF_ABDAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(""), ZAF_ABDAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(""), ZAF_ABDAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("y"), ZAF_ABDAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
static ZafLanguageStruct ZAF_FARDATA defaultMonthStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("P"),	ZAF_MON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Q"),	ZAF_MON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("R"),	ZAF_MON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("S"),	ZAF_MON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("T"),	ZAF_MON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("U"),	ZAF_MON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("V"),	ZAF_MON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("W"),	ZAF_MON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("X"),	ZAF_MON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("PO"),	ZAF_MON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("PP"),	ZAF_MON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("PQ"),	ZAF_MON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("1"),	ZAF_SHMON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("2"),	ZAF_SHMON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("3"),	ZAF_SHMON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("4"),	ZAF_SHMON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("5"),	ZAF_SHMON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("6"),	ZAF_SHMON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("7"),	ZAF_SHMON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("8"),	ZAF_SHMON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("9"),	ZAF_SHMON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("10"),	ZAF_SHMON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("11"),	ZAF_SHMON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("12"),	ZAF_SHMON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("1"),	ZAF_ABMON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("2"),	ZAF_ABMON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("3"),	ZAF_ABMON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("4"),	ZAF_ABMON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("5"),	ZAF_ABMON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("6"),	ZAF_ABMON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("7"),	ZAF_ABMON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("8"),	ZAF_ABMON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("9"),	ZAF_ABMON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("10"),	ZAF_ABMON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("11"),	ZAF_ABMON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("12"),	ZAF_ABMON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
static ZafLanguageStruct ZAF_FARDATA defaultTimeStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("A.M."), ZAF_AM, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("P.M."), ZAF_PM, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("xxxx"), ZAF_TZ, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_UTIME_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT(" %s ́AsȃtH[}bgłD"), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("͂ĂD"), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(" %s ́A %s ͈̔͊OłD"), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(" %s ́A%s OłD"), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(" %s ́A%s łD"), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_BIGNUM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("l %s ͕sȒlłD"), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("l %s ́A%s ͈̔͊OłD"), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("l %s ́A%s 菬߂܂D"), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("l %s ́A%s 傫߂܂D"), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_INTEGER_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("l %s ͕sȒlłD"), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("l %s ́A%s ͈̔͊OłD"), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("l %s ́A%s 菬߂܂D"), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("l %s ́A%s 傫߂܂D"), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_REAL_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("l %s ͕sȒlłD"), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("l %s ́A%s ͈̔͊OłD"), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("l %s ́A%s 菬߂܂D"), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("l %s ́A%s 傫߂܂D"), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_DATE_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("t %s ́AsȃtH[}bgłD"), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("t %s ̌mł͂܂D"), ZAF_ERROR_AMBIGUOUS, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("t %s ̌܂D"), ZAF_ERROR_INVALID_NAME, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("t͂ĂD"), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("t %s ́A%s ͈̔͊OłD"), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("t %s ́A%s OłD"), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("t %s ́A%s łD"), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_TIME_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT(" %s ́AsȃtH[}bgłD"), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("͂ĂD"), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(" %s ́A %s ͈̔͊OłD"), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(" %s ́A%s OłD"), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT(" %s ́A%s łD"), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_ERROR_SYSTEM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("G["), ZAF_MSG_TITLE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("OK"), ZAF_MSG_OK, ZAF_NULLP(ZafStringIDChar), 'O', 0 },
	{ ZAF_ITEXT("(C)"), ZAF_MSG_CANCEL, ZAF_NULLP(ZafStringIDChar), 'C', 3 },
	{ ZAF_ITEXT("Help"), ZAF_MSG_HELP, ZAF_NULLP(ZafStringIDChar), 'H', 0 },
	{ ZAF_ITEXT("ASTERISK"), ZAF_MSG_ICONNAME, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("ړ(M)"), ZAF_MSG_MOVE, ZAF_NULLP(ZafStringIDChar), 'M', 3 },
	{ ZAF_ITEXT("(C)\tAlt+F4"), ZAF_MSG_CLOSE, ZAF_NULLP(ZafStringIDChar), 'C', 4 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_FILE_DIALOG_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultFileStrings[] =
{
	{ ZAF_ITEXT("File New"), ZAF_MSG_NEW, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("File Open"), ZAF_MSG_OPEN, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("File Save"), ZAF_MSG_SAVEAS, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_HELP_SYSTEM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultHelpStrings[] =
{
	{ ZAF_ITEXT("Help Topic"), ZAF_MSG_HELP_TOPIC, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Help Index"), ZAF_MSG_HELP_INDEX, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Show Topic"), ZAF_MSG_SHOW_TOPIC, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Show Index"), ZAF_MSG_SHOW_INDEX, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Select A Topic"), ZAF_MSG_MESSAGE1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Type a word, or select one from the list."), ZAF_MSG_MESSAGE2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Close"), ZAF_MSG_CLOSE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("wv"), ZAF_MSG_ICONTITLE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("QUESTION"), ZAF_MSG_ICONNAME, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_SYSTEM_BUTTON_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultStrings[] =
{
	{ ZAF_ITEXT("̑傫ɖ߂(R)"), ZAF_RESTORE_OPTION, ZAF_NULLP(ZafStringIDChar), 'R', 9 },	// S_RESTORE
	{ ZAF_ITEXT("ړ(M)"), ZAF_MOVE_OPTION, ZAF_NULLP(ZafStringIDChar), 'M', 3 },					// S_MOVE_MODE
	{ ZAF_ITEXT("TCYύX(S)"), ZAF_SIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'S', 6 },			// S_SIZE_MODE
	{ ZAF_ITEXT("ACR(N)"), ZAF_MINIMIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'N', 6 },		// S_MINIMIZE
	{ ZAF_ITEXT("ő\\(X)"), ZAF_MAXIMIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'X', 5 },			// S_MAXIMIZE
	{ ZAF_ITEXT(""), ZAF_SEPARATOR, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("(C)"), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'C', 4 },				// S_CLOSE
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_POPUP_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultPopupStrings[] =
{
#	if defined(ZAF_MACINTOSH)
	{ ZAF_ITEXT("Quit"), ZAF_EXIT_OPTION, ZAF_NULLP(ZafStringIDChar), 'Q', -1 },
	{ ZAF_ITEXT(""), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'W', -1 },
	{ ZAF_ITEXT("Cut"), ZAF_CUT_OPTION, ZAF_NULLP(ZafStringIDChar), 'X', -1 },
	{ ZAF_ITEXT("Copy"), ZAF_COPY_OPTION, ZAF_NULLP(ZafStringIDChar), 'C', -1 },
	{ ZAF_ITEXT("Paste"), ZAF_PASTE_OPTION, ZAF_NULLP(ZafStringIDChar), 'V', -1 },
#	else
	{ ZAF_ITEXT("Exit"), ZAF_EXIT_OPTION, ZAF_NULLP(ZafStringIDChar), 'X', 1 },
	{ ZAF_ITEXT("(C)"), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'C', 4 },
	{ ZAF_ITEXT("Cut\tCtl+X"), ZAF_CUT_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Copy\tCtl+C"), ZAF_COPY_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Paste\tCtl+V"), ZAF_PASTE_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
#	endif
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_WINDOW_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("ERROR"), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_MESSAGE_WINDOW_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultMessageStrings[] =
{
	{ ZAF_ITEXT("(O)"), ZAF_DIALOG_OK, ZAF_NULLP(ZafStringIDChar), 'O', 3 },
	{ ZAF_ITEXT("͂(Y)"), ZAF_DIALOG_YES, ZAF_NULLP(ZafStringIDChar), 'Y', 3 },
	{ ZAF_ITEXT("(N)"), ZAF_DIALOG_NO, ZAF_NULLP(ZafStringIDChar), 'N', 4 },
	{ ZAF_ITEXT("~(A)"), ZAF_DIALOG_ABORT, ZAF_NULLP(ZafStringIDChar), 'A', 5 },
	{ ZAF_ITEXT("x(R)"), ZAF_DIALOG_RETRY, ZAF_NULLP(ZafStringIDChar), 'R', 5 },
	{ ZAF_ITEXT("(I)"), ZAF_DIALOG_IGNORE, ZAF_NULLP(ZafStringIDChar), 'I', 5 },
	{ ZAF_ITEXT("(C)"), ZAF_DIALOG_CANCEL, ZAF_NULLP(ZafStringIDChar), 'C', 5 },
	{ ZAF_ITEXT("wv(H)"), ZAF_DIALOG_HELP, ZAF_NULLP(ZafStringIDChar), 'H', 4 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif
