//	Zinc Application Framework - LANG_FR.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

// In error statements, the %1%s is the data, the %2%s is the range.

#if defined(ZAF_LANGUAGE_INFO)
#	define langCodeset	CP_ISO8859_1
	// Language definitions for FRENCH (FR).
	static ZafIChar ZAF_FARDATA defaultLanguageName[] = { 'f','r',0 };
#endif

#if defined(ZAF_LANGUAGE_DATA_INFO)
ZafIChar ZafLanguageData::blankString[] = ZAF_ITEXT("");
ZafIChar ZafLanguageData::errorString[] = ZAF_ITEXT("Erreur");
#endif

#if defined(ZAF_UTIME_DATA_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultDayStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dimanche"), ZAF_DAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Lundi"), ZAF_DAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mardi"), ZAF_DAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mercredi"), ZAF_DAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jeudi"), ZAF_DAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Vendredi"), ZAF_DAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Samedi"), ZAF_DAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dim"), ZAF_SHDAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Lun"), ZAF_SHDAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mar"), ZAF_SHDAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mer"), ZAF_SHDAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jeu"), ZAF_SHDAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Ven"), ZAF_SHDAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Sam"), ZAF_SHDAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dim."), ZAF_ABDAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Lun."), ZAF_ABDAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mar."), ZAF_ABDAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Merc."), ZAF_ABDAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jeu."), ZAF_ABDAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Vend."), ZAF_ABDAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Sam."), ZAF_ABDAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
static ZafLanguageStruct ZAF_FARDATA defaultMonthStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Janvier"), ZAF_MON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("F\351vrier"), ZAF_MON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mars"), ZAF_MON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Avril"), ZAF_MON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mai"), ZAF_MON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Juin"), ZAF_MON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Juillet"), ZAF_MON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Ao\373t"), ZAF_MON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Septembre"), ZAF_MON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Octobre"), ZAF_MON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Novembre"), ZAF_MON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("D\351cembre"), ZAF_MON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jan"), ZAF_SHMON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("F\351v"), ZAF_SHMON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mar"), ZAF_SHMON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Avr"), ZAF_SHMON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mai"), ZAF_SHMON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Juin"), ZAF_SHMON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 }, // 4 letters otherwise Juin and Juillet same.
	{ ZAF_ITEXT("Juil"), ZAF_SHMON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 }, // 4 letters otherwise Juin and Juillet same.
	{ ZAF_ITEXT("Ao\373"), ZAF_SHMON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Sep"), ZAF_SHMON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Oct"), ZAF_SHMON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Nov"), ZAF_SHMON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("D\351c"), ZAF_SHMON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jan."), ZAF_ABMON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("F\351v."), ZAF_ABMON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mars"), ZAF_ABMON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Avr."), ZAF_ABMON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mai"), ZAF_ABMON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Juin"), ZAF_ABMON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Juil."), ZAF_ABMON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Ao\373t"), ZAF_ABMON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Sept."), ZAF_ABMON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Oct."), ZAF_ABMON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Nov."), ZAF_ABMON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("D\351c."), ZAF_ABMON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
static ZafLanguageStruct ZAF_FARDATA defaultTimeStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("a.m."), ZAF_AM, ZAF_NULLP(ZafStringIDChar), 0, -1 }, // Please note the French do not use A.M. nor P.M.
	{ ZAF_ITEXT("p.m."), ZAF_PM, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("xxxx"), ZAF_TZ, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_UTIME_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Le temps %s ne correspond pas \340 un format valable."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Une valeur doit \352tre introduite pour le temps."), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La temps %s n'est pas dans l'intervalle %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Le temps %s est inf\351rieur \340 %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Le temps %s est sup\351rieur \340 %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_BIGNUM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Le nombre %s n'est pas valable."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Le nombre %s n'est pas dans l'intervalle %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Le nombre %s est inf\351rieur \340 %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1},
	{ ZAF_ITEXT("Le nombre %s est sup\351rieur \340 %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_INTEGER_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Le nombre %s n'est pas valable."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Le nombre %s n'est pas dans l'intervalle %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Le nombre %s est inf\351rieur \340 %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1},
	{ ZAF_ITEXT("Le nombre %s est sup\351rieur \340 %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_REAL_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Le nombre %s n'est pas valable."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Le nombre %s n'est pas dans l'intervalle %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Le nombre %s est inf\351rieur \340 %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1},
	{ ZAF_ITEXT("Le nombre %s est sup\351rieur \340 %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_DATE_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("La date %s n'est pas dans un format valable."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La date %s a un nom de mois ambigu."), ZAF_ERROR_AMBIGUOUS, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La date %s n'a pas un nom de mois valable."), ZAF_ERROR_INVALID_NAME, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Une valeur doit \352tre introduite pour la date."), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La date %s n'est pas dans l'intervalle %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La date %s est inf\351rieure \340 %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La date %s est sup\351rieure \340 %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_TIME_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Le temps %s ne correspond pas \340 un format valable."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Une valeur doit \352tre introduite pour le temps."), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La temps %s n'est pas dans l'intervalle %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Le temps %s est inf\351rieur \340 %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Le temps %s est sup\351rieur \340 %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_ERROR_SYSTEM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Erreur"), ZAF_MSG_TITLE, ZAF_NULLP(ZafStringIDChar), 'E', 0 },
	{ ZAF_ITEXT("OK"), ZAF_MSG_OK, ZAF_NULLP(ZafStringIDChar), 'O', 0 },
	{ ZAF_ITEXT("Annuler"), ZAF_MSG_CANCEL, ZAF_NULLP(ZafStringIDChar), 'A', 0 },
	{ ZAF_ITEXT("Help"), ZAF_MSG_HELP, ZAF_NULLP(ZafStringIDChar), 'H', 0 },
	{ ZAF_ITEXT("Asterisque"), ZAF_MSG_ICONNAME, ZAF_NULLP(ZafStringIDChar), 'T', 2 },
	{ ZAF_ITEXT("D\351placer"), ZAF_MSG_MOVE, ZAF_NULLP(ZafStringIDChar), 'D', 0 },
	{ ZAF_ITEXT("Fermer\tAlt+F4"), ZAF_MSG_CLOSE, ZAF_NULLP(ZafStringIDChar), 'F', 0 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_FILE_DIALOG_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultFileStrings[] =
{
	{ ZAF_ITEXT("File New"), ZAF_MSG_NEW, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("File Open"), ZAF_MSG_OPEN, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("File Save"), ZAF_MSG_SAVEAS, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_HELP_SYSTEM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultHelpStrings[] =
{
	{ ZAF_ITEXT("Th\351me de l'Aide"), ZAF_MSG_HELP_TOPIC, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Indexe de l'Aide"), ZAF_MSG_HELP_INDEX, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Affichez un Th\351me"), ZAF_MSG_SHOW_TOPIC, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Affichez un Indexe"), ZAF_MSG_SHOW_INDEX, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Choisissez un Th\351me"), ZAF_MSG_MESSAGE1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Tapez un mot, ou choisissez en un de la liste."), ZAF_MSG_MESSAGE2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Fermez"), ZAF_MSG_CLOSE, ZAF_NULLP(ZafStringIDChar), 'F', 0 },
	{ ZAF_ITEXT("Information sur l'Aide"), ZAF_MSG_ICONTITLE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("QUESTION"), ZAF_MSG_ICONNAME, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_SYSTEM_BUTTON_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultStrings[] =
{
	{ ZAF_ITEXT("R\351tablir"), ZAF_RESTORE_OPTION, ZAF_NULLP(ZafStringIDChar), 'R', 0 },	// S_RESTORE
	{ ZAF_ITEXT("D\351placer"), ZAF_MOVE_OPTION, ZAF_NULLP(ZafStringIDChar), 'P', 2 },		// S_MOVE_MODE
	{ ZAF_ITEXT("Dimensionner"), ZAF_SIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'D', 0 },		// S_SIZE_MODE
	{ ZAF_ITEXT("Minimiser"), ZAF_MINIMIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'N', 2 },	// S_MINIMIZE
	{ ZAF_ITEXT("Maximiser"), ZAF_MAXIMIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'X', 2 },	// S_MAXIMIZE
	{ ZAF_ITEXT(""), ZAF_SEPARATOR, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Fermer"), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'F', 0 },			// S_CLOSE
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_POPUP_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultPopupStrings[] =
{
#	if defined(ZAF_MACINTOSH)
	{ ZAF_ITEXT("Quit"), ZAF_EXIT_OPTION, ZAF_NULLP(ZafStringIDChar), 'Q', -1 },
	{ ZAF_ITEXT("Fermer"), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'W', -1 },
	{ ZAF_ITEXT("Cut"), ZAF_CUT_OPTION, ZAF_NULLP(ZafStringIDChar), 'X', -1 },
	{ ZAF_ITEXT("Copy"), ZAF_COPY_OPTION, ZAF_NULLP(ZafStringIDChar), 'C', -1 },
	{ ZAF_ITEXT("Paste"), ZAF_PASTE_OPTION, ZAF_NULLP(ZafStringIDChar), 'V', -1 },
#	else
	{ ZAF_ITEXT("Exit"), ZAF_EXIT_OPTION, ZAF_NULLP(ZafStringIDChar), 'X', 1 },
	{ ZAF_ITEXT("Fermer"), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'F', 0 },
	{ ZAF_ITEXT("Cut\tCtl+X"), ZAF_CUT_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Copy\tCtl+C"), ZAF_COPY_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Paste\tCtl+V"), ZAF_PASTE_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
#	endif
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_WINDOW_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("ERREUR"), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_MESSAGE_WINDOW_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultMessageStrings[] =
{
	{ ZAF_ITEXT("OK"), ZAF_DIALOG_OK, ZAF_NULLP(ZafStringIDChar), 'O', 0 },
	{ ZAF_ITEXT("Oui"), ZAF_DIALOG_YES, ZAF_NULLP(ZafStringIDChar), 'O', 0 },
	{ ZAF_ITEXT("Non"), ZAF_DIALOG_NO, ZAF_NULLP(ZafStringIDChar), 'N', 0 },
	{ ZAF_ITEXT("Avorter"), ZAF_DIALOG_ABORT, ZAF_NULLP(ZafStringIDChar), 'A', 0 },
	{ ZAF_ITEXT("R\351essayer"), ZAF_DIALOG_RETRY, ZAF_NULLP(ZafStringIDChar), 'R', 0 },
	{ ZAF_ITEXT("Ignorer"), ZAF_DIALOG_IGNORE, ZAF_NULLP(ZafStringIDChar), 'I', 0 },
	{ ZAF_ITEXT("Annuler"), ZAF_DIALOG_CANCEL, ZAF_NULLP(ZafStringIDChar), 'N', 1 },
	{ ZAF_ITEXT("Aide"), ZAF_DIALOG_HELP, ZAF_NULLP(ZafStringIDChar), 'D', 2 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif
