//	Zinc Application Framework - LANG_DE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

// In error statements, the %1%s is the data, the %2%s is the range.

#if defined(ZAF_LANGUAGE_INFO)
#	define langCodeset	CP_ISO8859_1
	// Language definitions for German (DE).
	static ZafIChar ZAF_FARDATA defaultLanguageName[] = { 'd','e',0 };
#endif

#if defined(ZAF_LANGUAGE_DATA_INFO)
ZafIChar ZafLanguageData::blankString[] = ZAF_ITEXT("");
ZafIChar ZafLanguageData::errorString[] = ZAF_ITEXT("Fehler");
#endif

#if defined(ZAF_UTIME_DATA_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultDayStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Sonntag"),	ZAF_DAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Montag"),	ZAF_DAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dienstag"),	ZAF_DAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mittwoch"),	ZAF_DAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Donnerstag"),	ZAF_DAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Freitag"),	ZAF_DAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Samstag"),	ZAF_DAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Son"),	ZAF_SHDAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mon"),	ZAF_SHDAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die"),	ZAF_SHDAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mit"),	ZAF_SHDAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Don"),	ZAF_SHDAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Fre"),	ZAF_SHDAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Sam"),	ZAF_SHDAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("So."),	ZAF_ABDAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mo."),	ZAF_ABDAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Di."),	ZAF_ABDAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mi."),	ZAF_ABDAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Do."),	ZAF_ABDAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Fr."),	ZAF_ABDAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Sa."),	ZAF_ABDAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
static ZafLanguageStruct ZAF_FARDATA defaultMonthStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Januar"),	ZAF_MON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Februar"),	ZAF_MON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("M\344rz"),	ZAF_MON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("April"),	ZAF_MON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mai"),	ZAF_MON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Juni"),	ZAF_MON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Juli"),	ZAF_MON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("August"),	ZAF_MON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("September"),	ZAF_MON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Oktober"),	ZAF_MON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("November"),	ZAF_MON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dezember"),	ZAF_MON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jan"),	ZAF_SHMON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Feb"),	ZAF_SHMON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("M\344r"),	ZAF_SHMON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Apr"),	ZAF_SHMON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mai"),	ZAF_SHMON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jun"),	ZAF_SHMON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jul"),	ZAF_SHMON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Aug"),	ZAF_SHMON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Sep"),	ZAF_SHMON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Okt"),	ZAF_SHMON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Nov"),	ZAF_SHMON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dez"),	ZAF_SHMON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jan."),	ZAF_ABMON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Feb."),	ZAF_ABMON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("M\344rz"),	ZAF_ABMON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Apr."),	ZAF_ABMON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mai"),	ZAF_ABMON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Juni"),	ZAF_ABMON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Juli"),	ZAF_ABMON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Aug."),	ZAF_ABMON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Sept."),	ZAF_ABMON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Okt."),	ZAF_ABMON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Nov."),	ZAF_ABMON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dez."),	ZAF_ABMON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
static ZafLanguageStruct ZAF_FARDATA defaultTimeStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("vorm."), ZAF_AM, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("nachm."), ZAF_PM, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("xxxx"), ZAF_TZ, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_UTIME_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Die Uhrzeit %s ist in einem ung\374ltigen Format angegeben."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Es mu\337 eine Uhrzeit angegeben werden."), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Uhrzeit %s ist nicht im Bereich %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Uhrzeit %s ist vor %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Uhrzeit %s ist nach %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_BIGNUM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Die Zahl %s ist ung\374ltig."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Zahl %s ist nicht im Bereich %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Zahl %s ist kleiner als %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Zahl %s ist gr\366\337er als %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_INTEGER_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Die Zahl %s ist ung\374ltig."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Zahl %s ist nicht im Bereich %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Zahl %s ist kleiner als %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Zahl %s ist gr\366\337er als %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_REAL_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Die Zahl %s ist ung\374ltig."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Zahl %s ist nicht im Bereich %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Zahl %s ist kleiner als %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Zahl %s ist gr\366\337er als %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_DATE_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Das Datum %s ist in einem ung\374ltigen Format angegeben."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Das Datum %s enth\344lt keinen eindeutigen Monatsnamen."), ZAF_ERROR_AMBIGUOUS, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Das Datum %s enth\344lt einen ung\374ltigen Monatsnamen."), ZAF_ERROR_INVALID_NAME, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Es mu\337 ein Datum angegeben werden."), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Das Datum %s ist nicht im Bereich %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Das Datum %s ist vor dem %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Das Datum %s ist nach dem %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_TIME_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Die Uhrzeit %s ist in einem ung\374ltigen Format angegeben."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Es mu\337 eine Uhrzeit angegeben werden."), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Uhrzeit %s ist nicht im Bereich %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Uhrzeit %s ist vor %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Die Uhrzeit %s ist nach %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_ERROR_SYSTEM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Fehler"), ZAF_MSG_TITLE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("OK"), ZAF_MSG_OK, ZAF_NULLP(ZafStringIDChar), 'O', 0 },
	{ ZAF_ITEXT("Abbrechen"), ZAF_MSG_CANCEL, ZAF_NULLP(ZafStringIDChar), 'A', 0 },
	{ ZAF_ITEXT("Help"), ZAF_MSG_HELP, ZAF_NULLP(ZafStringIDChar), 'H', 0 },
	{ ZAF_ITEXT("ASTERISK"), ZAF_MSG_ICONNAME, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Verschieben"), ZAF_MSG_MOVE, ZAF_NULLP(ZafStringIDChar), 'V', 0 },
	{ ZAF_ITEXT("Beenden\tAlt+F4"), ZAF_MSG_CLOSE, ZAF_NULLP(ZafStringIDChar), 'B', 0 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_FILE_DIALOG_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultFileStrings[] =
{
	{ ZAF_ITEXT("File New"), ZAF_MSG_NEW, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("File Open"), ZAF_MSG_OPEN, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("File Save"), ZAF_MSG_SAVEAS, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_HELP_SYSTEM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultHelpStrings[] =
{
	{ ZAF_ITEXT("Hilfe Thema"), ZAF_MSG_HELP_TOPIC, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Hilfe Index"), ZAF_MSG_HELP_INDEX, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Thema anzeigen"), ZAF_MSG_SHOW_TOPIC, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Index anzeigen"), ZAF_MSG_SHOW_INDEX, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Markieren Sie ein Thema"), ZAF_MSG_MESSAGE1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Geben Sie ein Wort ein, order markieren Sie eines in der Liste."), ZAF_MSG_MESSAGE2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Schlie\337en"), ZAF_MSG_CLOSE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Hilfe Informationen"), ZAF_MSG_ICONTITLE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("QUESTION"), ZAF_MSG_ICONNAME, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_SYSTEM_BUTTON_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultStrings[] =
{
	{ ZAF_ITEXT("Wiederherstellen"), ZAF_RESTORE_OPTION, ZAF_NULLP(ZafStringIDChar), 'W', 0 },	// S_RESTORE
	{ ZAF_ITEXT("Verschieben"), ZAF_MOVE_OPTION, ZAF_NULLP(ZafStringIDChar), 'V', 0 },			// S_MOVE_MODE
	{ ZAF_ITEXT("Gr\366\337e"), ZAF_SIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'G', 0 },			// S_SIZE_MODE
	{ ZAF_ITEXT("Symbol"), ZAF_MINIMIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'Y', 1 },			// S_MINIMIZE
	{ ZAF_ITEXT("Vollbild"), ZAF_MAXIMIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'V', 0 },			// S_MAXIMIZE
	{ ZAF_ITEXT(""), ZAF_SEPARATOR, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Beenden"), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'B', 0 },				// S_CLOSE
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_POPUP_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultPopupStrings[] =
{
#	if defined(ZAF_MACINTOSH)
	{ ZAF_ITEXT("Quit"), ZAF_EXIT_OPTION, ZAF_NULLP(ZafStringIDChar), 'Q', -1 },
	{ ZAF_ITEXT("Beenden"), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'W', -1 },
	{ ZAF_ITEXT("Cut"), ZAF_CUT_OPTION, ZAF_NULLP(ZafStringIDChar), 'X', -1 },
	{ ZAF_ITEXT("Copy"), ZAF_COPY_OPTION, ZAF_NULLP(ZafStringIDChar), 'C', -1 },
	{ ZAF_ITEXT("Paste"), ZAF_PASTE_OPTION, ZAF_NULLP(ZafStringIDChar), 'V', -1 },
#	else
	{ ZAF_ITEXT("Exit"), ZAF_EXIT_OPTION, ZAF_NULLP(ZafStringIDChar), 'X', 1 },
	{ ZAF_ITEXT("Beenden"), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'B', 0 },
	{ ZAF_ITEXT("Cut\tCtl+X"), ZAF_CUT_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Copy\tCtl+C"), ZAF_COPY_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Paste\tCtl+V"), ZAF_PASTE_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
#	endif
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_WINDOW_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("FEHLER"), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_MESSAGE_WINDOW_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultMessageStrings[] =
{
	{ ZAF_ITEXT("OK"), ZAF_DIALOG_OK, ZAF_NULLP(ZafStringIDChar), 'O', 0 },
	{ ZAF_ITEXT("Ja"), ZAF_DIALOG_YES, ZAF_NULLP(ZafStringIDChar), 'J', 0 },
	{ ZAF_ITEXT("Nein"), ZAF_DIALOG_NO, ZAF_NULLP(ZafStringIDChar), 'N', 0 },
	{ ZAF_ITEXT("Abbruch"), ZAF_DIALOG_ABORT, ZAF_NULLP(ZafStringIDChar), 'A', 0 },
	{ ZAF_ITEXT("Wiederholen"), ZAF_DIALOG_RETRY, ZAF_NULLP(ZafStringIDChar), 'W', 0 },
	{ ZAF_ITEXT("Ignorieren"), ZAF_DIALOG_IGNORE, ZAF_NULLP(ZafStringIDChar), 'I', 0 },
	{ ZAF_ITEXT("Beenden"), ZAF_DIALOG_CANCEL, ZAF_NULLP(ZafStringIDChar), 'B', 0 },
	{ ZAF_ITEXT("Hilfe"), ZAF_DIALOG_HELP, ZAF_NULLP(ZafStringIDChar), 'H', 0 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif
