//	Zinc Application Framework - LANG_CA.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

// In error statements, the %1%s is the data, the %2%s is the range.

#if defined(ZAF_LANGUAGE_INFO)
#	define langCodeset	CP_ISO8859_1
	// Language definitions for CATALAN (CA).
	static ZafIChar ZAF_FARDATA defaultLanguageName[] = { 'c','a',0 };
#endif

#if defined(ZAF_LANGUAGE_DATA_INFO)
ZafIChar ZafLanguageData::blankString[] = ZAF_ITEXT("");
ZafIChar ZafLanguageData::errorString[] = ZAF_ITEXT("Error");
#endif

#if defined(ZAF_UTIME_DATA_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultDayStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Diumenge"),	ZAF_DAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dilluns"),	ZAF_DAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dimarts"),	ZAF_DAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dimecres"),	ZAF_DAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dijous"),	ZAF_DAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Divendres"),	ZAF_DAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dissabte"),	ZAF_DAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Diu"),	ZAF_SHDAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dill"),	ZAF_SHDAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dima"),	ZAF_SHDAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dime"),	ZAF_SHDAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dij"),	ZAF_SHDAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Div"),	ZAF_SHDAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dis"),	ZAF_SHDAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dium."),	ZAF_ABDAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dill."),	ZAF_ABDAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dimar."),	ZAF_ABDAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dimecr."),	ZAF_ABDAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dijous."),	ZAF_ABDAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Diven."),	ZAF_ABDAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dissab."),	ZAF_ABDAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
static ZafLanguageStruct ZAF_FARDATA defaultMonthStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar) },
	{ ZAF_ITEXT("Gener"),	ZAF_MON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Febrer"),	ZAF_MON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mar\347"),	ZAF_MON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Abril"),	ZAF_MON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Maig"),	ZAF_MON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Juny"),	ZAF_MON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Juliol"),	ZAF_MON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Agost"),	ZAF_MON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Setembre"),	ZAF_MON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Octubre"),	ZAF_MON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Novembre"),	ZAF_MON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Desembre"),	ZAF_MON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Gen"),	ZAF_SHMON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Feb"),	ZAF_SHMON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mar"),	ZAF_SHMON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Abr"),	ZAF_SHMON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mai"),	ZAF_SHMON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jun"),	ZAF_SHMON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jul"),	ZAF_SHMON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Ago"),	ZAF_SHMON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Set"),	ZAF_SHMON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Oct"),	ZAF_SHMON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Nov"),	ZAF_SHMON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Des"),	ZAF_SHMON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Gen."),	ZAF_ABMON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Feb."),	ZAF_ABMON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mar\347."),	ZAF_ABMON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Abr."),	ZAF_ABMON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mai."),	ZAF_ABMON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jun."),	ZAF_ABMON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jul."),	ZAF_ABMON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Ago."),	ZAF_ABMON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Set."),	ZAF_ABMON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Oct."),	ZAF_ABMON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Nov."),	ZAF_ABMON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Des."),	ZAF_ABMON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
static ZafLanguageStruct ZAF_FARDATA defaultTimeStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("a.m."), ZAF_AM, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("p.m."), ZAF_PM, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("xxxx"), ZAF_TZ, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_UTIME_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("L'hora %s no \351s en un format v\340lid."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("S'ha de introduir un valor d'hora."), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("L'hora %s no est\341 dintre del rang %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("L'hora %s \351s anterior a %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("L'hora %s \351s posterior a %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_BIGNUM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("El n\372mero %s no \351s v\341lid."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s no est\341 dintre del rang %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s \351s inferior a %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s \351s superior a %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_INTEGER_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("El n\372mero %s no \351s v\341lid."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s no est\341 dintre del rang %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s \351s inferior a %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s \351s superior a %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_REAL_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("El n\372mero %s no \351s v\341lid."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s no est\341 dintre del rang %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s \351s inferior a %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s \351s superior a %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_DATE_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("La data %s no \351s un format v\341lid."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El nom del mes de la data %s es ambig\374u."), ZAF_ERROR_AMBIGUOUS, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El nom del mes de la data %s no \351s v\341lid."), ZAF_ERROR_INVALID_NAME, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("S'ha de introduir un valor de data."), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La data %s no est\341 dintre del rang %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La data %s \351s anterior a %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La data %s \351s posterior a %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_TIME_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("L'hora %s no \351s en un format v\340lid."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("S'ha de introduir un valor d'hora."), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("L'hora %s no est\341 dintre del rang %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("L'hora %s \351s anterior a %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("L'hora %s \351s posterior a %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_ERROR_SYSTEM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Error"), ZAF_MSG_TITLE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Acceptar"), ZAF_MSG_OK, ZAF_NULLP(ZafStringIDChar), 'A', 0 },
	{ ZAF_ITEXT("Cancelar"), ZAF_MSG_CANCEL, ZAF_NULLP(ZafStringIDChar), 'C', 0 },
	{ ZAF_ITEXT("Help"), ZAF_MSG_HELP, ZAF_NULLP(ZafStringIDChar), 'H', 0 },
	{ ZAF_ITEXT("ASTERISK"), ZAF_MSG_ICONNAME, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Moure"), ZAF_MSG_MOVE, ZAF_NULLP(ZafStringIDChar), 'M', 0 },
	{ ZAF_ITEXT("Tancar\tAlt+F4"), ZAF_MSG_CLOSE, ZAF_NULLP(ZafStringIDChar), 'T', 0 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_FILE_DIALOG_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultFileStrings[] =
{
	{ ZAF_ITEXT("File New"), ZAF_MSG_NEW, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("File Open"), ZAF_MSG_OPEN, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("File Save"), ZAF_MSG_SAVEAS, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_HELP_SYSTEM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultHelpStrings[] =
{
	{ ZAF_ITEXT("Help Topic"), ZAF_MSG_HELP_TOPIC, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Help Index"), ZAF_MSG_HELP_INDEX, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Show Topic"), ZAF_MSG_SHOW_TOPIC, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Show Index"), ZAF_MSG_SHOW_INDEX, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Select A Topic"), ZAF_MSG_MESSAGE1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Type a word, or select one from the list."), ZAF_MSG_MESSAGE2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Close"), ZAF_MSG_CLOSE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Informaci\363 d'ajuda"), ZAF_MSG_ICONTITLE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("QUESTION"), ZAF_MSG_ICONNAME, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_SYSTEM_BUTTON_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultStrings[] =
{
	{ ZAF_ITEXT("Restaurar"), ZAF_RESTORE_OPTION, ZAF_NULLP(ZafStringIDChar), 'R', 0 },		// S_RESTORE
	{ ZAF_ITEXT("Moure"), ZAF_MOVE_OPTION, ZAF_NULLP(ZafStringIDChar), 'M', 0 },			// S_MOVE_MODE
	{ ZAF_ITEXT("Tamany"), ZAF_SIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'T', 0 },			// S_SIZE_MODE
	{ ZAF_ITEXT("Minimitzar"), ZAF_MINIMIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'N', 2 },	// S_MINIMIZE
	{ ZAF_ITEXT("Maximitzar"), ZAF_MAXIMIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'X', 2 },	// S_MAXIMIZE
	{ ZAF_ITEXT(""), ZAF_SEPARATOR, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Tancar"), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'T', 0 },			// S_CLOSE
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_POPUP_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultPopupStrings[] =
{
#	if defined(ZAF_MACINTOSH)
	{ ZAF_ITEXT("Quit"), ZAF_EXIT_OPTION, ZAF_NULLP(ZafStringIDChar), 'Q', -1 },
	{ ZAF_ITEXT("Tancar"), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'W', -1 },
	{ ZAF_ITEXT("Cut"), ZAF_CUT_OPTION, ZAF_NULLP(ZafStringIDChar), 'X', -1 },
	{ ZAF_ITEXT("Copy"), ZAF_COPY_OPTION, ZAF_NULLP(ZafStringIDChar), 'C', -1 },
	{ ZAF_ITEXT("Paste"), ZAF_PASTE_OPTION, ZAF_NULLP(ZafStringIDChar), 'V', -1 },
#	else
	{ ZAF_ITEXT("Exit"), ZAF_EXIT_OPTION, ZAF_NULLP(ZafStringIDChar), 'X', 1 },
	{ ZAF_ITEXT("Tancar"), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'T', 0 },
	{ ZAF_ITEXT("Cut\tCtl+X"), ZAF_CUT_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Copy\tCtl+C"), ZAF_COPY_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Paste\tCtl+V"), ZAF_PASTE_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
#	endif
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_WINDOW_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("ERROR"), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_MESSAGE_WINDOW_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultMessageStrings[] =
{
	{ ZAF_ITEXT("OK"), ZAF_DIALOG_OK, ZAF_NULLP(ZafStringIDChar), 'O', 0 },
	{ ZAF_ITEXT("Si"), ZAF_DIALOG_YES, ZAF_NULLP(ZafStringIDChar), 'S', 0 },
	{ ZAF_ITEXT("No"), ZAF_DIALOG_NO, ZAF_NULLP(ZafStringIDChar), 'N', 0 },
	{ ZAF_ITEXT("Abortar"), ZAF_DIALOG_ABORT, ZAF_NULLP(ZafStringIDChar), 'A', 0 },
	{ ZAF_ITEXT("Tornar-hi"), ZAF_DIALOG_RETRY, ZAF_NULLP(ZafStringIDChar), 'T', 0 },
	{ ZAF_ITEXT("Ignorar"), ZAF_DIALOG_IGNORE, ZAF_NULLP(ZafStringIDChar), 'I', 0 },
	{ ZAF_ITEXT("Cancel.lar"), ZAF_DIALOG_CANCEL, ZAF_NULLP(ZafStringIDChar), 'C', 0 },
	{ ZAF_ITEXT("Ajuda"), ZAF_DIALOG_HELP, ZAF_NULLP(ZafStringIDChar), 'A', 0 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif
