//	Zinc Application Framework - LANG2DAT.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#define CP_ISO8859_1	1
#define CP_UNICODE	2
#define CP_OTHER	3

#include <string.h>
#include <z_winall.hpp>
#include <z_utime.hpp>
#include <z_store.hpp>
#include <z_datall.hpp>
#include <z_dlgall.hpp>
#include <z_i18n.hpp>

#if !defined(LANGUAGE_NAME)

#include <stdio.h>
#if defined(ZAF_MACINTOSH)
#	include <console.h>
#endif
#define VERSION	"5.00"

#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
extern unsigned _stklen = 32767;
#endif

typedef void (*ZafLanguageFunction)(ZafDataPersistence *persist);

#if defined(ZAF_UNICODE)
	extern void _el_Initialize(ZafDataPersistence *persist);
	extern void _ja_Initialize(ZafDataPersistence *persist);
	extern void _ko_Initialize(ZafDataPersistence *persist);
#else
	extern void _ca_Initialize(ZafDataPersistence *persist);
	extern void _da_Initialize(ZafDataPersistence *persist);
	extern void _de_Initialize(ZafDataPersistence *persist);
	extern void _en_Initialize(ZafDataPersistence *persist);
	extern void _es_Initialize(ZafDataPersistence *persist);
	extern void _fi_Initialize(ZafDataPersistence *persist);
	extern void _fr_Initialize(ZafDataPersistence *persist);
	extern void _it_Initialize(ZafDataPersistence *persist);
	extern void _nl_Initialize(ZafDataPersistence *persist);
	extern void _no_Initialize(ZafDataPersistence *persist);
	extern void _sv_Initialize(ZafDataPersistence *persist);
#endif

ZafLanguageFunction Initialize[] = 
{
#if defined(ZAF_UNICODE)
	_el_Initialize,	// Greek
	_ja_Initialize,	// Japanese
	_ko_Initialize,	// Korean
#else
	_ca_Initialize,	// Catalan
	_da_Initialize,	// Danish
	_de_Initialize,	// German
	_en_Initialize,	// English
	_es_Initialize,	// Spanish
	_fi_Initialize,	// Finnish
	_fr_Initialize,	// French
	_it_Initialize,	// Italian
	_nl_Initialize,	// Dutch
	_no_Initialize,	// Norwegian
	_sv_Initialize,	// Swedish
#endif
	ZAF_NULLF(ZafLanguageFunction)
};

int main(int argc, char *argv[])
{
	// allocate the default locale and character mapping.
	ZafI18nData::I18nAllocate();

#if defined(ZAF_MACINTOSH)
	argc = ccommand(&argv);
#endif
#if defined(ZAF_UNICODE)
	ZafIChar *pathName = ZIL_INTERNATIONAL::ISOtoUNICODE(argv[0]);
#else
	ZafIChar *pathName = strdup(argv[0]);
#endif
	// Display version.
	printf("Version %s Copyright (C) 1990-1997 Zinc Software Incorporated.\n\n", VERSION);
	if (argc != 2)
	{
		printf("Usage: lang2dat <filename>\n");
		return (1);
	}
#if defined(ZAF_UNICODE)
	ZafStorage *storage = new ZafStorage(ZIL_INTERNATIONAL::ISOtoUNICODE(argv[1]), ZAF_FILE_OPENCREATE | ZAF_FILE_READWRITE);
#else
	ZafStorage *storage = new ZafStorage(argv[1], ZAF_FILE_OPENCREATE | ZAF_FILE_READWRITE);
#endif
//	ZIL_I18N::defaultStorage = storage;
	if (storage->Error())
	{
		printf("There was an error in the storage\n");
		delete storage;
		return -1;
	}
	ZafDataPersistence *persist = new ZafDataPersistence(storage);
	for (int i = 0; Initialize[i]; i++)
		Initialize[i](persist);
	storage->Save();
	delete persist;
	delete storage;
	return (0);
}

#else

#define str(s)		#s
#define xstr(s)		str(s)
#define append(a,b,c)	a##b##c
#define FILELANG(x)	append(lang_, x, .cpp)
#define FUNCTIONNAME(x)	append(_, x, _Initialize)

#define ZAF_LANGUAGE_INFO
#include xstr(FILELANG(LANGUAGE_NAME))
#undef ZAF_LANGUAGE_INFO

static ZafLanguageData *SetLanguageStrings(const ZafIChar *className, ZafLanguageStruct *defaultLanguage)
{
	ZafLanguageData *def = new ZafLanguageData;
	ZafIChar temp[40];
	strcpy(temp, className);
	strcat(temp, ZAF_ITEXT("."));
	strcat(temp, defaultLanguageName);
	def->SetStringID(temp);
//	def->SetStringID(className);
//	def->SetStringID(defaultLanguageName);
	def->SetLanguage(defaultLanguage);
	return def;
}

static void Do_Utime(ZafDataPersistence *persist)
{
#define ZAF_UTIME_DATA_INFO
#include xstr(FILELANG(LANGUAGE_NAME))
#undef ZAF_UTIME_DATA_INFO
	ZafLanguageData *tmp = SetLanguageStrings(ZafUTimeData::DayName(), defaultDayStrings);
	tmp->Write(*persist);
	tmp = SetLanguageStrings(ZafUTimeData::MonthName(), defaultMonthStrings);
	tmp->Write(*persist);
	tmp = SetLanguageStrings(ZafUTimeData::TimeName(), defaultTimeStrings);
	tmp->Write(*persist);
	delete tmp;
}

static void Do_Bignum(ZafDataPersistence *persist)
{
#define ZAF_BIGNUM_INFO
#include xstr(FILELANG(LANGUAGE_NAME))
#undef ZAF_BIGNUM_INFO
	ZafLanguageData *tmp = SetLanguageStrings(ZafBignumData::className, defaultErrorStrings);
	tmp->Write(*persist);
	delete tmp;
}

static void Do_Int(ZafDataPersistence *persist)
{
#define ZAF_INTEGER_INFO
#include xstr(FILELANG(LANGUAGE_NAME))
#undef ZAF_INTEGER_INFO
	ZafLanguageData *tmp = SetLanguageStrings(ZafIntegerData::className, defaultErrorStrings);
	tmp->Write(*persist);
	delete tmp;
}

static void Do_Real(ZafDataPersistence *persist)
{
#define ZAF_REAL_INFO
#include xstr(FILELANG(LANGUAGE_NAME))
#undef ZAF_REAL_INFO
	ZafLanguageData *tmp = SetLanguageStrings(ZafRealData::className, defaultErrorStrings);
	tmp->Write(*persist);
	delete tmp;
}

static void Do_Date(ZafDataPersistence *persist)
{
#define ZAF_DATE_INFO
#include xstr(FILELANG(LANGUAGE_NAME))
#undef ZAF_DATE_INFO
	ZafLanguageData *tmp = SetLanguageStrings(ZafDateData::className, defaultErrorStrings);
	tmp->Write(*persist);
	delete tmp;
}

static void Do_Time(ZafDataPersistence *persist)
{
#define ZAF_TIME_INFO
#include xstr(FILELANG(LANGUAGE_NAME))
#undef ZAF_TIME_INFO
	ZafLanguageData *tmp = SetLanguageStrings(ZafTimeData::className, defaultErrorStrings);
	tmp->Write(*persist);
	delete tmp;
}

static void Do_ErrorSystem(ZafDataPersistence *persist)
{
#define ZAF_ERROR_SYSTEM_INFO
#include xstr(FILELANG(LANGUAGE_NAME))
#undef ZAF_ERROR_SYSTEM_INFO
	ZafLanguageData *tmp = SetLanguageStrings(ZafErrorSystem::className, defaultErrorStrings);
	tmp->Write(*persist);
	delete tmp;
}

static void Do_HelpSystem(ZafDataPersistence *persist)
{
#define ZAF_HELP_SYSTEM_INFO
#include xstr(FILELANG(LANGUAGE_NAME))
#undef ZAF_HELP_SYSTEM_INFO
	ZafLanguageData *tmp = SetLanguageStrings(ZafHelpSystem::className, defaultHelpStrings);
	tmp->Write(*persist);
	delete tmp;
}

static void Do_SystemButton(ZafDataPersistence *persist)
{
#define ZAF_SYSTEM_BUTTON_INFO
#include xstr(FILELANG(LANGUAGE_NAME))
#undef ZAF_SYSTEM_BUTTON_INFO
	ZafLanguageData *tmp = SetLanguageStrings(ZafSystemButton::className, defaultStrings);
	tmp->Write(*persist);
	delete tmp;
}

static void Do_Window(ZafDataPersistence *persist)
{
#define ZAF_WINDOW_INFO
#include xstr(FILELANG(LANGUAGE_NAME))
#undef ZAF_WINDOW_INFO
	ZafLanguageData *tmp = SetLanguageStrings(ZafWindow::className, defaultErrorStrings);
	tmp->Write(*persist);
	delete tmp;
}

static void Do_Message_Window(ZafDataPersistence *persist)
{
#define ZAF_MESSAGE_WINDOW_INFO
#include xstr(FILELANG(LANGUAGE_NAME))
#undef ZAF_MESSAGE_WINDOW_INFO
	ZafLanguageData *tmp = SetLanguageStrings(ZafMessageWindow::className, defaultMessageStrings);
	tmp->Write(*persist);
	delete tmp;
}

void FUNCTIONNAME(LANGUAGE_NAME)(ZafDataPersistence *persist)
{
	Do_Utime(persist);
	Do_Bignum(persist);
	Do_Int(persist);
	Do_Real(persist);
	Do_Date(persist);
	Do_Time(persist);
	Do_ErrorSystem(persist);
	Do_HelpSystem(persist);
	Do_SystemButton(persist);
	Do_Window(persist);
	Do_Message_Window(persist);
}
#endif
