# INTERNATIONAL utilities makefile
#    make -f borland.mak dos             (makes the DOS intl utilities)

# Be sure to update your TURBOC.CFG file to include the Zinc paths, e.g.:
#   -I.;C:\ZINC\INCLUDE;C:\BC45\INCLUDE
#   -L.;C:\ZINC\LIB\borland;C:\BC45\LIB
# and your TLINK.CFG file to include the Zinc paths, e.g.:
#   -L.;C:\ZINC\LIB\borland;C:\BC45\LIB

## Compiler and linker: (Add -v to CPP_OPTS and /v to LINK_OPTS for debug.)

# ----- 32 bit Windows compiler options -------------------------------------

W32_CPP=bcc32
W32_LINK=tlink32
W32_LIBRARIAN=tlib
W32_RC=brc32

W32_CPP_OPTS=-c -O1 -x-
W32_LINK_OPTS=-Tpe -aa -c -x
W32_RC_OPTS=-w32
W32_LIB_OPTS=/C /P64

W32_OBJS=c0w32
W32_LIBS=w32_zaf import32 cw32 ctl3d32

.cpp.obw:
	$(W32_CPP) $(W32_CPP_OPTS) -o$*.obw {$< }

.rc.rbj:
	$(W32_RC) -r $(W32_RC_OPTS) -fo$*.rbj $<

# --- Use the next line for PharLap Extended programs. ---
D16_CPP=bcc286
D16_LINK=tlink
D16_LIBRARIAN=tlib

D16_CPP_OPTS=-c -2 -Vf -ml -O1 -x- -V -w
D16_LINK_OPTS= /c /C /x
D16_LIB_OPTS=/C /p32
D16_OBJS=c0pl.obj
D16_DEF=b16.def
# --- Use the next line for Meta Graphics ---
D16_LIBS=phapi bcl286 d16_zaf met_xp2d emu286 emu mathl 

.cpp.o16:
	$(D16_CPP) $(D16_CPP_OPTS) -o$*.o16 {$< }

# ----- Usage --------------------------------------------------------------
usage:
	@echo ...........
	@echo ...........
	@echo To make these Zinc Intl utilities for Borland C++ type:
	@echo make -fborland.mak dos
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean:
	z_clean

# ----- Update --------------------------------------------------------------
update:
	copy locale.* ..\..\bin
	copy language.* ..\..\bin

# --- Dos 16 ------------------------------------------------------
dos16: loc2dat.exe lang2dat.exe map2dat.exe #genloc.exe genlang.exe
#	copy genloc.exe ..\..\bin
#	copy genlang.exe ..\..\bin

dosu: uloc2dat.exe ulang2dat.exe

#genloc.exe: genloc.o16
#	$(D16_LINK) $(D16_LINK_OPTS) @&&!
#$(D16_OBJS)+genloc.o16
#$*, ,$(D16_LIBS),$(D16_DEF)
#!

#genlang.exe: genlang.o16
#	$(D16_LINK) $(D16_LINK_OPTS) @&&!
#$(D16_OBJS)+genlang.o16
#$*, ,$(D16_LIBS),$(D16_DEF)
#!

loc2dat.exe: loc2dat.o16 \
	loc_at.o16 loc_ca.o16 loc_cafr.o16 loc_de.o16 loc_dk.o16 loc_es.o16 \
	loc_fi.o16 loc_fr.o16 loc_gb.o16 loc_it.o16 loc_mx.o16 loc_nl.o16 \
	loc_no.o16 loc_se.o16 loc_us.o16
	$(D16_LINK) $(D16_LINK_OPTS) @&&!
$(D16_OBJS)+loc2dat.o16 \
+loc_at.o16+loc_ca.o16+loc_cafr.o16+loc_de.o16+loc_dk.o16+loc_es.o16 \
+loc_fi.o16+loc_fr.o16+loc_gb.o16+loc_it.o16+loc_mx.o16+loc_nl.o16 \
+loc_no.o16+loc_se.o16+loc_us.o16 
$*, ,$(D16_LIBS),$(D16_DEF)
!

uloc2dat.exe: uloc2dat.o16 \
	loc_cn.o16 loc_gr.o16 loc_jp.o16 loc_kr.o16 loc_tw.o16
	$(D16_LINK) $(D16_LINK_OPTS) @&&!
$(D16_OBJS)+uloc2dat.o16 \
+loc_cn.o16+loc_gr.o16+loc_jp.o16+loc_kr.o16+loc_tw.o16
$*, ,$(D16_LIBS),$(D16_DEF)
!

loc2dat.o16: loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -o$*.o16 loc2dat.cpp
loc_at.o16: loc_at.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=at -o$*.o16 loc2dat.cpp
loc_ca.o16: loc_ca.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=ca -o$*.o16 loc2dat.cpp
loc_cafr.o16: loc_cafr.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=cafr -o$*.o16 loc2dat.cpp
loc_de.o16: loc_de.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=de -o$*.o16 loc2dat.cpp
loc_dk.o16: loc_dk.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=dk -o$*.o16 loc2dat.cpp
loc_es.o16: loc_es.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=es -o$*.o16 loc2dat.cpp
loc_fi.o16: loc_fi.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=fi -o$*.o16 loc2dat.cpp
loc_fr.o16: loc_fr.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=fr -o$*.o16 loc2dat.cpp
loc_gb.o16: loc_gb.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=gb -o$*.o16 loc2dat.cpp
loc_it.o16: loc_it.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=it -o$*.o16 loc2dat.cpp
loc_mx.o16: loc_mx.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=mx -o$*.o16 loc2dat.cpp
loc_nl.o16: loc_nl.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=nl -o$*.o16 loc2dat.cpp
loc_no.o16: loc_no.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=no -o$*.o16 loc2dat.cpp
loc_se.o16: loc_se.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=se -o$*.o16 loc2dat.cpp
loc_us.o16: loc_us.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=us -o$*.o16 loc2dat.cpp

uloc2dat.o16: loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -o$*.o16 loc2dat.cpp
loc_cn.o16: loc_cn.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=cn -o$*.o16 loc2dat.cpp
loc_gr.o16: loc_gr.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=gr -o$*.o16 loc2dat.cpp
loc_jp.o16: loc_jp.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=jp -o$*.o16 loc2dat.cpp
loc_kr.o16: loc_kr.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=kr -o$*.o16 loc2dat.cpp
loc_tw.o16: loc_tw.cpp loc2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLOCALE_NAME=tw -o$*.o16 loc2dat.cpp

lang2dat.exe: lang2dat.o16 \
	lang_ca.o16 lang_da.o16 lang_de.o16 lang_en.o16 lang_es.o16 \
	lang_fi.o16 lang_fr.o16 lang_it.o16 lang_nl.o16 lang_no.o16 \
	lang_sv.o16 
	$(D16_LINK) $(D16_LINK_OPTS) @&&!
$(D16_OBJS)+lang2dat.o16 \
+lang_ca.o16+lang_da.o16+lang_de.o16+lang_en.o16+lang_es.o16 \
+lang_fi.o16+lang_fr.o16+lang_it.o16+lang_nl.o16+lang_no.o16 \
+lang_sv.o16
$*, ,$(D16_LIBS),$(D16_DEF)
!

ulang2dat.exe: ulang2dat.o16 \
	lang_el.o16 lang_ja.o16 lang_ko.o16
	$(D16_LINK) $(D16_LINK_OPTS) @&&!
$(D16_OBJS)+ulang2dat.o16 \
+lang_el.o16+lang_ja.o16+lang_ko.o16
$*, ,$(D16_LIBS),$(D16_DEF)
!

lang2dat.o16: lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -o$*.o16 lang2dat.cpp
lang_ca.o16: lang_ca.cpp lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLANGUAGE_NAME=ca -o$*.o16 lang2dat.cpp
lang_da.o16: lang_da.cpp lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLANGUAGE_NAME=da -o$*.o16 lang2dat.cpp
lang_de.o16: lang_de.cpp lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLANGUAGE_NAME=de -o$*.o16 lang2dat.cpp
lang_en.o16: lang_en.cpp lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLANGUAGE_NAME=en -o$*.o16 lang2dat.cpp
lang_es.o16: lang_es.cpp lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLANGUAGE_NAME=es -o$*.o16 lang2dat.cpp
lang_fi.o16: lang_fi.cpp lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLANGUAGE_NAME=fi -o$*.o16 lang2dat.cpp
lang_fr.o16: lang_fr.cpp lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLANGUAGE_NAME=fr -o$*.o16 lang2dat.cpp
lang_it.o16: lang_it.cpp lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLANGUAGE_NAME=it -o$*.o16 lang2dat.cpp
lang_nl.o16: lang_nl.cpp lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLANGUAGE_NAME=nl -o$*.o16 lang2dat.cpp
lang_no.o16: lang_no.cpp lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLANGUAGE_NAME=no -o$*.o16 lang2dat.cpp
lang_sv.o16: lang_sv.cpp lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLANGUAGE_NAME=sv -o$*.o16 lang2dat.cpp

ulang2dat.o16: lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -o$*.o16 lang2dat.cpp
lang_el.o16: lang_el.cpp lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLANGUAGE_NAME=el -o$*.o16 lang2dat.cpp
lang_ja.o16: lang_ja.cpp lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLANGUAGE_NAME=ja -o$*.o16 lang2dat.cpp
lang_ko.o16: lang_ko.cpp lang2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DLANGUAGE_NAME=ko -o$*.o16 lang2dat.cpp

map2dat.exe: map2dat.o16 \
	map437.o16 map737.o16 map850.o16 map852.o16 map855.o16 map857.o16 \
	map860.o16 map861.o16 map863.o16 map865.o16 map866.o16 map869.o16 \
	map1250.o16 map1251.o16 map1252.o16 map1253.o16 map1254.o16 \
	map1255.o16 map1256.o16 mapmac.o16 
	$(D16_LINK) $(D16_LINK_OPTS) @&&!
$(D16_OBJS)+map2dat.o16 \
+map437.o16+map737.o16+map850.o16+map852.o16+map855.o16+map857.o16 \
+map860.o16+map861.o16+map863.o16+map865.o16+map866.o16+map869.o16 \
+map1250.o16+map1251.o16+map1252.o16+map1253.o16+map1254.o16 \
+map1255.o16+map1256.o16+mapmac.o16
$*, ,$(D16_LIBS),$(D16_DEF)
!
 
map2dat.o16: map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -o$*.o16 map2dat.cpp
map437.o16: map437.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=437 -o$*.o16 map2dat.cpp
map737.o16: map737.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=737 -o$*.o16 map2dat.cpp
map850.o16: map850.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=850 -o$*.o16 map2dat.cpp
map852.o16: map852.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=852 -o$*.o16 map2dat.cpp
map855.o16: map855.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=855 -o$*.o16 map2dat.cpp
map857.o16: map857.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=857 -o$*.o16 map2dat.cpp
map860.o16: map860.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=860 -o$*.o16 map2dat.cpp
map861.o16: map861.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=861 -o$*.o16 map2dat.cpp
map863.o16: map863.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=863 -o$*.o16 map2dat.cpp
map865.o16: map865.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=865 -o$*.o16 map2dat.cpp
map866.o16: map866.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=866 -o$*.o16 map2dat.cpp
map869.o16: map869.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=869 -o$*.o16 map2dat.cpp
map1250.o16: map1250.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=1250 -o$*.o16 map2dat.cpp
map1251.o16: map1251.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=1251 -o$*.o16 map2dat.cpp
map1252.o16: map1252.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=1252 -o$*.o16 map2dat.cpp
map1253.o16: map1253.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=1253 -o$*.o16 map2dat.cpp
map1254.o16: map1254.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=1254 -o$*.o16 map2dat.cpp
map1255.o16: map1255.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=1255 -o$*.o16 map2dat.cpp
map1256.o16: map1256.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=1256 -o$*.o16 map2dat.cpp
mapmac.o16: mapmac.cpp map2dat.cpp
	$(D16_CPP) $(D16_CPP_OPTS) -DMAP_NAME=MAC -o$*.o16 map2dat.cpp


# --- Windows -----------------------------------------------------
win32: wloc2dat.exe wlang2dat.exe wmap2dat.exe #wgenloc.exe wgenlang.exe
#	copy wgenloc.exe ..\..\bin
#	copy wgenlang.exe ..\..\bin

dosu: uloc2dat.exe ulang2dat.exe

#wgenloc.exe: genloc.obw
#	$(W32_LINK) $(W32_LINK_OPTS) @&&!
#$(W32_OBJS)+genloc.obw
#$*, ,$(W32_LIBS)
#!

#wgenlang.exe: genlang.obw
#	$(W32_LINK) $(W32_LINK_OPTS) @&&!
#$(W32_OBJS)+genlang.obw
#$*, ,$(W32_LIBS)
#!

wloc2dat.exe: loc2dat.obw \
	loc_at.obw loc_ca.obw loc_cafr.obw loc_de.obw loc_dk.obw loc_es.obw \
	loc_fi.obw loc_fr.obw loc_gb.obw loc_it.obw loc_mx.obw loc_nl.obw \
	loc_no.obw loc_se.obw loc_us.obw
	$(W32_LINK) $(W32_LINK_OPTS) @&&!
$(W32_OBJS)+loc2dat.obw \
+loc_at.obw+loc_ca.obw+loc_cafr.obw+loc_de.obw+loc_dk.obw+loc_es.obw \
+loc_fi.obw+loc_fr.obw+loc_gb.obw+loc_it.obw+loc_mx.obw+loc_nl.obw \
+loc_no.obw+loc_se.obw+loc_us.obw
$*, ,$(W32_LIBS)
!

uwloc2dat.exe: uloc2dat.obw \
	loc_cn.obw loc_gr.obw loc_jp.obw loc_kr.obw loc_tw.obw
	$(W32_LINK) $(W32_LINK_OPTS) @&&!
$(W32_OBJS)+uloc2dat.obw \
+loc_cn.obw+loc_gr.obw+loc_jp.obw+loc_kr.obw+loc_tw.obw
$*, ,$(W32_LIBS)
!

loc2dat.obw: loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -o$*.obw loc2dat.cpp
loc_at.obw: loc_at.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=at -o$*.obw loc2dat.cpp
loc_ca.obw: loc_ca.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=ca -o$*.obw loc2dat.cpp
loc_cafr.obw: loc_cafr.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=cafr -o$*.obw loc2dat.cpp
loc_de.obw: loc_de.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=de -o$*.obw loc2dat.cpp
loc_dk.obw: loc_dk.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=dk -o$*.obw loc2dat.cpp
loc_es.obw: loc_es.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=es -o$*.obw loc2dat.cpp
loc_fi.obw: loc_fi.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=fi -o$*.obw loc2dat.cpp
loc_fr.obw: loc_fr.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=fr -o$*.obw loc2dat.cpp
loc_gb.obw: loc_gb.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=gb -o$*.obw loc2dat.cpp
loc_it.obw: loc_it.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=it -o$*.obw loc2dat.cpp
loc_mx.obw: loc_mx.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=mx -o$*.obw loc2dat.cpp
loc_nl.obw: loc_nl.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=nl -o$*.obw loc2dat.cpp
loc_no.obw: loc_no.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=no -o$*.obw loc2dat.cpp
loc_se.obw: loc_se.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=se -o$*.obw loc2dat.cpp
loc_us.obw: loc_us.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=us -o$*.obw loc2dat.cpp

uloc2dat.obw: loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -o$*.obw loc2dat.cpp
loc_cn.obw: loc_cn.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=cn -o$*.obw loc2dat.cpp
loc_gr.obw: loc_gr.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=gr -o$*.obw loc2dat.cpp
loc_jp.obw: loc_jp.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=jp -o$*.obw loc2dat.cpp
loc_kr.obw: loc_kr.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=kr -o$*.obw loc2dat.cpp
loc_tw.obw: loc_tw.cpp loc2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLOCALE_NAME=tw -o$*.obw loc2dat.cpp

wlang2dat.exe: lang2dat.obw \
	lang_ca.obw lang_da.obw lang_de.obw lang_en.obw lang_es.obw \
	lang_fi.obw lang_fr.obw lang_it.obw lang_nl.obw lang_no.obw \
	lang_sv.obw 
	$(W32_LINK) $(W32_LINK_OPTS) @&&!
$(W32_OBJS)+lang2dat.obw \
+lang_ca.obw+lang_da.obw+lang_de.obw+lang_en.obw+lang_es.obw \
+lang_fi.obw+lang_fr.obw+lang_it.obw+lang_nl.obw+lang_no.obw \
+lang_sv.obw
$*, ,$(W32_LIBS)
!

uwlang2dat.exe: ulang2dat.obw \
	lang_el.obw lang_ja.obw lang_ko.obw
	$(W32_LINK) $(W32_LINK_OPTS) @&&!
$(W32_OBJS)+ulang2dat.obw \
+lang_el.obw+lang_ja.obw+lang_ko.obw
$*, ,$(W32_LIBS)
!

lang2dat.obw: lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -o$*.obw lang2dat.cpp
lang_ca.obw: lang_ca.cpp lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLANGUAGE_NAME=ca -o$*.obw lang2dat.cpp
lang_da.obw: lang_da.cpp lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLANGUAGE_NAME=da -o$*.obw lang2dat.cpp
lang_de.obw: lang_de.cpp lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLANGUAGE_NAME=de -o$*.obw lang2dat.cpp
lang_en.obw: lang_en.cpp lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLANGUAGE_NAME=en -o$*.obw lang2dat.cpp
lang_es.obw: lang_es.cpp lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLANGUAGE_NAME=es -o$*.obw lang2dat.cpp
lang_fi.obw: lang_fi.cpp lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLANGUAGE_NAME=fi -o$*.obw lang2dat.cpp
lang_fr.obw: lang_fr.cpp lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLANGUAGE_NAME=fr -o$*.obw lang2dat.cpp
lang_it.obw: lang_it.cpp lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLANGUAGE_NAME=it -o$*.obw lang2dat.cpp
lang_nl.obw: lang_nl.cpp lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLANGUAGE_NAME=nl -o$*.obw lang2dat.cpp
lang_no.obw: lang_no.cpp lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLANGUAGE_NAME=no -o$*.obw lang2dat.cpp
lang_sv.obw: lang_sv.cpp lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLANGUAGE_NAME=sv -o$*.obw lang2dat.cpp

uwlang2dat.obw: lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -o$*.obw lang2dat.cpp
lang_el.obw: lang_el.cpp lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLANGUAGE_NAME=el -o$*.obw lang2dat.cpp
lang_ja.obw: lang_ja.cpp lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLANGUAGE_NAME=ja -o$*.obw lang2dat.cpp
lang_ko.obw: lang_ko.cpp lang2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DLANGUAGE_NAME=ko -o$*.obw lang2dat.cpp

wmap2dat.exe: map2dat.obw \
	map437.obw map737.obw map850.obw map852.obw map855.obw map857.obw \
	map860.obw map861.obw map863.obw map865.obw map866.obw map869.obw \
	map1250.obw map1251.obw map1252.obw map1253.obw map1254.obw \
	map1255.obw map1256.obw mapmac.obw 
	$(W32_LINK) $(W32_LINK_OPTS) @&&!
$(W32_OBJS)+map2dat.obw \
+map437.obw+map737.obw+map850.obw+map852.obw+map855.obw+map857.obw \
+map860.obw+map861.obw+map863.obw+map865.obw+map866.obw+map869.obw \
+map1250.obw+map1251.obw+map1252.obw+map1253.obw+map1254.obw \
+map1255.obw+map1256.obw+mapmac.obw
$*, ,$(W32_LIBS)
!
 
map2dat.obw: map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -o$*.obw map2dat.cpp
map437.obw: map437.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=437 -o$*.obw map2dat.cpp
map737.obw: map737.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=737 -o$*.obw map2dat.cpp
map850.obw: map850.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=850 -o$*.obw map2dat.cpp
map852.obw: map852.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=852 -o$*.obw map2dat.cpp
map855.obw: map855.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=855 -o$*.obw map2dat.cpp
map857.obw: map857.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=857 -o$*.obw map2dat.cpp
map860.obw: map860.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=860 -o$*.obw map2dat.cpp
map861.obw: map861.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=861 -o$*.obw map2dat.cpp
map863.obw: map863.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=863 -o$*.obw map2dat.cpp
map865.obw: map865.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=865 -o$*.obw map2dat.cpp
map866.obw: map866.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=866 -o$*.obw map2dat.cpp
map869.obw: map869.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=869 -o$*.obw map2dat.cpp
map1250.obw: map1250.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=1250 -o$*.obw map2dat.cpp
map1251.obw: map1251.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=1251 -o$*.obw map2dat.cpp
map1252.obw: map1252.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=1252 -o$*.obw map2dat.cpp
map1253.obw: map1253.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=1253 -o$*.obw map2dat.cpp
map1254.obw: map1254.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=1254 -o$*.obw map2dat.cpp
map1255.obw: map1255.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=1255 -o$*.obw map2dat.cpp
map1256.obw: map1256.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=1256 -o$*.obw map2dat.cpp
mapmac.obw: mapmac.cpp map2dat.cpp
	$(W32_CPP) $(W32_CPP_OPTS) -DMAP_NAME=MAC -o$*.obw map2dat.cpp

