//	Zinc Application Framework - Z_TIME1.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_TIME1_HPP)
#define Z_TIME1_HPP
#include <z_time.hpp>
#include <z_str1.hpp>

// --------------------------------------------------------------------------
// ----- ZafTime ------------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafTime : public ZafString
{
public:
	// --- General members ---
	ZafTime(int left, int top, int width,
		ZafTimeData *timeData = ZAF_NULLP(ZafTimeData));
	ZafTime(int left, int top, int width,
		int hour, int minute, int second, int milliSecond = 0);
	ZafTime(const ZafTime &copy);
	virtual ~ZafTime(void);

	// --- Persistent members ---
	ZafTime(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafTimeData *TimeData(void) const;
	// set
	virtual ZafError SetTimeData(ZafTimeData *timeData);

	// --- String members ---
	virtual bool SetLowerCase(bool lowerCase);
	virtual bool SetPassword(bool password);
	virtual ZafError SetStringData(ZafStringData *string);
	virtual bool SetUpperCase(bool upperCase);
	virtual bool SetVariableName(bool variableName);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual ZafError SetText(const ZafIChar *text);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafString::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafString::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSTime;

	// --- General members ---
	virtual ZafWindowObject *Duplicate(void);

	// --- Data access ---
	ZafTimeData *timeData;
	virtual ZafError Decrement(ZafData *data);
	virtual ZafError Increment(ZafData *data);
	static ZafError Update(ZafTime *time, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) return time->OSSetTime();
		  else if (type == ZAF_UPDATE_DATA) return time->OSGetTime();
		  else return (ZAF_ERROR_INVALID); }
	virtual ZafError Validate(bool processError = true);

	// --- Special OS members ---
	ZafError OSGetTime(void);
	ZafError OSSetTime(void);

	// --- Language & locale support ---
	static ZafLanguageData *errorStrings;
	static void LanguageAllocate(void);
	static void LanguageFree(bool globalRequest = false);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafTime::Read); }
	void WriteData(ZafObjectPersistence &persist);
};

// --- inline functions ---
inline ZafTimeData *ZafTime::TimeData(void) const { return timeData; }
inline ZafError ZafTime::SetText(const ZafIChar *text) { return (timeData->SetTime(text, inputFormatData ? inputFormatData->Text() : ZAF_NULLP(ZafIChar))); }

#endif // Z_TIME1_HPP

