//	Zinc Application Framework - Z_TIME.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_TIME_HPP)
#define Z_TIME_HPP
#include <z_utime.hpp>

// --------------------------------------------------------------------------
// ----- ZafTimeData --------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafTimeData : public ZafUTimeData
{
public:
	// -- General members ---
	ZafTimeData(void);
	ZafTimeData(int hour, int minute, int second, int milliSecond);
	ZafTimeData(const ZafIChar *string, const ZafIChar *format = ZAF_NULLP(ZafIChar));
	ZafTimeData(const ZafTimeData &copy);
	ZafTimeData(const ZafUTimeData &copy);
	virtual ~ZafTimeData(void);

	// --- Persistence ---
	ZafTimeData(const ZafIChar *name, ZafDataPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	// --- Attributes & data access ---
	// get
	virtual int FormattedText(ZafIChar *buffer, int maxLength, const ZafIChar *format = 0) const;
	// set
	virtual void Clear(void);
	virtual ZafError SetTime(int hour, int minute, int second, int milliSecond);
	virtual ZafError SetTime(const ZafIChar *buffer, const ZafIChar *format);
	virtual ZafError SetTime(const ZafTimeData &time);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafUTimeData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafUTimeData::IsA(compareName)); }

protected:
	// --- Persistent members --
	virtual ZafDataConstructor ReadFunction(void) { return (ZafTimeData::Read); }

	virtual ZafData *Duplicate(void);
};

#endif // Z_TIME_HPP

