//	Zinc Application Framework - Z_TBAR.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_TBAR_HPP)
#define Z_TBAR_HPP
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafToolBar ---------------------------------------------------------
// --------------------------------------------------------------------------

enum ZafDockType
{
	ZAF_DOCK_TOP 	= 0,
	ZAF_DOCK_LEFT	= 1,
	ZAF_DOCK_BOTTOM	= 2,
	ZAF_DOCK_RIGHT	= 3
};

class ZAF_EXPORT ZafToolBar : public ZafWindow
{
public:
	// --- General members ---
	ZafToolBar(int left, int top, int width, int height);
	ZafToolBar(const ZafToolBar &copy);
	virtual ~ZafToolBar(void);

	// --- Persistent members ---
	ZafToolBar(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafDockType DockType(void) const;
	bool WrapChildren(void) const;
	// set
	virtual ZafDockType SetDockType(ZafDockType dockType);
	virtual bool SetWrapChildren(bool wrapChildren);

	// --- Window members ---
	virtual bool SetDestroyable(bool destroyable);
	virtual bool SetLocked(bool locked);
	virtual bool SetMaximized(bool maximized);
	virtual bool SetMinimized(bool minimized);
	virtual bool SetMoveable(bool moveable);
	virtual bool SetSizeable(bool sizeable);
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual void ConvertRegion(ZafRegionStruct &region, ZafCoordinateType newType);
	virtual ZafRegionStruct ConvertToOSRegion(const ZafWindowObject *object,
		const ZafRegionStruct *zafRegion = ZAF_NULLP(ZafRegionStruct)) const;
	virtual ZafRegionStruct ConvertToZafRegion(const ZafWindowObject *object,
		const ZafRegionStruct *osRegion = ZAF_NULLP(ZafRegionStruct)) const;
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);
	virtual bool SetSupportObject(bool supportObject);

	// --- List members ---
	ZafToolBar &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafToolBar &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- Special OS members ---
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;

protected:
	friend class ZAF_EXPORT OSToolBar;

	// --- General members ---
	ZafDockType dockType;
	bool wrapChildren;

	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafEventType DrawBorder(ZafRegionStruct &region, ZafEventType ccode);
	virtual ZafEventType DrawFocus(ZafRegionStruct &region, ZafEventType ccode);
	virtual ZafWindowObject *Duplicate(void);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);
	virtual ZafRegionStruct MaxRegion(ZafWindowObject *object,
		ZafVtJustify vWeight = ZAF_VT_TOP, ZafHzJustify hWeight = ZAF_HZ_LEFT);

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual void OSRegisterObject(void);
	virtual void OSSize(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafToolBar::Read); }
	void WriteData(ZafObjectPersistence &persist);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
};

// --- inline functions ---
inline ZafDockType ZafToolBar::DockType(void) const { return dockType; }
inline bool ZafToolBar::WrapChildren(void) const { return wrapChildren; }

#endif // Z_TBAR_HPP

