//	Zinc Application Framework - Z_TABLE.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_TABLE_HPP)
#define Z_TABLE_HPP
#include <z_win.hpp>
#include <z_data.hpp>

// --------------------------------------------------------------------------
// ----- ZafTable -----------------------------------------------------------
// --------------------------------------------------------------------------

// ----- ZafTableHeader -----------------------------------------------------

enum ZafTableHeaderType
{
	ZAF_CORNER_HEADER,
	ZAF_COLUMN_HEADER,
	ZAF_ROW_HEADER
};

class ZAF_EXPORT ZafTableHeader : public ZafWindow
{
public:
	// --- General members ---
	ZafTableHeader(int width, int height,
		ZafTableHeaderType headerType = ZAF_ROW_HEADER);
	ZafTableHeader(const ZafTableHeader &copy);
	virtual ~ZafTableHeader(void);

	// --- Persistent members ---
	ZafTableHeader(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafTableHeaderType HeaderType(void) const;
	ZafWindowObject *VirtualField(void) const;
	// set
	virtual ZafTableHeaderType SetHeaderType(ZafTableHeaderType headerType);
	virtual ZafWindowObject *SetVirtualField(ZafWindowObject *virtualField);

	// --- Window members ---
	virtual bool SetDestroyable(bool destroyable);
	virtual bool SetLocked(bool locked);
	virtual bool SetMaximized(bool maximized);
	virtual bool SetMinimized(bool minimized);
	virtual bool SetMoveable(bool moveable);
	virtual ZafSelectionType SetSelectionType(ZafSelectionType selectionType);
	virtual bool SetSizeable(bool sizeable);
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual void ConvertRegion(ZafRegionStruct &region, ZafCoordinateType newType);
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetBordered(bool bordered);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetFocus(bool currentFocus);
	virtual const ZafIChar *SetHelpContext(const ZafIChar *helpContext);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);
	virtual bool SetSupportObject(bool supportObject);
	virtual ZafUserFunction SetUserFunction(ZafUserFunction userFunction);

	// --- List members ---
	virtual ZafWindowObject *Add(ZafWindowObject *object, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject));
	virtual ZafWindowObject *Subtract(ZafWindowObject *object);

	ZafTableHeader &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafTableHeader &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- Special OS members ---
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;

protected:
	friend class ZAF_EXPORT OSTableHeader;
	friend class ZAF_EXPORT ZafTable;

	// --- General members ---
	ZafTableHeaderType headerType;
	ZafWindowObject *virtualField;

	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafEventType DrawBorder(ZafRegionStruct &region, ZafEventType ccode);
	virtual ZafWindowObject *Duplicate(void);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Special OS members ---
	virtual void OSRegisterObject(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafTableHeader::Read); }
	void WriteData(ZafObjectPersistence &persist);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
};

// --- inline functions ---
inline ZafTableHeaderType ZafTableHeader::HeaderType(void) const { return headerType; }
inline ZafWindowObject *ZafTableHeader::VirtualField(void) const { return virtualField; }

// ----- ZafTableRecord -----------------------------------------------------

class ZAF_EXPORT ZafTableRecord : public ZafWindow
{
public:
	// --- General members ---
	ZafTableRecord(int width, int height);
	ZafTableRecord(const ZafTableRecord &copy);

	// --- Persistent members ---
	ZafTableRecord(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafOffset Offset(void) const;
	// set
	virtual ZafOffset SetOffset(ZafOffset offset);

	// --- Window members ---
	virtual bool SetDestroyable(bool destroyable);
	virtual bool SetLocked(bool locked);
	virtual bool SetMaximized(bool maximized);
	virtual bool SetMinimized(bool minimized);
	virtual bool SetMoveable(bool moveable);
	virtual ZafSelectionType SetSelectionType(ZafSelectionType selectionType);
	virtual bool SetSizeable(bool sizeable);
	virtual bool SetSupportObject(bool supportObject);
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual void ConvertRegion(ZafRegionStruct &region, ZafCoordinateType newType);
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetBordered(bool bordered);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual bool SetParentDrawFocus(bool parentDrawFocus);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);

	// --- List & Element members ---
	virtual ZafWindowObject *Add(ZafWindowObject *object, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject));
	ZafTableRecord *Next(void) const { return((ZafTableRecord *)next); }
	ZafTableRecord *Previous(void) const { return((ZafTableRecord *)previous); }
	virtual ZafWindowObject *Subtract(ZafWindowObject *object);

	ZafTableRecord &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafTableRecord &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- Special OS members ---
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;

protected:
	friend class ZAF_EXPORT OSTableRecord;
	friend class ZAF_EXPORT ZafTable;

	void SetVirtualData(ZafEventType ccode);

	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafWindowObject *Duplicate(void);
	virtual ZafWindowObject *NotifyFocus(ZafWindowObject *object, bool focus);

	// --- Special OS members ---
	virtual void OSRegisterObject(void);

	// --- Persistent members ---
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafTableRecord::Read); }

private:
	ZafOffset offset;
};

// --- inline functions ---
inline ZafOffset ZafTableRecord::Offset(void) const { return (offset); }

// ----- ZafTable -----------------------------------------------------------

class ZAF_EXPORT ZafTable : public ZafWindow 
{
public:
	// --- General members ---
	ZafTable(int left, int top, int width, int height);
	ZafTable(const ZafTable &copy);
	virtual ~ZafTable(void);

	// --- Persistent members ---
	ZafTable(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	virtual ZafError DeleteRecord(void);
	virtual ZafError InsertRecord(ZafTableRecord *record, ZafWindowObject *row);
	virtual ZafError ReadRecord(ZafTableRecord *record, ZafWindowObject *row);
	virtual ZafError SeekNextRecord(void);
	virtual ZafError SeekPreviousRecord(void);
	virtual ZafError SeekRandomRecord(ZafOffset offset, ZafSeek location);
	virtual ZafOffset Tell(void);
	virtual ZafError WriteRecord(ZafTableRecord *record, ZafWindowObject *row);
	// get
	ZafOffset CurrentOffset(void) const;
	bool Grid(void) const;
	ZafOffset MaxOffset(void) const;
	ZafTableRecord *VirtualRecord(void) const;
	// set
	virtual ZafOffset SetCurrentOffset(ZafOffset currentOffset);
	virtual bool SetGrid(bool grid);
	virtual ZafOffset SetMaxOffset(ZafOffset maxOffset);
	virtual ZafTableRecord *SetVirtualRecord(ZafTableRecord *virtualRecord);

	// --- Window members ---
	virtual bool SetDestroyable(bool destroyable);
	virtual bool SetLocked(bool locked);
	virtual bool SetMaximized(bool maximized);
	virtual bool SetMinimized(bool minimized);
	virtual bool SetMoveable(bool moveable);
	virtual bool SetSizeable(bool sizeable);
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	ZafLogicalEvent LogicalEvent(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);

	// --- List members ---
	virtual ZafWindowObject *Add(ZafWindowObject *object, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject));
	ZafTableRecord *Current(void) const { return((ZafTableRecord *)current); }
	ZafTableRecord *First(void) const { return((ZafTableRecord *)first); }
	ZafTableRecord *Get(int index) { return((ZafTableRecord *)ZafList::Get(index)); }
	ZafTableRecord *Last(void) const { return((ZafTableRecord *)last); }
	virtual ZafWindowObject *Subtract(ZafWindowObject *object);

	ZafTable &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafTable &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- Special OS members ---
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;

protected:
	friend class ZAF_EXPORT OSTable;

	// --- General members ---
	ZafTableRecord *virtualRecord;
	ZafOffset currentOffset, maxOffset;
	bool grid;

	bool ShiftRecords(long delta, ZafOffset newOffset = -1,
		ZafWindowObject *newFocus = ZAF_NULLP(ZafWindowObject));

	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafWindowObject *Duplicate(void);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);
	virtual ZafEventType MoveEvent(const ZafEventStruct &event);
	virtual ZafEventType ScrollEvent(const ZafEventStruct &event);
	ZafError SeekOptimized(ZafOffset offset);

	ZafTableHeader *ColumnTableHeader(void);
	ZafTableHeader *RowTableHeader(void);

	// --- Special OS members ---
	virtual void OSRegisterObject(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafTable::Read); }
	void WriteData(ZafObjectPersistence &persist);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
	static ZafEventMap ZAF_FARDATA defaultEventMap[];
};

// --- inline functions ---
inline ZafOffset ZafTable::CurrentOffset(void) const { return (currentOffset); }
inline bool ZafTable::Grid(void) const { return (grid); }
inline ZafOffset ZafTable::MaxOffset(void) const { return (maxOffset); }
inline ZafTableRecord *ZafTable::VirtualRecord(void) const { return (virtualRecord); }

#endif // Z_TABLE_HPP

